/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.DecoderException;
import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import com.enterprisedt.bouncycastle.util.encoders.EncoderException;
import com.enterprisedt.bouncycastle.util.encoders.HexEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Hex {
    private static final Encoder a = new HexEncoder();

    public static String toHexString(byte[] data) {
        return Hex.toHexString(data, 0, data.length);
    }

    public static String toHexString(byte[] data, int off, int length) {
        byte[] byArray = Hex.encode(data, off, length);
        return Strings.fromByteArray(byArray);
    }

    public static byte[] encode(byte[] data) {
        return Hex.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int off, int length) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            a.encode(data, off, length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new EncoderException("exception encoding Hex string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return a.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        return a.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            a.decode(data, 0, data.length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new DecoderException("exception decoding Hex data: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decode(String data) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            a.decode(data, byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new DecoderException("exception decoding Hex string: " + exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return a.decode(data, out);
    }
}

