/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mac;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import xjava.security.Parameterized;

public class HMAC
extends MessageDigest
implements Cloneable,
Parameterized {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("HMAC") : 0;
    private MessageDigest c;
    private int d;
    private int e;
    private byte[] f;

    private static void a(String string) {
        Debug.log("HMAC: " + string);
    }

    public HMAC(String mdAlgorithm, int mdBlockSize) {
        super("HMAC-" + mdAlgorithm);
        try {
            this.c = MessageDigest.getInstance(mdAlgorithm, "CryptixEDT");
        }
        catch (Exception exception) {
            try {
                HMAC.a("Algorithm " + mdAlgorithm + " not found in provider " + "CryptixEDT" + " - trying other providers");
                this.c = MessageDigest.getInstance(mdAlgorithm);
                HMAC.a("Found " + this.c.getClass().getName());
            }
            catch (Exception exception2) {
                throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + mdAlgorithm + " MessageDigest\n" + exception2);
            }
        }
        this.d = mdBlockSize;
        this.e = this.c.digest().length;
        this.f = new byte[mdBlockSize];
    }

    private HMAC(HMAC mac) throws CloneNotSupportedException {
        super(mac.getAlgorithm());
        this.c = (MessageDigest)mac.c.clone();
        this.d = mac.d;
        this.e = mac.e;
        byte[] byArray = mac.f;
        this.f = byArray == null ? null : (byte[])byArray.clone();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new HMAC(this);
    }

    @Override
    protected void engineReset() {
        this.c.reset();
        this.f = null;
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.f == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        this.c.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        if (this.f == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        this.c.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        int n2;
        if (a && b >= 7) {
            HMAC.a("engineDigest()");
        }
        if (this.f == null) {
            throw new IllegalStateException(this.getAlgorithm() + ": Key has not been set");
        }
        byte[] byArray = this.c.digest();
        byte[] byArray2 = new byte[this.d];
        for (n2 = 0; n2 < this.f.length; ++n2) {
            byArray2[n2] = (byte)(0x5C ^ this.f[n2]);
        }
        for (n2 = this.f.length; n2 < this.d; ++n2) {
            byArray2[n2] = 92;
        }
        this.c.update(byArray2);
        byte[] byArray3 = this.c.digest(byArray);
        if (a && b >= 7) {
            HMAC.a("... = <" + Hex.toString(byArray3) + ">");
        }
        return byArray3;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.e;
    }

    @Override
    public void setParameter(String param, Object value) throws InvalidParameterException {
        this.engineSetParameter(param, value);
    }

    @Override
    public Object getParameter(String param) throws InvalidParameterException {
        return this.engineGetParameter(param);
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        try {
            if (param.equalsIgnoreCase("key")) {
                this.a((byte[])value);
                return;
            }
            if (this.f != null) {
                throw new InvalidParameterException(this.getAlgorithm() + ": Can't set parameter after key has been initialised");
            }
            ((Parameterized)((Object)this.c)).setParameter(param, value);
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        try {
            return ((Parameterized)((Object)this.c)).getParameter(param);
        }
        catch (Exception exception) {
            throw new InvalidParameterException(exception.getMessage());
        }
    }

    private void a(byte[] byArray) {
        int n2;
        if (a && b >= 7) {
            HMAC.a("setKey(<" + Hex.toString(byArray) + ">)");
        }
        if (this.f != null) {
            this.c.reset();
        }
        this.f = byArray.length > this.d ? this.c.digest(byArray) : (byte[])byArray.clone();
        byte[] byArray2 = new byte[this.d];
        for (n2 = 0; n2 < this.f.length; ++n2) {
            byArray2[n2] = (byte)(0x36 ^ this.f[n2]);
        }
        for (n2 = this.f.length; n2 < this.d; ++n2) {
            byArray2[n2] = 54;
        }
        this.c.update(byArray2);
    }
}

