/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.mode;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.mode.a;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class CFB
extends a {
    private byte[] b;

    public CFB() {
        super(true, false, "CryptixEDT");
    }

    public CFB(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public CFB(Cipher cipher, byte[] iv) {
        this(cipher);
        this.setInitializationVector(iv);
    }

    @Override
    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.b = new byte[this.length];
    }

    @Override
    protected int engineBlockSize() {
        return 1;
    }

    @Override
    protected void engineInitEncrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    @Override
    protected void engineInitDecrypt(Key newkey) throws KeyException {
        this.cipher.initEncrypt(newkey);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        this.currentByte = this.length;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("CFB: IV is not set");
        }
        if (in == out && outOffset > inOffset && (long)outOffset < (long)inOffset + (long)inLen) {
            byte[] byArray = new byte[inLen];
            System.arraycopy(in, inOffset, byArray, 0, inLen);
            in = byArray;
            inOffset = 0;
        }
        switch (this.getState()) {
            case 1: {
                for (int i2 = 0; i2 < inLen; ++i2) {
                    out[i2 + outOffset] = this.a(in[i2 + inOffset]);
                }
                break;
            }
            case 2: {
                for (int i3 = 0; i3 < inLen; ++i3) {
                    out[i3 + outOffset] = this.b(in[i3 + inOffset]);
                }
                break;
            }
            default: {
                throw new CryptixException("CFB: Cipher not initialized");
            }
        }
        return inLen;
    }

    private byte a(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            if (this.ivStart == null) {
                this.ivStart = new byte[this.length];
                System.arraycopy(this.ivBlock, 0, this.ivStart, 0, this.length);
            }
            this.cipher.update(this.ivBlock, 0, this.length, this.b, 0);
        }
        this.ivBlock[this.currentByte] = by = (byte)(by ^ this.b[this.currentByte]);
        ++this.currentByte;
        return by;
    }

    private byte b(byte by) {
        if (this.currentByte >= this.length) {
            this.currentByte = 0;
            if (this.ivStart == null) {
                this.ivStart = new byte[this.length];
                System.arraycopy(this.ivBlock, 0, this.ivStart, 0, this.length);
            }
            this.cipher.update(this.ivBlock, 0, this.length, this.b, 0);
        }
        this.ivBlock[this.currentByte] = by;
        by = (byte)(by ^ this.b[this.currentByte]);
        ++this.currentByte;
        return by;
    }

    protected void next_block() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.ivBlock, this.currentByte, byArray, 0, this.length - this.currentByte);
        System.arraycopy(this.ivBlock, 0, byArray, this.length - this.currentByte, this.currentByte);
        this.ivBlock = byArray;
        this.currentByte = this.length;
    }
}

