/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.math;

import com.enterprisedt.cryptix.util.math.BigRegister;
import java.io.Serializable;

public class TrinomialLFSR
extends BigRegister
implements Serializable,
Cloneable {
    private int a;
    private int b;
    private int c;
    private int d;
    private static final long serialVersionUID = -8054549768481919515L;
    private transient TrinomialLFSR[] e;

    public TrinomialLFSR(int l2, int k2) {
        super(l2);
        if (k2 < 1 || k2 > l2 - 1) {
            throw new IllegalArgumentException();
        }
        this.a = l2;
        this.b = k2;
        this.d = Math.min(this.b, this.a - this.b);
        this.c = Math.min(64, this.d);
    }

    @Override
    public Object clone() {
        TrinomialLFSR trinomialLFSR = new TrinomialLFSR(this.a, this.b);
        trinomialLFSR.load(this);
        return trinomialLFSR;
    }

    public void clock(int ticks) {
        if (ticks < 1) {
            return;
        }
        int n2 = ticks % this.c;
        if (n2 != 0) {
            this.engineClock(n2);
            ticks -= n2;
        }
        while (ticks > 0) {
            this.engineClock(this.c);
            ticks -= this.c;
        }
    }

    protected void engineClock(int ticks) {
        long l2 = this.getBits(this.a - ticks, ticks) ^ this.getBits(this.a - this.b - ticks, ticks);
        this.shiftLeft(ticks);
        if (l2 != 0L) {
            this.setBits(0, ticks, l2);
        }
    }

    private void a(int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n2 % this.d;
        if (n3 != 0) {
            this.clock(n3);
            n2 -= n3;
        }
        while (n2 > 0) {
            BigRegister bigRegister = (BigRegister)this.clone();
            BigRegister bigRegister2 = (BigRegister)this.clone();
            bigRegister2.shiftLeft(this.d);
            bigRegister2.xor(bigRegister);
            bigRegister2.shiftRight(this.a - this.d);
            this.shiftLeft(this.d);
            this.or(bigRegister2);
            n2 -= this.d;
        }
    }

    public long next(int count) {
        if (count < 1) {
            return 0L;
        }
        long l2 = this.getBits(this.a - count, count);
        this.clock(count);
        return l2;
    }

    public void add(TrinomialLFSR gx) {
        if (!this.isSameGroup(gx)) {
            throw new IllegalArgumentException();
        }
        this.xor(gx);
    }

    public void subtract(TrinomialLFSR gx) {
        this.add(gx);
    }

    public void multiply(TrinomialLFSR gx) {
        if (!this.isSameGroup(gx)) {
            throw new IllegalArgumentException();
        }
        if (gx.countSetBits() == 0) {
            this.reset();
            return;
        }
        TrinomialLFSR trinomialLFSR = new TrinomialLFSR(this.a, this.b);
        TrinomialLFSR trinomialLFSR2 = null;
        for (int i2 = 0; i2 < this.a; ++i2) {
            if (!gx.testBit(i2)) continue;
            trinomialLFSR.load(this);
            int n2 = this.degreeAt(i2);
            if (n2 != 0) {
                trinomialLFSR.a(n2);
            }
            if (trinomialLFSR2 == null) {
                trinomialLFSR2 = (TrinomialLFSR)trinomialLFSR.clone();
                continue;
            }
            trinomialLFSR2.add(trinomialLFSR);
        }
        this.load(trinomialLFSR2);
    }

    public static TrinomialLFSR multiply(TrinomialLFSR p2, TrinomialLFSR q2) {
        TrinomialLFSR trinomialLFSR;
        if (!p2.isSameGroup(q2)) {
            throw new IllegalArgumentException();
        }
        if (p2.countSetBits() > q2.countSetBits()) {
            trinomialLFSR = (TrinomialLFSR)p2.clone();
            trinomialLFSR.multiply(q2);
        } else {
            trinomialLFSR = (TrinomialLFSR)q2.clone();
            trinomialLFSR.multiply(p2);
        }
        return trinomialLFSR;
    }

    public void pow(BigRegister n2) {
        int n3;
        if (n2.getSize() > this.a) {
            throw new IllegalArgumentException();
        }
        int n4 = n2.highestSetBit();
        if (n4 == 0) {
            return;
        }
        if (n4 == -1) {
            this.resetX(0);
            return;
        }
        TrinomialLFSR trinomialLFSR = this.trinomialOne();
        TrinomialLFSR trinomialLFSR2 = (TrinomialLFSR)this.clone();
        if (this.e == null) {
            this.e = new TrinomialLFSR[this.a];
        }
        if (!this.isSameValue(this.e[0])) {
            this.e[0] = (TrinomialLFSR)trinomialLFSR2.clone();
            for (n3 = 1; n3 < this.a; ++n3) {
                trinomialLFSR2.multiply(trinomialLFSR2);
                this.e[n3] = (TrinomialLFSR)trinomialLFSR2.clone();
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (!n2.testBit(n3)) continue;
            trinomialLFSR = TrinomialLFSR.multiply(this.e[n3], trinomialLFSR);
        }
        trinomialLFSR2 = this.e[n3];
        this.load(TrinomialLFSR.multiply(trinomialLFSR, trinomialLFSR2));
    }

    public void resetX(int n2) {
        this.reset();
        this.setX(n2);
    }

    public void setX(int n2) {
        this.setBit(this.indexOfX(n2));
    }

    public int indexOfX(int degree) {
        if (degree < 0 || degree >= this.a) {
            throw new IllegalArgumentException();
        }
        int n2 = degree - this.b;
        if (n2 < 0) {
            n2 += this.a;
        }
        return n2;
    }

    public int degreeAt(int index) {
        if (index < 0 || index >= this.a) {
            throw new IllegalArgumentException();
        }
        return (index + this.b) % this.a;
    }

    public TrinomialLFSR trinomialOne() {
        TrinomialLFSR trinomialLFSR = (TrinomialLFSR)this.clone();
        trinomialLFSR.resetX(0);
        return trinomialLFSR;
    }

    public TrinomialLFSR trinomialX() {
        TrinomialLFSR trinomialLFSR = (TrinomialLFSR)this.clone();
        trinomialLFSR.resetX(1);
        return trinomialLFSR;
    }

    @Override
    public int getSize() {
        return this.a;
    }

    public int getMidTap() {
        return this.b;
    }

    public int getSlice() {
        return this.c;
    }

    public boolean isSameValue(TrinomialLFSR x2) {
        if (x2 == null || x2.b != this.b) {
            return false;
        }
        return super.isSameValue(x2);
    }

    public int compareTo(TrinomialLFSR x2) {
        if (this.a > x2.a) {
            return 1;
        }
        if (this.a < x2.a) {
            return -1;
        }
        if (this.b > x2.b) {
            return 1;
        }
        if (this.b < x2.b) {
            return -1;
        }
        BigRegister bigRegister = this.toBigRegister();
        BigRegister bigRegister2 = x2.toBigRegister();
        return bigRegister.compareTo(bigRegister2);
    }

    public boolean isSameGroup(TrinomialLFSR x2) {
        return x2 != null && this.a == x2.a && this.b == x2.b;
    }

    public BigRegister toBigRegister() {
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.rotateLeft(this.b);
        return bigRegister;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.a + 64);
        stringBuffer.append("[...\n TrinomialLFSR <").append(this.a).append(", x").append(this.a).append(" + ").append(this.b == 1 ? "x" : "x" + this.b).append(" + 1").append(">...\n").append(" current state is: ").append(super.toString()).append("...]\n");
        return stringBuffer.toString();
    }

    public String toPolynomial() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(' ');
        int n2 = this.a;
        boolean bl = true;
        while (--n2 >= 0) {
            if (!this.testBit(this.indexOfX(n2))) continue;
            if (bl) {
                bl = !bl;
            } else {
                stringBuffer.append(" + ");
            }
            if (n2 != 0) {
                stringBuffer.append('x');
                if (n2 == 1) continue;
                stringBuffer.append(n2);
                continue;
            }
            stringBuffer.append('1');
        }
        if (bl) {
            stringBuffer.append('0');
        }
        return stringBuffer.append(' ').toString();
    }
}

