/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.pro.ProFTPClient;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;

public class FTPClientFactory {
    public static ProFTPClientInterface createClient(Protocol protocol) throws FTPException {
        return FTPClientFactory.createClient(protocol, true);
    }

    public static ProFTPClientInterface createClient(Protocol protocol, boolean serverValidation) throws FTPException {
        if (protocol.equals(Protocol.FTP)) {
            return new ProFTPClient();
        }
        if (protocol.equals(Protocol.SFTP)) {
            SSHFTPClient sSHFTPClient = new SSHFTPClient();
            if (!serverValidation) {
                sSHFTPClient.getValidator().setHostValidationEnabled(false);
            }
            return sSHFTPClient;
        }
        if (protocol.equals(Protocol.FTPS_EXPLICIT)) {
            SSLFTPClient sSLFTPClient = new SSLFTPClient();
            if (!serverValidation) {
                sSLFTPClient.setValidateServer(false);
            }
            return sSLFTPClient;
        }
        if (protocol.equals(Protocol.FTPS_IMPLICIT)) {
            SSLFTPClient sSLFTPClient = new SSLFTPClient();
            sSLFTPClient.setImplicitFTPS(true);
            if (!serverValidation) {
                sSLFTPClient.setValidateServer(false);
            }
            return sSLFTPClient;
        }
        throw new FTPException("Unknown protocol: " + protocol.toString());
    }
}

