/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class NetwareFileParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: NetwareFileParser.java,v 1.2 2010-03-31 00:54:48 bruceb Exp $";
    private static Logger a = Logger.getLogger("NetwareFileParser");
    private SimpleDateFormat b;

    public NetwareFileParser() {
        this.setLocale(Locale.getDefault());
    }

    @Override
    public void setLocale(Locale locale) {
        this.b = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", locale);
    }

    public String toString() {
        return "NETWARE";
    }

    @Override
    public boolean isValidFormat(String[] listing) {
        int n2 = Math.min(listing.length, 10);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (listing[i2].trim().length() == 0 || !NetwareFileParser.isNetware(listing[i2])) continue;
            return true;
        }
        a.debug("Not in Netware format");
        return false;
    }

    public static boolean isNetware(String raw) {
        if ((raw = raw.trim()).length() < 3) {
            return false;
        }
        char c2 = raw.charAt(0);
        char c3 = raw.charAt(2);
        return (c2 == '-' || c2 == 'd') && c3 == '[';
    }

    @Override
    public FTPFile parse(String raw) throws ParseException {
        Date date;
        Calendar calendar;
        long l2;
        String string;
        String string2;
        boolean bl;
        block13: {
            if (!NetwareFileParser.isNetware(raw)) {
                return null;
            }
            String[] stringArray = this.split(raw);
            if (stringArray.length < 8) {
                StringBuffer stringBuffer = new StringBuffer("Unexpected number of fields in listing '");
                stringBuffer.append(raw).append("' - expected minimum ").append(8).append(" fields but found ").append(stringArray.length).append(" fields");
                a.warn(stringBuffer.toString());
                return null;
            }
            int n2 = 0;
            bl = false;
            char c2 = raw.charAt(0);
            if (c2 == 'd') {
                bl = true;
            }
            if ((string2 = stringArray[++n2]).charAt(0) == '[' && string2.charAt(string2.length() - 1) == ']') {
                string2 = string2.substring(1);
                string2 = string2.substring(0, string2.length() - 1);
            }
            string = stringArray[++n2];
            l2 = 0L;
            String string3 = stringArray[++n2];
            try {
                l2 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                a.warn("Failed to parse size: " + string3);
            }
            String string4 = stringArray[++n2];
            String string5 = stringArray[++n2];
            String string6 = stringArray[++n2];
            String string7 = "00:00";
            calendar = Calendar.getInstance();
            if (string6.indexOf(58) > 0) {
                string7 = string6;
                string6 = Integer.toString(calendar.get(1));
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            stringBuffer.append('-');
            stringBuffer.append(string5);
            stringBuffer.append('-');
            stringBuffer.append(string6);
            stringBuffer.append('-');
            stringBuffer.append(string7);
            date = null;
            try {
                date = this.b.parse(stringBuffer.toString());
            }
            catch (ParseException parseException) {
                if (this.ignoreDateParseErrors) break block13;
                throw new DateParseException(parseException.getMessage());
            }
        }
        calendar.add(5, 2);
        if (date != null && date.after(calendar.getTime())) {
            calendar.setTime(date);
            calendar.add(1, -1);
            date = calendar.getTime();
        }
        String string8 = raw.trim();
        for (int i2 = 0; i2 < 7; ++i2) {
            int n3 = string8.indexOf(32);
            if (n3 <= 0) {
                string8 = null;
                a.debug("Failed to extract filename");
                break;
            }
            string8 = string8.substring(n3).trim();
        }
        if (string8.startsWith("./")) {
            string8 = string8.substring("./".length());
        }
        FTPFile fTPFile = new FTPFile(raw, string8, l2, bl, date);
        fTPFile.setOwner(string);
        fTPFile.setPermissions(string2);
        return fTPFile;
    }
}

