/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ModifiedTimeResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;
import java.util.Date;

public class GetModifiedTimeTask
extends Task {
    private static Logger a = Logger.getLogger("GetModifiedTimeTask");
    private ModifiedTimeResult b;
    private AsyncCallback.GetModifiedTime c;

    public GetModifiedTimeTask(FTPTaskProcessor taskProcessor, ModifiedTimeResult result, AsyncCallback.GetModifiedTime callback) {
        super(taskProcessor, TaskType.h, result);
        this.b = result;
        this.c = callback;
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                Date date = conn.getClient().modtime(conn.convertPath(this.b.getRemoteFileName()));
                this.b.setModifiedTime(date);
                this.b.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            this.b.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.b.notifyComplete();
        this.b.setLocalContext(this.getContext());
        if (this.c != null) {
            try {
                this.c.onGetModifiedTime(this.b);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.b, throwable);
            }
        }
        this.b.setLocalContext(null);
        try {
            if (!this.b.endAsyncCalled()) {
                this.b.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.b, throwable);
        }
    }

    @Override
    public String toString() {
        return this.getId() + ":Get" + this.getTaskType().getName() + "[" + this.b.getRemoteFileName() + "]";
    }
}

