/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh;

import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.connection.ChannelEventListener;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ScpClient {
    private SshClient a;
    private File b;
    private boolean c;
    private ChannelEventListener d;

    public ScpClient(SshClient ssh, boolean verbose, ChannelEventListener eventListener) {
        this(new File(ConfigurationLoader.checkAndGetProperty("user.dir", ".")), ssh, verbose, eventListener);
    }

    public ScpClient(File cwd, SshClient ssh, boolean verbose, ChannelEventListener eventListener) {
        this.a = ssh;
        this.b = cwd;
        this.c = verbose;
        this.d = eventListener;
    }

    public void put(InputStream in, long length, String localFile, String remoteFile) throws IOException {
        a a2 = new a("scp -t " + (this.c ? "-v " : "") + remoteFile);
        a2.addEventListener(this.d);
        if (!this.a.openChannel(a2)) {
            throw new IOException("Failed to open SCP channel");
        }
        a2.c();
        a2.a(in, length, localFile);
        a2.close();
    }

    public InputStream get(String remoteFile) throws IOException {
        a a2 = new a("scp -f " + (this.c ? "-v " : "") + remoteFile);
        a2.addEventListener(this.d);
        if (!this.a.openChannel(a2)) {
            throw new IOException("Failed to open SCP Channel");
        }
        return a2.a();
    }

    public void put(String localFile, String remoteFile, boolean recursive) throws IOException {
        File file = new File(localFile);
        if (!file.isAbsolute()) {
            file = new File(this.b, localFile);
        }
        if (!file.exists()) {
            throw new IOException(localFile + " does not exist");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException(localFile + " is not a regular file or directory");
        }
        if (file.isDirectory() && !recursive) {
            throw new IOException(localFile + " is a directory, use recursive mode");
        }
        if (remoteFile == null || remoteFile.equals("")) {
            remoteFile = ".";
        }
        a a2 = new a("scp " + (file.isDirectory() ? "-d " : "") + "-t " + (recursive ? "-r " : "") + (this.c ? "-v " : "") + remoteFile);
        a2.addEventListener(this.d);
        if (!this.a.openChannel(a2)) {
            throw new IOException("Failed to open SCP channel");
        }
        a2.c();
        a2.b(file, recursive);
        a2.close();
    }

    public void put(String[] localFiles, String remoteFile, boolean recursive) throws IOException {
        if (remoteFile == null || remoteFile.equals("")) {
            remoteFile = ".";
        }
        if (localFiles.length == 1) {
            this.put(localFiles[0], remoteFile, recursive);
        } else {
            a a2 = new a("scp -d -t " + (recursive ? "-r " : "") + (this.c ? "-v " : "") + remoteFile);
            a2.addEventListener(this.d);
            if (!this.a.openChannel(a2)) {
                throw new IOException("Failed to open SCP channel");
            }
            a2.c();
            for (int i2 = 0; i2 < localFiles.length; ++i2) {
                File file = new File(localFiles[i2]);
                if (!file.isAbsolute()) {
                    file = new File(this.b, localFiles[i2]);
                }
                if (!file.isFile() && !file.isDirectory()) {
                    throw new IOException(file.getName() + " is not a regular file or directory");
                }
                a2.b(file, recursive);
            }
            a2.close();
        }
    }

    public void get(String localFile, String[] remoteFiles, boolean recursive) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < remoteFiles.length; ++i2) {
            stringBuffer.append("\"");
            stringBuffer.append(remoteFiles[i2]);
            stringBuffer.append("\" ");
        }
        String string = stringBuffer.toString();
        string = string.trim();
        this.get(localFile, string, recursive);
    }

    public void get(String localFile, String remoteFile, boolean recursive) throws IOException {
        File file;
        if (localFile == null || localFile.equals("")) {
            localFile = ".";
        }
        if (!(file = new File(localFile)).isAbsolute()) {
            file = new File(this.b, localFile);
        }
        if (file.exists() && !file.isFile() && !file.isDirectory()) {
            throw new IOException(localFile + " is not a regular file or directory");
        }
        a a2 = new a("scp -f " + (recursive ? "-r " : "") + (this.c ? "-v " : "") + remoteFile);
        a2.addEventListener(this.d);
        if (!this.a.openChannel(a2)) {
            throw new IOException("Failed to open SCP Channel");
        }
        a2.a(file);
        a2.close();
    }

    class b
    extends InputStream {
        long a;
        InputStream b;
        long c;
        a d;

        b(long l2, InputStream inputStream, a a2) {
            this.a = l2;
            this.b = inputStream;
            this.d = a2;
        }

        @Override
        public int read() throws IOException {
            if (this.c == this.a) {
                return -1;
            }
            if (this.c >= this.a) {
                throw new EOFException("End of file.");
            }
            int n2 = this.b.read();
            if (n2 == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            ++this.c;
            if (this.c == this.a) {
                this.d.c();
                this.d.d();
            }
            return n2;
        }

        @Override
        public void close() throws IOException {
            this.d.close();
        }
    }

    class a
    extends SessionChannelClient {
        byte[] a = new byte[16384];
        String b;

        a(String string) {
            this.b = string;
            this.setName("scp");
        }

        @Override
        protected void onChannelOpen() throws IOException {
            if (!this.executeCommand(this.b)) {
                throw new IOException("Failed to execute the command " + this.b);
            }
        }

        private boolean a(File file, boolean bl) throws IOException {
            if (!bl) {
                this.a("File " + file.getName() + " is a directory, use recursive mode");
                return false;
            }
            String string = "D0755 0 " + file.getName() + "\n";
            this.out.write(string.getBytes());
            this.c();
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file2 = new File(file, stringArray[i2]);
                this.b(file2, bl);
            }
            this.out.write("E\n".getBytes());
            return true;
        }

        private void a(InputStream inputStream, long l2, String string) throws IOException {
            String string2 = "C0644 " + l2 + " " + string + "\n";
            this.out.write(string2.getBytes());
            this.c();
            this.a(inputStream, l2);
            this.d();
            this.c();
        }

        private void b(File file, boolean bl) throws IOException {
            if (file.isDirectory()) {
                if (!this.a(file, bl)) {
                    return;
                }
            } else if (file.isFile()) {
                String string = "C0644 " + file.length() + " " + file.getName() + "\n";
                this.out.write(string.getBytes());
                this.c();
                FileInputStream fileInputStream = new FileInputStream(file);
                this.a(fileInputStream, file.length());
                this.d();
            } else {
                throw new IOException(file.getName() + " not valid for SCP");
            }
            this.c();
        }

        private void a(File file) throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.d();
            block7: while (true) {
                try {
                    string = this.b();
                }
                catch (EOFException eOFException) {
                    return;
                }
                char c2 = string.charAt(0);
                switch (c2) {
                    case 'E': {
                        this.d();
                        return;
                    }
                    case 'T': {
                        throw new IOException("SCP time not supported: " + string);
                    }
                    case 'C': 
                    case 'D': {
                        Object object;
                        String string2 = file.getAbsolutePath();
                        this.a(string, stringArray);
                        if (file.isDirectory()) {
                            string2 = string2 + File.separator + stringArray[2];
                        }
                        File file2 = new File(string2);
                        if (c2 == 'D') {
                            if (file2.exists()) {
                                if (!file2.isDirectory()) {
                                    object = "Invalid target " + file2.getName() + ", must be a directory";
                                    this.a((String)object);
                                    throw new IOException((String)object);
                                }
                            } else if (!file2.mkdir()) {
                                object = "Could not create directory: " + file2.getName();
                                this.a((String)object);
                                throw new IOException((String)object);
                            }
                            this.a(file2);
                            continue block7;
                        }
                        object = new FileOutputStream(file2);
                        this.d();
                        long l2 = Long.parseLong(stringArray[1]);
                        this.a((FileOutputStream)object, l2);
                        this.c();
                        this.d();
                        continue block7;
                    }
                }
                break;
            }
            this.a("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        private InputStream a() throws IOException {
            String string;
            String[] stringArray = new String[3];
            this.d();
            try {
                string = this.b();
            }
            catch (EOFException eOFException) {
                return null;
            }
            char c2 = string.charAt(0);
            switch (c2) {
                case 'E': {
                    this.d();
                    return null;
                }
                case 'T': {
                    throw new IOException("SCP time not supported: " + string);
                }
                case 'D': {
                    throw new IOException("Directories cannot be copied to a stream");
                }
                case 'C': {
                    this.a(string, stringArray);
                    this.d();
                    long l2 = Long.parseLong(stringArray[1]);
                    return new BufferedInputStream(new b(l2, this.in, this), 16384);
                }
            }
            this.a("Unexpected cmd: " + string);
            throw new IOException("SCP unexpected cmd: " + string);
        }

        private void a(String string, String[] stringArray) throws IOException {
            int n2 = string.indexOf(32);
            int n3 = string.indexOf(32, n2 + 1);
            if (n2 == -1 || n3 == -1) {
                this.a("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            stringArray[0] = string.substring(1, n2);
            stringArray[1] = string.substring(n2 + 1, n3);
            stringArray[2] = string.substring(n3 + 1);
        }

        private String b() throws IOException {
            int n2;
            int n3 = 0;
            while ((n2 = this.in.read()) != 10 && n2 >= 0) {
                this.a[n3++] = (byte)n2;
            }
            if (n2 == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            if (this.a[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.a[0] == 2 || this.a[0] == 1) {
                String string = new String(this.a, 1, n3 - 1);
                if (this.a[0] == 2) {
                    throw new IOException(string);
                }
                throw new IOException("SCP returned an unexpected error: " + string);
            }
            return new String(this.a, 0, n3);
        }

        private void c() throws IOException {
            int n2 = this.in.read();
            if (n2 == 0) {
                return;
            }
            if (n2 == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String string = this.b();
            if (n2 == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }

        private void d() throws IOException {
            this.out.write(0);
        }

        private void a(String string) throws IOException {
            this.out.write(1);
            this.out.write(string.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(InputStream inputStream, long l2) throws IOException {
            int n2 = 0;
            try {
                while ((long)n2 < l2) {
                    int n3 = inputStream.read(this.a, 0, (int)(l2 - (long)n2 < (long)this.a.length ? l2 - (long)n2 : (long)this.a.length));
                    if (n3 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n2 += n3;
                    this.out.write(this.a, 0, n3);
                }
            }
            finally {
                inputStream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(FileOutputStream fileOutputStream, long l2) throws IOException {
            int n2 = 0;
            try {
                while ((long)n2 < l2) {
                    int n3 = this.in.read(this.a, 0, (int)(l2 - (long)n2 < (long)this.a.length ? l2 - (long)n2 : (long)this.a.length));
                    if (n3 == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    n2 += n3;
                    fileOutputStream.write(this.a, 0, n3);
                }
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

