/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.InvalidHostFileException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.util.Base64;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import xjava.security.Parameterized;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static Logger a = Logger.getLogger("AbstractKnownHostsKeyVerification");
    private List b = new ArrayList();
    private String c;
    private boolean d = false;
    private boolean e = false;
    private boolean f = true;

    public AbstractKnownHostsKeyVerification(String knownhosts) throws InvalidHostFileException, IOException {
        this.parse(knownhosts);
    }

    public AbstractKnownHostsKeyVerification() {
    }

    @Override
    public boolean isPortsInKnownHosts() {
        return this.f;
    }

    @Override
    public void setPortsInKnownHosts(boolean portsInKnownHosts) {
        this.f = portsInKnownHosts;
    }

    public List getKnownHostEntries() {
        return this.b;
    }

    public String getKnownhosts() {
        return this.c;
    }

    public void setKnownhosts(String knownhosts) {
        this.c = knownhosts;
    }

    public void parse(InputStream in) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            try {
                if (string.startsWith("#")) {
                    this.b.add(new CommentEntry(string));
                    continue;
                }
                if (string.startsWith("|1|")) {
                    this.b.add(new HashedHostEntry(string));
                    this.e = true;
                    continue;
                }
                this.b.add(new HostEntry(string));
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn(invalidHostFileException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String knownhosts) throws IOException {
        InputStream inputStream = null;
        try {
            if (knownhosts != null) {
                File file = new File(knownhosts);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                    this.parse(inputStream);
                    inputStream.close();
                    this.d = file.canWrite();
                } else {
                    file.getParentFile().mkdirs();
                    if (file.createNewFile()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(this.toString().getBytes());
                        fileOutputStream.close();
                        this.d = true;
                    } else {
                        this.d = false;
                    }
                }
                if (!this.d) {
                    a.warn("Host file is not writeable.");
                }
                this.c = knownhosts;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isHostFileWriteable() {
        return this.d;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract boolean onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public abstract boolean onUnknownAlgorithm(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String host, SshPublicKey pk, boolean always) throws InvalidHostFileException {
        KnownHostsEntry knownHostsEntry;
        if (a.isDebugEnabled()) {
            a.debug("Allowing " + host + " with fingerprint " + pk.getFingerprint());
        }
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            knownHostsEntry = (KnownHostsEntry)iterator.next();
            if (!knownHostsEntry.matches(host)) continue;
            iterator.remove();
        }
        knownHostsEntry = null;
        knownHostsEntry = this.e ? new HashedHostEntry(host, pk) : new HostEntry(host, pk);
        this.b.add(knownHostsEntry);
        if (always) {
            if (this.c != null) {
                this.saveHostFile();
            } else {
                a.warn("Cannot write to known_hosts file as none supplied");
            }
        }
    }

    public void removeAllowedHost(String host) {
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
            try {
                if (!knownHostsEntry.matches(host)) continue;
                iterator.remove();
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn("Failed to match host: " + invalidHostFileException.getMessage());
            }
        }
    }

    public void removeAllAllowedHosts() {
        this.b.clear();
    }

    @Override
    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        Iterator iterator = this.b.iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
            if (!knownHostsEntry.matches(host)) continue;
            a.debug("verifyHost - found matching entry for host '" + host + "'");
            bl = true;
            if (!knownHostsEntry.getPublicKey().getAlgorithmName().equals(pk.getAlgorithmName())) continue;
            a.debug("verifyHost - found matching algorithm '" + pk.getAlgorithmName() + "'");
            bl2 = true;
            if (knownHostsEntry.getPublicKey().equals(pk)) {
                return true;
            }
            this.onHostKeyMismatch(host, knownHostsEntry.getPublicKey(), pk);
            break;
        }
        if (!bl) {
            return this.onUnknownHost(host, pk);
        }
        if (!bl2) {
            return this.onUnknownAlgorithm(host, pk);
        }
        return false;
    }

    @Override
    public String getPreferredKeyAlgorithm(String host) {
        for (KnownHostsEntry knownHostsEntry : this.b) {
            try {
                if (!knownHostsEntry.matches(host)) continue;
                return knownHostsEntry.getPublicKey().getAlgorithmName();
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn("Failed to match host: " + invalidHostFileException.getMessage());
            }
        }
        return null;
    }

    public void saveHostFile() throws InvalidHostFileException {
        this.saveHostFile(this.c);
    }

    public void saveHostFile(String knownHostsFile) throws InvalidHostFileException {
        try {
            File file = new File(knownHostsFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.c, iOException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (KnownHostsEntry knownHostsEntry : this.b) {
            stringBuffer.append(knownHostsEntry.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public class HashedHostEntry
    implements KnownHostsEntry {
        private String b;
        private byte[] c = null;
        private byte[] d = null;
        private SshPublicKey e;
        private MessageDigest f = null;

        public HashedHostEntry(String line) throws InvalidHostFileException {
            this.f = this.a();
            StringTokenizer stringTokenizer = new StringTokenizer(line, " ");
            if (stringTokenizer.countTokens() == 0) {
                throw new InvalidHostFileException("Failed to read known_hosts line '" + line + "'");
            }
            String string = (String)stringTokenizer.nextElement();
            if (!string.startsWith("|1|")) {
                throw new InvalidHostFileException("Invalid data in known_hosts line '" + line + "'");
            }
            this.b = string.substring("|1|".length());
            int n2 = this.b.indexOf("|");
            if (n2 <= 0) {
                throw new InvalidHostFileException("Invalid data in known_hosts line '" + line + "'");
            }
            String string2 = this.b.substring(0, n2);
            String string3 = this.b.substring(n2 + 1);
            this.c = Base64.decode(string2);
            this.d = Base64.decode(string3);
            if (this.c.length != 20 || this.d.length != 20) {
                throw new InvalidHostFileException("Invalid data in known_hosts line '" + line + "'");
            }
            stringTokenizer.nextElement();
            String string4 = (String)stringTokenizer.nextElement();
            try {
                this.e = SshKeyPairFactory.decodePublicKey(Base64.decode(string4));
            }
            catch (InvalidSshKeyException invalidSshKeyException) {
                throw new InvalidHostFileException("Failed to read key for host '" + string + "': " + invalidSshKeyException.getMessage());
            }
        }

        public HashedHostEntry(String host, SshPublicKey pk) throws InvalidHostFileException {
            this.e = pk;
            this.f = this.a();
            this.c = new byte[this.f.getDigestLength()];
            ConfigurationLoader.getRND().nextBytes(this.c);
            this.a(this.c);
            this.f.update(host.getBytes());
            this.d = this.f.digest();
        }

        public String getHashedHostName() {
            return this.b;
        }

        @Override
        public SshPublicKey getPublicKey() {
            return this.e;
        }

        public boolean matchesExact(String host) throws InvalidHostFileException {
            byte[] byArray = null;
            this.a(this.c);
            this.f.update(host.getBytes());
            byArray = this.f.digest();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == this.d[i2]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matches(String host) throws InvalidHostFileException {
            boolean bl = this.matchesExact(host);
            if (!bl) {
                String string;
                StringTokenizer stringTokenizer = new StringTokenizer(host, ",");
                while (stringTokenizer.hasMoreElements() && !(bl = this.matchesExact(string = (String)stringTokenizer.nextElement()))) {
                }
                return bl;
            }
            return bl;
        }

        private void a(byte[] byArray) throws InvalidHostFileException {
            try {
                ((Parameterized)((Object)this.f)).setParameter("key", byArray);
            }
            catch (Exception exception) {
                String string = "Failed to initialise hash: " + exception.getMessage();
                a.error(string);
                throw new InvalidHostFileException(string);
            }
        }

        private MessageDigest a() throws InvalidHostFileException {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("HMAC-SHA-1", "CryptixEDT");
                return messageDigest;
            }
            catch (Exception exception) {
                String string = "Failed to create hash algorithm: " + exception.getMessage();
                a.error(string);
                throw new InvalidHostFileException(string);
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("|1|");
            stringBuffer.append(Base64.encodeBytes(this.c, true)).append("|").append(Base64.encodeBytes(this.d, true)).append(" ").append(this.e.getAlgorithmName()).append(" ").append(Base64.encodeBytes(this.e.getEncoded(), true));
            return stringBuffer.toString();
        }
    }

    public class HostEntry
    implements KnownHostsEntry {
        private String b;
        private SshPublicKey c;

        public HostEntry(String line) throws InvalidHostFileException {
            StringTokenizer stringTokenizer = new StringTokenizer(line);
            if (stringTokenizer.countTokens() == 0) {
                throw new InvalidHostFileException("Failed to read known_hosts line '" + line + "'");
            }
            this.b = (String)stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            String string = (String)stringTokenizer.nextElement();
            try {
                this.c = SshKeyPairFactory.decodePublicKey(Base64.decode(string));
            }
            catch (InvalidSshKeyException invalidSshKeyException) {
                throw new InvalidHostFileException("Failed to read key for host '" + this.b + "': " + invalidSshKeyException.getMessage());
            }
        }

        public HostEntry(String host, SshPublicKey pk) {
            this.b = host;
            this.c = pk;
        }

        public String getHostName() {
            return this.b;
        }

        @Override
        public SshPublicKey getPublicKey() {
            return this.c;
        }

        @Override
        public boolean matches(String host) throws InvalidHostFileException {
            String string;
            int n2 = host.indexOf(",");
            String string2 = string = n2 >= 0 ? host.substring(0, n2) : null;
            if (this.b.equalsIgnoreCase(host) || string != null && this.b.equalsIgnoreCase(string)) {
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.b, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.equalsIgnoreCase(host) && (string == null || !string3.equalsIgnoreCase(string))) continue;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.b);
            stringBuffer.append(" ").append(this.c.getAlgorithmName()).append(" ").append(Base64.encodeBytes(this.c.getEncoded(), true));
            return stringBuffer.toString();
        }
    }

    public class CommentEntry
    implements KnownHostsEntry {
        private String b;

        public CommentEntry(String comment) {
            this.b = comment;
        }

        @Override
        public boolean matches(String host) throws InvalidHostFileException {
            return false;
        }

        @Override
        public String toString() {
            return this.b;
        }

        @Override
        public SshPublicKey getPublicKey() {
            return null;
        }
    }

    public static interface KnownHostsEntry {
        public boolean matches(String var1) throws InvalidHostFileException;

        public String toString();

        public SshPublicKey getPublicKey();
    }
}

