/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageNotRegisteredException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.SshMessageListener;
import com.enterprisedt.util.debug.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public final class SshMessageStore {
    private static Logger a = Logger.getLogger("SshMessageStore");
    private List b = new ArrayList();
    private Map c = new HashMap();
    private boolean d = false;
    private int[] e = new int[1];
    private int f = 5000;
    private Vector g = new Vector();

    public boolean isClosed() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(SshMessageListener listener) {
        Vector vector = this.g;
        synchronized (vector) {
            this.g.add(listener);
        }
    }

    public synchronized SshMessage getMessage(int[] messageIdFilter) throws MessageStoreEOFException, InterruptedException {
        try {
            return this.getMessage(messageIdFilter, 0);
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new MessageStoreEOFException(messageNotAvailableException);
        }
    }

    public synchronized SshMessage getMessage(int[] messageIdFilter, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        if (this.b.size() <= 0 && this.d) {
            throw new MessageStoreEOFException();
        }
        if (messageIdFilter == null) {
            return this.nextMessage();
        }
        if (timeout < 0) {
            timeout = 0;
        }
        int n2 = timeout;
        while (this.b.size() > 0 || !this.d) {
            SshMessage sshMessage = this.a(messageIdFilter, true);
            if (sshMessage != null) {
                return sshMessage;
            }
            if (timeout > 0 && n2 <= 0) {
                a.debug("Timeout retrieving message");
                throw new MessageNotAvailableException();
            }
            if (this.d) continue;
            a.debug("Waiting for max " + n2 + " ms");
            long l2 = System.currentTimeMillis();
            this.wait(n2);
            if (timeout <= 0) continue;
            int n3 = (int)(System.currentTimeMillis() - l2);
            n2 -= n3;
        }
        throw new MessageStoreEOFException();
    }

    public synchronized SshMessage getMessage(int messageId, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        this.e[0] = messageId;
        return this.getMessage(this.e, timeout);
    }

    public boolean hasMessages() {
        return this.b.size() > 0;
    }

    public int size() {
        return this.b.size();
    }

    public boolean isRegisteredMessage(Integer messageId) {
        return this.c.containsKey(messageId);
    }

    public void addMessage(byte[] msgdata) throws MessageNotRegisteredException, InvalidMessageException {
        Integer n2 = new Integer(msgdata[5]);
        if (!this.isRegisteredMessage(n2)) {
            throw new MessageNotRegisteredException(n2);
        }
        Class clazz = (Class)this.c.get(SshMessage.getMessageId(msgdata));
        try {
            SshMessage sshMessage = (SshMessage)clazz.newInstance();
            sshMessage.fromByteArray(new ByteArrayReader(msgdata));
            this.addMessage(sshMessage);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidMessageException("Illegal access for implementation class " + clazz.getName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidMessageException("Instantiation failed for class " + clazz.getName(), instantiationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMessage(SshMessage msg) throws MessageNotRegisteredException {
        this.b.add(this.b.size(), msg);
        Vector vector = this.g;
        synchronized (vector) {
            if (this.g.size() > 0) {
                Iterator iterator = this.g.iterator();
                while (iterator.hasNext()) {
                    ((SshMessageListener)iterator.next()).messageReceived(msg);
                }
            }
        }
        this.notifyAll();
    }

    public synchronized void close() {
        this.d = true;
        this.notifyAll();
    }

    public synchronized SshMessage nextMessage() throws MessageStoreEOFException, InterruptedException {
        if (this.b.size() <= 0 && this.d) {
            throw new MessageStoreEOFException();
        }
        while (this.b.size() <= 0 && !this.d) {
            this.wait(this.f);
        }
        if (this.b.size() > 0) {
            return (SshMessage)this.b.remove(0);
        }
        throw new MessageStoreEOFException();
    }

    public synchronized void breakWaiting() {
        this.notifyAll();
    }

    public synchronized SshMessage peekMessage(int[] messageIdFilter) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        return this.peekMessage(messageIdFilter, 0);
    }

    public synchronized SshMessage peekMessage(int[] messageIdFilter, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        SshMessage sshMessage = this.a(messageIdFilter, false);
        if (sshMessage != null) {
            return sshMessage;
        }
        if (timeout > 0) {
            if (a.isDebugEnabled()) {
                a.debug("No message so waiting for " + String.valueOf(timeout) + " milliseconds");
            }
            this.wait(timeout);
            sshMessage = this.a(messageIdFilter, false);
            if (sshMessage != null) {
                return sshMessage;
            }
        }
        if (this.d) {
            throw new MessageStoreEOFException();
        }
        throw new MessageNotAvailableException();
    }

    private SshMessage a(int[] nArray, boolean bl) {
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            SshMessage sshMessage = (SshMessage)this.b.get(i2);
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (sshMessage.getMessageId() != nArray[i3]) continue;
                if (bl) {
                    this.b.remove(sshMessage);
                }
                return sshMessage;
            }
        }
        return null;
    }

    public synchronized SshMessage peekMessage(int messageId) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        return this.peekMessage(messageId, 0);
    }

    public synchronized void removeMessage(SshMessage msg) {
        this.b.remove(msg);
    }

    public synchronized SshMessage peekMessage(int messageId, int timeout) throws MessageStoreEOFException, MessageNotAvailableException, InterruptedException {
        this.e[0] = messageId;
        return this.peekMessage(this.e, timeout);
    }

    public void registerMessage(int messageId, Class implementor) {
        Integer n2 = new Integer(messageId);
        this.c.put(n2, implementor);
    }

    public Object[] getRegisteredMessageIds() {
        return this.c.keySet().toArray();
    }

    public SshMessage createMessage(byte[] msgdata) throws MessageNotRegisteredException, InvalidMessageException {
        Integer n2 = SshMessage.getMessageId(msgdata);
        if (!this.isRegisteredMessage(n2)) {
            throw new MessageNotRegisteredException(n2);
        }
        Class clazz = (Class)this.c.get(n2);
        try {
            SshMessage sshMessage = (SshMessage)clazz.newInstance();
            sshMessage.fromByteArray(new ByteArrayReader(msgdata));
            return sshMessage;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidMessageException("Illegal access for implementation class " + clazz.getName(), illegalAccessException);
        }
        catch (Throwable throwable) {
            a.debug("Invalid message data:", msgdata);
            throw new InvalidMessageException("Instantiation failed for class " + clazz.getName(), throwable);
        }
    }
}

