/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.math.BigInteger;

public class SshMsgKexDhReply
extends SshMessage {
    protected static final int SSH_MSG_KEXDH_REPLY = 31;
    private BigInteger a;
    private byte[] b;
    private byte[] c;

    public SshMsgKexDhReply(byte[] hostKey, BigInteger f2, byte[] signature) {
        super(31);
        this.b = hostKey;
        this.a = f2;
        this.c = signature;
    }

    public SshMsgKexDhReply() {
        super(31);
    }

    public BigInteger getF() {
        return this.a;
    }

    public byte[] getHostKey() {
        return this.b;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEXDH_REPLY";
    }

    public byte[] getSignature() {
        return this.c;
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeBinaryString(this.b);
            baw.writeBigInteger(this.a);
            baw.writeBinaryString(this.c);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error writing message data", iOException);
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.b = bar.readBinaryString();
            this.a = bar.readBigInteger();
            this.c = bar.readBinaryString();
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error reading message data", iOException);
        }
    }
}

