/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.TlsClientContextImpl;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.EDTTlsCrypto;
import com.enterprisedt.net.puretls.SSLCaughtAlertException;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.b;
import com.enterprisedt.net.puretls.c;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.CertificateDecodeException;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.net.puretls.crypto.DHPrivateKey;
import com.enterprisedt.net.puretls.d;
import com.enterprisedt.net.puretls.f;
import com.enterprisedt.net.puretls.g;
import com.enterprisedt.net.puretls.j;
import com.enterprisedt.net.puretls.l;
import com.enterprisedt.net.puretls.n;
import com.enterprisedt.net.puretls.o;
import com.enterprisedt.net.puretls.q;
import com.enterprisedt.net.puretls.r;
import com.enterprisedt.net.puretls.s;
import com.enterprisedt.net.puretls.sslg.SSLPolicyInt;
import com.enterprisedt.net.puretls.u;
import com.enterprisedt.net.puretls.util.Util;
import com.enterprisedt.net.puretls.y;
import com.enterprisedt.net.puretls.z;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public abstract class SSLHandshake {
    private static Logger z = Logger.getLogger("SSLHandshake");
    public static final int SSL_HT_HELLO_REQUEST = 0;
    public static final int SSL_HT_CLIENT_HELLO = 1;
    public static final int SSL_HT_SERVER_HELLO = 2;
    public static final int SSL_HT_CERTIFICATE = 11;
    public static final int SSL_HT_SERVER_KEY_EXCHANGE = 12;
    public static final int SSL_HT_CERTIFICATE_REQUEST = 13;
    public static final int SSL_HT_SERVER_HELLO_DONE = 14;
    public static final int SSL_HT_CERTIFICATE_VERIFY = 15;
    public static final int SSL_HT_CLIENT_KEY_EXCHANGE = 16;
    public static final int SSL_HT_FINISHED = 20;
    public static final int SSL_HT_V2_CLIENT_HELLO = 255;
    public static final int SSL_HS_WAIT_FOR_CHANGE_CIPHER_SPECS = 20;
    public static final int SSL_HS_WAIT_FOR_FINISHED = 21;
    public static final int SSL_HANDSHAKE_FINISHED = 255;
    public static final int SSL_V3_VERSION = 768;
    public static final int TLS_V1_VERSION = 769;
    public static final int TLS_V1_1_VERSION = 770;
    public static final int TLS_V1_2_VERSION = 771;
    public static final int MASTER_SECRET_SIZE = 48;
    public static byte[] pad_1 = new byte[]{54};
    public static byte[] pad_2 = new byte[]{92};
    ByteArrayOutputStream a = new ByteArrayOutputStream();
    int b;
    j c;
    byte[] d;
    boolean e;
    CertContext f;
    Vector g;
    SecureRandom h;
    byte[] i = new byte[32];
    byte[] j = new byte[32];
    n k;
    n l;
    g m;
    EDTTlsCrypto n;
    SecurityParameters o;
    TlsClientContextImpl p;
    byte[] q;
    byte[] r;
    TlsAgreement s;
    PublicKey t;
    PublicKey u;
    DHPrivateKey v;
    CryptixRSAPrivateKey w = null;
    CryptixRSAPublicKey x = null;
    protected d cr;
    int y = 0;

    public SSLHandshake(j conn) {
        this.c = conn;
        this.n = new EDTTlsCrypto(new SecureRandom());
        this.o = new SecurityParameters(1);
        this.p = new TlsClientContextImpl(this.n, this.o);
        this.o.verifyDataLength = 12;
        this.k = new n();
        this.f = new CertContext(conn.d.a());
        this.h = new SecureRandom(conn.d.g());
        this.filterCipherSuites(conn.d.c(), conn.d());
    }

    public static String getVersionString(int version) {
        switch (version) {
            case 768: {
                return "SSL 3.0";
            }
            case 769: {
                return "TLS 1.0";
            }
            case 770: {
                return "TLS 1.1";
            }
            case 771: {
                return "TLS 1.2";
            }
        }
        return "#" + version;
    }

    public void handshake() throws IOException {
        while (this.b != 255) {
            try {
                this.handshakeContinue();
            }
            catch (SSLCaughtAlertException sSLCaughtAlertException) {
                SSLCaughtAlertException sSLCaughtAlertException2 = new SSLCaughtAlertException(sSLCaughtAlertException.getAlert(), "at handshake state " + this.getStateName());
                sSLCaughtAlertException2.initCause(sSLCaughtAlertException);
                throw sSLCaughtAlertException2;
            }
        }
        this.c.r = this.d.length != 0 ? this.d : null;
        this.c.l = new q(this.c);
        SSLDebug.debug(4, "Handshake completed");
    }

    protected String getStateName() {
        switch (this.b) {
            case 0: {
                return "SSL_HT_HELLO_REQUEST";
            }
            case 1: {
                return "SSL_HT_CLIENT_HELLO";
            }
            case 2: {
                return "SSL_HT_SERVER_HELLO";
            }
            case 11: {
                return "SSL_HT_CERTIFICATE";
            }
            case 12: {
                return "SSL_HT_SERVER_KEY_EXCHANGE";
            }
            case 13: {
                return "SSL_HT_CERTIFICATE_REQUEST";
            }
            case 14: {
                return "SSL_HT_SERVER_HELLO_DONE";
            }
            case 15: {
                return "SSL_HT_CERTIFICATE_VERIFY";
            }
            case 16: {
                return "SSL_HT_CLIENT_KEY_EXCHANGE";
            }
            case 20: {
                return "SSL_HT_FINISHED or SSL_HS_WAIT_FOR_CHANGE_CIPHER_SPECS";
            }
            case 255: {
                return "SSL_HT_V2_CLIENT_HELLO or SSL_HANDSHAKE_FINISHED";
            }
            case 21: {
                return "SSL_HS_WAIT_FOR_FINISHED";
            }
        }
        return "" + this.b;
    }

    public abstract void handshakeContinue() throws IOException;

    public void sendHandshakeMsg(j conn, int msgtype, r pdu) throws IOException {
        this.sendHandshakeMsg(conn, msgtype, pdu, true);
    }

    public void sendHandshakeMsg(j conn, int msgtype, r pdu, boolean digest) throws IOException, Error {
        pdu.a(conn, this.a);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.a.size() + 10);
        o o2 = new o(msgtype, this.a.size());
        o2.a(conn, byteArrayOutputStream);
        this.a.writeTo(byteArrayOutputStream);
        this.a.reset();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (digest) {
            this.k.a(byArray);
        }
        u u2 = new u(conn, 22, byArray);
        u2.a(conn);
    }

    public InputStream recvHandshakeMsg(j conn, o hdr) throws IOException {
        hdr.a(conn, conn.h);
        switch (hdr.a.a) {
            case 15: 
            case 20: {
                try {
                    this.l = (n)this.k.clone();
                    break;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Error("Internal error: clone not supported for " + this.k.getClass().getName());
                }
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        hdr.a(conn, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.k.a(byArray);
        byte[] byArray2 = new byte[hdr.b.a];
        int n2 = 0;
        while (n2 < byArray2.length) {
            n2 = conn.h.read(byArray2, n2, byArray2.length - n2);
        }
        this.k.a(byArray2);
        return new ByteArrayInputStream(byArray2);
    }

    public boolean finishedP() {
        return this.b == 255;
    }

    public void stateChange(int st) {
        SSLDebug.debug(64, "Old handshake state is " + this.getStateName());
        this.b = st;
        SSLDebug.debug(4, "New handshake state is " + this.getStateName());
    }

    public void stateAssert(int st) throws IOException {
        if (this.b == st) {
            return;
        }
        this.c.a(com.enterprisedt.net.puretls.b.d);
    }

    public void stateAssert(int st1, int st2) throws IOException {
        if (this.b == st1) {
            return;
        }
        if (this.b == st2) {
            return;
        }
        this.c.a(com.enterprisedt.net.puretls.b.d);
    }

    public void stateAssert(int st1, int st2, int st3) throws IOException {
        if (this.b == st1) {
            return;
        }
        if (this.b == st2) {
            return;
        }
        if (this.b == st3) {
            return;
        }
        this.c.a(com.enterprisedt.net.puretls.b.d);
    }

    public void sendCertificate(Vector certs) throws IOException {
        c c2 = new c();
        for (int i2 = 1; i2 <= certs.size(); ++i2) {
            z z2 = new z(-16777215);
            z2.b = (byte[])certs.elementAt(certs.size() - i2);
            c2.a.a.addElement(z2);
        }
        this.sendHandshakeMsg(this.c, 11, c2);
    }

    public void recvCertificate(InputStream is) throws IOException {
        PublicKey publicKey;
        Object object;
        c c2 = new c();
        Vector<X509Cert> vector = new Vector<X509Cert>();
        Vector vector2 = null;
        c2.a(this.c, is);
        if (c2.a.a.size() == 0) {
            this.c.a(com.enterprisedt.net.puretls.b.p);
        }
        SSLDebug.debug(32, "Received certificate list - ", c2.a.a.size());
        for (int i2 = 1; i2 <= c2.a.a.size(); ++i2) {
            SSLDebug.debug(32, "Reading certificate - ", i2);
            z z2 = (z)c2.a.a.elementAt(c2.a.a.size() - i2);
            object = z2.b;
            vector.addElement(new X509Cert((byte[])object));
        }
        try {
            vector2 = X509Cert.verifyCertChain(this.f, vector, this.c.d().getCertVerifyPolicy());
            z.debug(vector.size() + " certificates supplied." + (vector2 != null ? vector2.size() : 0) + " verified certificates.");
        }
        catch (CertificateDecodeException certificateDecodeException) {
            this.c.a(com.enterprisedt.net.puretls.b.k, certificateDecodeException);
        }
        catch (CertificateVerifyException certificateVerifyException) {
            if (SSLDebug.getDebug(32)) {
                certificateVerifyException.printStackTrace();
            }
            this.c.a(com.enterprisedt.net.puretls.b.k, certificateVerifyException);
        }
        boolean bl = vector2 != null;
        boolean bl2 = this.c.d().acceptUnverifiableCertificatesP();
        z.debug("isVerified=" + bl + ", acceptUnverified=" + bl2);
        if (!bl2 && this.c.d.getVerifier() != null ? !this.c.d.getVerifier().acceptPeerCertificate(vector, bl) : vector2 == null && !bl2) {
            throw new CertificateVerifyException("Server certificate could not be validated.", vector);
        }
        object = (X509Cert)vector.elementAt(vector.size() - 1);
        this.t = publicKey = ((X509Cert)object).getPublicKey();
        this.c.o = vector2;
    }

    public void computeMasterSecret() {
        s s2 = com.enterprisedt.net.puretls.s.a(this.c.b, this.o.prfAlgorithm);
        this.r = new byte[48];
        s2.a(this.q, 1, this.i, this.j, this.r);
        this.o.setMasterSecret(new BcTlsSecret(this.n, this.r));
    }

    public void computeNextCipherStates() {
        this.c.u = new f();
        this.c.v = new f();
        try {
            com.enterprisedt.net.puretls.f.a(this, this.c.u, this.c.v);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException.toString());
        }
        catch (IOException iOException) {
            throw new Error(iOException.toString());
        }
    }

    public void sendChangeCipherSpec() throws IOException {
        byte[] byArray = new byte[]{1};
        u u2 = new u(this.c, 20, byArray);
        u2.a(this.c);
        this.c.s = this.c.u;
        this.c.w = 0L;
    }

    public void recvFinished(InputStream is) throws IOException {
        l l2 = new l(this.c, this, false);
        l2.a(this.c, is);
    }

    public void sendFinished() throws IOException {
        l l2 = new l(this.c, this, true);
        this.sendHandshakeMsg(this.c, 20, l2);
        this.c.k.flush();
    }

    public void recvChangeCipherSpecs(byte[] data) throws IOException {
        byte[] byArray = new byte[]{1};
        this.stateAssert(20);
        if (!ArrayUtil.areEqual(byArray, data)) {
            this.c.a(com.enterprisedt.net.puretls.b.p);
        }
        this.c.t = this.c.v;
        this.c.x = 0L;
        this.stateChange(21);
    }

    protected void storeSession(String key) {
        SSLDebug.debug(64, "Requesting storage of session using key " + key, this.d);
        this.c.d.storeSession(key, new y(this, key));
    }

    protected y findSession(String key) {
        SSLDebug.debug(4, "Trying to recover session using key " + key);
        y y2 = this.c.d.findSession(key);
        if (y2 != null && y2.b() < System.currentTimeMillis()) {
            this.c.d.destroySession(y2.c());
            return null;
        }
        return y2;
    }

    protected void restoreSession(y sess) {
        sess.a(this);
    }

    protected void filterCipherSuites(PrivateKey key, SSLPolicyInt policy) {
        String string = key.getAlgorithm();
        this.g = new Vector();
        int[] nArray = this.c.d().getCipherSuites();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            g g2 = com.enterprisedt.net.puretls.g.a(nArray[i2]);
            if (g2 == null) {
                SSLDebug.debug(16, "Rejecting unrecognized cipher suite" + nArray[i2]);
                continue;
            }
            if (!g2.d().equals(string)) {
                SSLDebug.debug(16, "Rejecting cipher suite: " + g2.b() + " -- incompatible with signature algorithm " + string);
                continue;
            }
            SSLDebug.debug(16, "Accepting cipher suite: " + g2.b());
            this.g.addElement(g2);
        }
    }

    protected ProtocolVersion getBCProtocolVersion(int version) {
        if (version == 768) {
            return ProtocolVersion.SSLv3;
        }
        if (version == 769) {
            return ProtocolVersion.TLSv10;
        }
        if (version == 770) {
            return ProtocolVersion.TLSv11;
        }
        if (version == 771) {
            return ProtocolVersion.TLSv12;
        }
        return null;
    }

    protected int getPRFAlgorithm(TlsContext context, int cipherSuite) throws IOException {
        boolean bl = TlsUtils.isTLSv12(context);
        switch (cipherSuite) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 156: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 166: 
            case 168: 
            case 170: 
            case 172: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 49187: 
            case 49189: 
            case 49191: 
            case 49193: 
            case 49195: 
            case 49197: 
            case 49199: 
            case 49201: 
            case 49212: 
            case 49214: 
            case 49216: 
            case 49218: 
            case 49220: 
            case 49222: 
            case 49224: 
            case 49226: 
            case 49228: 
            case 49230: 
            case 49232: 
            case 49234: 
            case 49236: 
            case 49238: 
            case 49240: 
            case 49242: 
            case 49244: 
            case 49246: 
            case 49248: 
            case 49250: 
            case 49252: 
            case 49254: 
            case 49256: 
            case 49258: 
            case 49260: 
            case 49262: 
            case 49264: 
            case 49266: 
            case 49268: 
            case 49270: 
            case 49272: 
            case 49274: 
            case 49276: 
            case 49278: 
            case 49280: 
            case 49282: 
            case 49284: 
            case 49286: 
            case 49288: 
            case 49290: 
            case 49292: 
            case 49294: 
            case 49296: 
            case 49298: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49316: 
            case 49317: 
            case 49318: 
            case 49319: 
            case 49320: 
            case 49321: 
            case 49322: 
            case 49323: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: 
            case 52395: 
            case 52396: 
            case 52397: 
            case 52398: 
            case 53249: 
            case 53251: 
            case 53253: 
            case 65280: 
            case 65281: 
            case 65282: 
            case 65283: 
            case 65284: 
            case 65285: 
            case 65296: 
            case 65297: 
            case 65298: 
            case 65299: 
            case 65300: 
            case 65301: {
                if (bl) {
                    return 1;
                }
                throw new TlsFatalAlert(47);
            }
            case 157: 
            case 159: 
            case 161: 
            case 163: 
            case 165: 
            case 167: 
            case 169: 
            case 171: 
            case 173: 
            case 49188: 
            case 49190: 
            case 49192: 
            case 49194: 
            case 49196: 
            case 49198: 
            case 49200: 
            case 49202: 
            case 49213: 
            case 49215: 
            case 49217: 
            case 49219: 
            case 49221: 
            case 49223: 
            case 49225: 
            case 49227: 
            case 49229: 
            case 49231: 
            case 49233: 
            case 49235: 
            case 49237: 
            case 49239: 
            case 49241: 
            case 49243: 
            case 49245: 
            case 49247: 
            case 49249: 
            case 49251: 
            case 49253: 
            case 49255: 
            case 49257: 
            case 49259: 
            case 49261: 
            case 49263: 
            case 49265: 
            case 49267: 
            case 49269: 
            case 49271: 
            case 49273: 
            case 49275: 
            case 49277: 
            case 49279: 
            case 49281: 
            case 49283: 
            case 49285: 
            case 49287: 
            case 49289: 
            case 49291: 
            case 49293: 
            case 49295: 
            case 49297: 
            case 49299: 
            case 53250: {
                if (bl) {
                    return 2;
                }
                throw new TlsFatalAlert(47);
            }
            case 175: 
            case 177: 
            case 179: 
            case 181: 
            case 183: 
            case 185: 
            case 49208: 
            case 49211: 
            case 49301: 
            case 49303: 
            case 49305: 
            case 49307: {
                if (bl) {
                    return 2;
                }
                return 0;
            }
        }
        if (bl) {
            return 1;
        }
        return 0;
    }

    protected void makeRandomValue(byte[] val) {
        if (val.length != 32) {
            throw new InternalError("Incorrect random value length");
        }
        this.h.nextBytes(val);
        long l2 = System.currentTimeMillis();
        byte[] byArray = Util.toBytes(l2 /= 1000L, 4);
        System.arraycopy(byArray, 0, val, 0, 4);
    }
}

