/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.LicenseException;
import com.enterprisedt.util.license.LicenseProperties;
import com.enterprisedt.util.license.LicensePropertiesBase;
import com.enterprisedt.util.license.PKILicenseReader;
import java.util.Properties;

public class LicensePropertiesFactory {
    public static LicensePropertiesBase createLicenseProperties() {
        Properties properties = LicensePropertiesBase.a();
        if (properties == null) {
            throw new RuntimeException("Failed to read license file - is license.jar in the CLASSPATH?");
        }
        String string = properties.getProperty("license.owner");
        String string2 = properties.getProperty("license.key");
        String string3 = properties.getProperty("license.product");
        if (Character.isDigit(string2.charAt(0)) && string2.indexOf(45) > 0) {
            return new LicenseProperties(string, string2, string3);
        }
        try {
            return new PKILicenseReader(string, string2);
        }
        catch (LicenseException licenseException) {
            throw new RuntimeException("Failed to read license: " + licenseException.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            LicensePropertiesBase licensePropertiesBase = LicensePropertiesFactory.createLicenseProperties();
            EDTProduct eDTProduct = EDTProduct.getProduct(licensePropertiesBase.getProductStr());
            System.out.println("Product: " + (eDTProduct == null ? "unknown" : eDTProduct.toString()));
            System.out.println("Owner: " + licensePropertiesBase.getOwner());
            System.out.println("Trial: " + licensePropertiesBase.isTrial());
            System.out.println("Expiry: " + licensePropertiesBase.a.format(licensePropertiesBase.getExpiryDate()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

