/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.proxy;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.SocksProxySocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Socks5ProxySocket
extends SocksProxySocket {
    private static Logger a = Logger.getLogger("Socks5ProxySocket");
    public static final int SOCKS5 = 5;
    private static final String[] b = new String[]{"Success", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};

    @Override
    protected void sendRequest(int command, String remoteHost, int remotePort) throws IOException {
        try {
            byte[] byArray = new byte[]{5, 2, 0, 2};
            byte[] byArray2 = new byte[]{5, 1, 0};
            byte[] byArray3 = byArray;
            if (this.username == null || this.username.length() == 0) {
                a.debug("sending request without username/pwd");
                byArray3 = byArray2;
            }
            this.proxyOut.write(byArray3);
            this.proxyOut.flush();
            int n2 = this.proxyIn.read();
            if (n2 == -1) {
                throw new IOException("SOCKS5 server " + this.proxyHost + ":" + this.proxyPort + " disconnected");
            }
            if (n2 != 5) {
                throw new IOException("Invalid response from SOCKS5 server (" + n2 + ") " + this.proxyHost + ":" + this.proxyPort);
            }
            int n3 = this.proxyIn.read();
            switch (n3) {
                case 0: {
                    break;
                }
                case 2: {
                    this.a(this.proxyIn, this.proxyOut);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 server does not support our authentication methods");
                }
            }
            byArray3 = new byte[]{5, (byte)command, 0, 3};
            this.proxyOut.write(byArray3);
            this.proxyOut.write(remoteHost.length());
            this.proxyOut.write(remoteHost.getBytes());
            int n4 = remotePort >>> 8 & 0xFF;
            int n5 = remotePort & 0xFF;
            this.proxyOut.write(n4);
            this.proxyOut.write(n5);
            this.proxyOut.flush();
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with SOCKS5 server " + this.proxyHost + ":" + this.proxyPort + ", " + socketException.getMessage());
        }
    }

    @Override
    protected void readResponse() throws IOException {
        try {
            int n2 = this.proxyIn.read();
            if (n2 != 5) {
                throw new IOException("Invalid response from SOCKS5 server (" + n2 + ") " + this.proxyHost + ":" + this.proxyPort);
            }
            int n3 = this.proxyIn.read();
            if (n3 != 0) {
                if (n3 > 0 && n3 < 9) {
                    throw new IOException("SOCKS5 server unable to connect, reason: " + b[n3]);
                }
                throw new IOException("SOCKS5 server unable to connect, reason: " + n3);
            }
            this.proxyIn.read();
            int n4 = this.proxyIn.read();
            byte[] byArray = new byte[255];
            switch (n4) {
                case 1: {
                    if (this.proxyIn.read(byArray, 0, 4) != 4) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    this.providerDetail = this.bindingAddress = (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
                    break;
                }
                case 3: {
                    int n5 = this.proxyIn.read();
                    if (this.proxyIn.read(byArray, 0, n5) != n5) {
                        throw new IOException("SOCKS5 error reading address");
                    }
                    this.providerDetail = this.bindingAddress = new String(byArray);
                    break;
                }
                default: {
                    throw new IOException("SOCKS5 gave unsupported address type: " + n4);
                }
            }
            if (this.proxyIn.read(byArray, 0, 2) != 2) {
                throw new IOException("SOCKS5 error reading port");
            }
            this.bindingPort = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            this.providerDetail = this.providerDetail + ":" + this.bindingPort;
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with SOCKS5 server " + this.proxyHost + ":" + this.proxyPort + ", " + socketException.getMessage());
        }
    }

    private void a(InputStream inputStream, OutputStream outputStream) throws IOException {
        outputStream.write(1);
        outputStream.write(this.username.length());
        outputStream.write(this.username.getBytes());
        outputStream.write(this.password.length());
        outputStream.write(this.password.getBytes());
        int n2 = inputStream.read();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Invalid response from SOCKS5 server (" + n2 + ") " + this.proxyHost + ":" + this.proxyPort);
        }
        if (inputStream.read() != 0) {
            throw new IOException("Invalid username/password for SOCKS5 server");
        }
    }

    public static Socks5ProxySocket connectViaSocks5Proxy(String remoteHost, int remotePort, String proxyHost, int proxyPort, int timeout, String username, String password) throws IOException, UnknownHostException {
        Socks5ProxySocket socks5ProxySocket = Socks5ProxySocket.a(proxyHost, proxyPort, timeout);
        socks5ProxySocket.setRemoteHost(remoteHost);
        socks5ProxySocket.setUsername(username);
        socks5ProxySocket.setPassword(password);
        socks5ProxySocket.sendRequest(1, remoteHost, remotePort);
        socks5ProxySocket.readResponse();
        return socks5ProxySocket;
    }

    private static Socks5ProxySocket a(String string, int n2, int n3) throws IOException {
        Socks5ProxySocket socks5ProxySocket = new Socks5ProxySocket();
        socks5ProxySocket.setProxyHost(string);
        socks5ProxySocket.setProxyPort(n2);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        socks5ProxySocket.connect(inetSocketAddress, n3);
        return socks5ProxySocket;
    }
}

