/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.config.spi;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.InvalidFileFormatException;
import com.izforge.izpack.api.config.spi.EscapeTool;
import com.izforge.izpack.api.config.spi.HandlerBase;
import com.izforge.izpack.api.config.spi.IniSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;

abstract class AbstractParser {
    private final String _comments;
    private Config _config = Config.getGlobal();
    private final String _operators;

    protected AbstractParser(String operators, String comments) {
        this._operators = operators;
        this._comments = comments;
    }

    protected Config getConfig() {
        return this._config;
    }

    protected void setConfig(Config value) {
        this._config = value;
    }

    protected void parseError(String line, int lineNumber) throws InvalidFileFormatException {
        throw new InvalidFileFormatException("parse error (at line: " + lineNumber + "): " + line);
    }

    IniSource newIniSource(InputStream input, HandlerBase handler) {
        return new IniSource(input, handler, this._comments, this.getConfig());
    }

    IniSource newIniSource(Reader input, HandlerBase handler) {
        return new IniSource(input, handler, this._comments, this.getConfig());
    }

    IniSource newIniSource(URL input, HandlerBase handler) throws IOException {
        return new IniSource(input, handler, this._comments, this.getConfig());
    }

    void parseOptionLine(String line, HandlerBase handler, int lineNumber) throws InvalidFileFormatException {
        int idx = this.indexOfOperator(line);
        String name = null;
        String value = null;
        if (idx < 0) {
            if (this.getConfig().isEmptyOption()) {
                name = line;
                value = line;
            } else {
                this.parseError(line, lineNumber);
            }
        } else {
            name = this.unescapeFilter(line.substring(0, idx)).trim();
            value = this.unescapeFilter(line.substring(idx + 1)).trim();
        }
        if (name.length() == 0) {
            this.parseError(line, lineNumber);
        }
        if (this.getConfig().isLowerCaseOption()) {
            name = name.toLowerCase(Locale.getDefault());
        }
        handler.handleOption(name, value);
    }

    String unescapeFilter(String line) {
        return this.getConfig().isEscape() ? EscapeTool.getInstance().unescape(line) : line;
    }

    protected int indexOfOperator(String line) {
        boolean inQuotes;
        int idx = -1;
        int start = 0;
        boolean bl = inQuotes = line.charAt(0) == '\"';
        while (inQuotes) {
            if ((start = line.indexOf(34, start + 1)) > 1) {
                if (line.charAt(start - 1) == '\\' && line.charAt(start - 2) != '\\') continue;
                inQuotes = false;
                ++start;
                continue;
            }
            if (start >= 0) continue;
            inQuotes = false;
        }
        if (start > -1) {
            for (char c2 : this._operators.toCharArray()) {
                int index = line.indexOf(c2, start);
                if (index < 0 || idx != -1 && index >= idx) continue;
                idx = index;
            }
        }
        return idx;
    }
}

