/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.handler.Prompt;
import java.util.HashMap;
import java.util.Map;

public enum AntSeverity {
    ERROR("error", Prompt.Type.ERROR),
    WARNING("warning", Prompt.Type.WARNING),
    INFO("info", Prompt.Type.INFORMATION);

    private final String name;
    private final Prompt.Type level;
    private static final Map<String, AntSeverity> reversed;

    private AntSeverity(String name, Prompt.Type level) {
        this.name = name;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public Prompt.Type getLevel() {
        return this.level;
    }

    public static AntSeverity fromName(String name) {
        return AntSeverity.fromName(name, null);
    }

    public static AntSeverity fromName(String name, AntSeverity defaultLevel) {
        AntSeverity level = reversed.get(name);
        if (level == null) {
            return defaultLevel;
        }
        return level;
    }

    static {
        reversed = new HashMap<String, AntSeverity>();
        for (AntSeverity l2 : AntSeverity.values()) {
            reversed.put(l2.getName(), l2);
        }
    }
}

