/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MultiLineLabel
extends JComponent {
    private static final long serialVersionUID = 4051045255031894837L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_MARGIN = 10;
    public static final int DEFAULT_ALIGN = 0;
    public static final int LEAST_ALLOWED = 200;
    private static final int FOUND = 0;
    private static final int NOT_FOUND = 1;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final char[] WHITE_SPACE = new char[]{' ', '\n', '\t'};
    private static final char[] SPACES = new char[]{' ', '\t'};
    private static final char NEW_LINE = '\n';
    protected List<String> line = new ArrayList<String>();
    protected String labelText;
    protected int numLines;
    protected int marginHeight;
    protected int marginWidth;
    protected int lineHeight;
    protected int lineAscent;
    protected int lineDescent;
    protected int[] lineWidth;
    protected int maxWidth;
    private int maxAllowed = 200;
    private boolean maxAllowedSet = false;
    protected int alignment = 0;

    public MultiLineLabel(String text, int horMargin, int vertMargin, int maxWidth, int justify) {
        this.labelText = text;
        this.marginWidth = horMargin;
        this.marginHeight = vertMargin;
        this.maxAllowed = maxWidth;
        this.maxAllowedSet = true;
        this.alignment = justify;
    }

    public MultiLineLabel(String label, int marginWidth, int marginHeight) {
        this.labelText = label;
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
    }

    public MultiLineLabel(String label, int alignment) {
        this.labelText = label;
        this.alignment = alignment;
    }

    public MultiLineLabel(String label) {
        this.labelText = label;
    }

    int getPosition(String target, int start, char[] source, int mode) {
        int targetEnd = target.length() - 1;
        int sourceLength = source.length;
        int position = start;
        if (mode == 0) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                for (int scan = 0; scan < sourceLength; ++scan) {
                    if (source[scan] != temp) continue;
                    status = true;
                }
            }
            return position;
        }
        if (mode == 1) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                status = true;
                for (int scan = 0; scan < sourceLength; ++scan) {
                    if (source[scan] != temp) continue;
                    status = false;
                }
            }
            return position;
        }
        return 0;
    }

    int breakWord(String word, FontMetrics fm) {
        int width = 0;
        int currentPos = 0;
        int endPos = word.length() - 1;
        if (endPos <= 0) {
            return currentPos;
        }
        while (width < this.maxAllowed && currentPos < endPos) {
            width = fm.stringWidth(this.labelText.substring(0, ++currentPos));
        }
        if (currentPos != endPos) {
            --currentPos;
        }
        return currentPos;
    }

    private void divideLabel() {
        int startPos;
        int currentPos;
        this.line.clear();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int lastPos = currentPos = (startPos = 0);
        int endPos = this.labelText.length() - 1;
        while (currentPos < endPos) {
            String s2;
            int width = 0;
            while (width < this.maxAllowed && currentPos < endPos && this.labelText.charAt(currentPos) != '\n') {
                lastPos = currentPos;
                currentPos = this.getPosition(this.labelText, currentPos, WHITE_SPACE, 0);
                width = fontMetrics.stringWidth(this.labelText.substring(startPos, currentPos));
            }
            if (this.labelText.charAt(currentPos) == '\n') {
                lastPos = currentPos;
            }
            if (currentPos == endPos && width <= this.maxAllowed) {
                lastPos = currentPos;
                s2 = this.labelText.substring(startPos);
                this.line.add(s2);
            } else {
                if (lastPos == startPos) {
                    lastPos = startPos + this.breakWord(this.labelText.substring(startPos, currentPos), fontMetrics);
                }
                s2 = this.labelText.substring(startPos, lastPos);
                this.line.add(s2);
            }
            currentPos = startPos = this.getPosition(this.labelText, lastPos, SPACES, 1);
        }
        this.numLines = this.line.size();
        this.lineWidth = new int[this.numLines];
    }

    protected void measure() {
        if (!this.maxAllowedSet) {
            this.maxAllowed = this.getParent().getSize().width;
        }
        if (this.maxAllowed < 20) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.divideLabel();
        this.lineHeight = fontMetrics.getHeight();
        this.lineDescent = fontMetrics.getDescent();
        this.maxWidth = 0;
        for (int i2 = 0; i2 < this.numLines; ++i2) {
            this.lineWidth[i2] = fontMetrics.stringWidth(this.line.get(i2));
            if (this.lineWidth[i2] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidth[i2];
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.measure();
        Dimension size = this.getSize();
        int y2 = this.lineAscent + (size.height - this.numLines * this.lineHeight) / 2;
        for (int i2 = 0; i2 < this.numLines; ++i2) {
            int x2;
            y2 += this.lineHeight;
            switch (this.alignment) {
                case 0: {
                    x2 = this.marginWidth;
                    break;
                }
                case 1: {
                    x2 = (size.width - this.lineWidth[i2]) / 2;
                    break;
                }
                case 2: {
                    x2 = size.width - this.marginWidth - this.lineWidth[i2];
                    break;
                }
                default: {
                    x2 = (size.width - this.lineWidth[i2]) / 2;
                }
            }
            graphics.drawString(this.line.get(i2), x2, y2);
        }
    }

    public void setText(String labelText) {
        this.labelText = labelText;
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setColor(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setJustify(int alignment) {
        this.alignment = alignment;
        this.repaint();
    }

    public void setMaxWidth(int width) {
        this.maxAllowed = width;
        this.maxAllowedSet = true;
        this.repaint();
    }

    public void setMarginWidth(int margin) {
        this.marginWidth = margin;
        this.repaint();
    }

    public void setMarginHeight(int margin) {
        this.marginHeight = margin;
        this.repaint();
    }

    @Override
    public void setBounds(int x2, int y2, int width, int height) {
        super.setBounds(x2, y2, width, height);
        this.maxAllowed = width;
        this.maxAllowedSet = true;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }
}

