/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JDialog
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = -357544689286217809L;
    private static final Logger logger = Logger.getLogger(HelpWindow.class.getName());
    private JPanel contentPane = null;
    private JEditorPane htmlHelp = null;
    private JButton closeButton = null;
    private JScrollPane scrollPane = null;
    private String closeButtonText = "Close";

    public HelpWindow(Frame owner, String closeButtonText) {
        super(owner, true);
        this.closeButtonText = closeButtonText;
        this.initialize();
    }

    private void initialize() {
        this.setSize(600, 400);
        this.setDefaultCloseOperation(1);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.contentPane.add((Component)this.getScrollPane(), null);
            this.contentPane.add((Component)this.getCloseButton(), null);
        }
        return this.contentPane;
    }

    private JEditorPane getHtmlHelp() {
        if (this.htmlHelp == null) {
            try {
                this.htmlHelp = new JEditorPane();
                this.htmlHelp.setContentType("text/html");
                this.htmlHelp.setEditable(false);
                this.htmlHelp.addHyperlinkListener(this);
            }
            catch (Throwable e2) {
                logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        return this.htmlHelp;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            try {
                this.scrollPane = new JScrollPane(this.getHtmlHelp());
            }
            catch (Throwable e2) {
                logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        return this.scrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            try {
                this.closeButton = new JButton(this.closeButtonText);
                this.closeButton.setAlignmentX(0.5f);
                this.closeButton.addActionListener(this);
            }
            catch (Throwable e2) {
                logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        return this.closeButton;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e2) {
        try {
            if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = e2.getURL().toString();
                if (url.startsWith("#")) {
                    this.getHtmlHelp().setPage(e2.getURL());
                } else {
                    Desktop.getDesktop().browse(e2.getURL().toURI());
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void showHelp(String title, URL helpDocument) {
        this.setTitle(title);
        try {
            this.getHtmlHelp().setPage(helpDocument);
        }
        catch (IOException e2) {
            logger.log(Level.WARNING, e2.getMessage(), e2);
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }
}

