/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.jar;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.MergeException;
import com.izforge.izpack.merge.AbstractMerge;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;

public class JarMerge
extends AbstractMerge {
    private final String jarPath;
    private final String regexp;
    private final String destination;

    public JarMerge(URL resource, String jarPath, Map<OutputStream, List<String>> mergeContent) {
        this.jarPath = jarPath;
        this.mergeContent = mergeContent;
        this.destination = FileUtil.convertUrlToFilePath(resource).replace(this.jarPath, "").replaceAll("file:", "").replaceAll("!/?", "").replaceAll("//", "/");
        StringBuilder builder = new StringBuilder(this.destination.replace("$", "\\$"));
        if (this.destination.endsWith("/")) {
            builder.append("+(.*)");
        } else {
            builder.append("/*(.*)");
        }
        this.regexp = builder.toString();
    }

    public JarMerge(String jarPath, String pathInsideJar, String destination, Map<OutputStream, List<String>> mergeContent) {
        this.jarPath = jarPath;
        this.destination = destination;
        this.mergeContent = mergeContent;
        StringBuilder builder = new StringBuilder().append(pathInsideJar);
        if (pathInsideJar.endsWith("/")) {
            builder.append("+(.*)");
        } else {
            builder.append("/*(.*)");
        }
        this.regexp = builder.toString();
    }

    @Override
    public File find(FileFilter fileFilter) {
        try {
            ArrayList<String> fileNameInZip = this.getFileNameInJar();
            for (String fileName : fileNameInZip) {
                File file = new File(this.jarPath + "!/" + fileName);
                if (!fileFilter.accept(file)) continue;
                return file;
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return null;
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        try {
            ArrayList<String> fileNameInZip = this.getFileNameInJar();
            ArrayList<File> result = new ArrayList<File>();
            ArrayList<File> filteredResult = new ArrayList<File>();
            for (String fileName : fileNameInZip) {
                result.add(new File(this.jarPath + "!" + fileName));
            }
            for (File file : result) {
                if (!fileFilter.accept(file)) continue;
                filteredResult.add(file);
            }
            return filteredResult;
        }
        catch (IOException e2) {
            throw new MergeException(e2);
        }
    }

    private ArrayList<String> getFileNameInJar() throws IOException {
        JarFile jarFile = new JarFile(this.jarPath);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            arrayList.add(jarEntry.getName());
        }
        return arrayList;
    }

    @Override
    public void merge(ZipOutputStream outputStream) {
        this.mergeImpl(outputStream);
    }

    private void mergeImpl(OutputStream outputStream) {
        Pattern pattern = Pattern.compile(this.regexp);
        List<String> mergeList = this.getMergeList(outputStream);
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(this.jarPath);
            Enumeration<JarEntry> jarFileEntries = jarFile.entries();
            while (jarFileEntries.hasMoreElements()) {
                Matcher matcher;
                JarEntry jarEntry = jarFileEntries.nextElement();
                if (this.isManifest(jarEntry.getName()) || !(matcher = pattern.matcher(jarEntry.getName())).matches() || this.isSignature(jarEntry.getName()) || mergeList.contains(jarEntry.getName())) continue;
                mergeList.add(jarEntry.getName());
                String matchFile = matcher.group(1);
                StringBuilder dest = new StringBuilder(this.destination);
                if (matchFile != null && matchFile.length() > 0) {
                    if (dest.length() > 0 && dest.charAt(dest.length() - 1) != '/') {
                        dest.append('/');
                    }
                    dest.append(matchFile);
                }
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                IoHelper.copyStreamToJar(inputStream, (ZipOutputStream)outputStream, dest.toString().replaceAll("//", "/"), jarEntry.getTime());
            }
        }
        catch (IOException e2) {
            throw new IzPackException("Error accessing file: " + this.jarPath, e2.getCause());
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public String toString() {
        return "JarMerge{jarPath='" + this.jarPath + '\'' + ", regexp='" + this.regexp + '\'' + ", destination='" + this.destination + '\'' + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        JarMerge jarMerge = (JarMerge)o2;
        return this.jarPath != null ? this.jarPath.equals(jarMerge.jarPath) : jarMerge.jarPath == null;
    }

    public int hashCode() {
        return this.jarPath != null ? this.jarPath.hashCode() : 0;
    }

    private boolean isSignature(String name) {
        return name.matches("/?META-INF/.*\\.(SF|DSA|RSA)") || name.matches("/?META-INF/SIG-.*");
    }

    private boolean isManifest(String name) {
        return name.equals("META-INF/MANIFEST.MF");
    }
}

