/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.ExecutableFile;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.MonitorInputStream;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileExecutor {
    private static final Logger logger = Logger.getLogger(FileExecutor.class.getName());
    private static final String JAR_FILE_SUFFIX = ".jar";
    private final Collection<ExecutableFile> files;

    private boolean stopThread(Thread t2, MonitorInputStream monitorInputStream) {
        monitorInputStream.stop();
        long softTimeout = 1000L;
        try {
            t2.join(softTimeout);
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        if (!t2.isAlive()) {
            return true;
        }
        t2.interrupt();
        long hardTimeout = 1000L;
        try {
            t2.join(hardTimeout);
        }
        catch (InterruptedException e3) {
            // empty catch block
        }
        return !t2.isAlive();
    }

    public FileExecutor(Collection<ExecutableFile> files) {
        this.files = files;
    }

    public FileExecutor() {
        this.files = null;
    }

    public static String getExecOutput(String[] aCommandLine) {
        return FileExecutor.getExecOutput(aCommandLine, null, false);
    }

    public static String getExecOutput(String[] aCommandLine, String dir) {
        return FileExecutor.getExecOutput(aCommandLine, dir, false);
    }

    public static String getExecOutput(String[] aCommandLine, boolean forceToGetStdOut) {
        return FileExecutor.getExecOutput(aCommandLine, null, forceToGetStdOut);
    }

    private static String getExecOutput(String[] aCommandLine, String dir, boolean forceToGetStdOut) {
        FileExecutor fileExecutor = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fileExecutor.executeCommand(aCommandLine, execOut, dir);
        if (execResult == 0) {
            return execOut[0];
        }
        if (forceToGetStdOut) {
            return execOut[0];
        }
        return execOut[1];
    }

    public int executeCommand(String[] params, String[] output) {
        return this.executeCommand(params, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String[] params, String[] output, String dir) {
        StringBuilder retval = new StringBuilder();
        retval.append("executeCommand\n");
        if (params != null) {
            for (String param : params) {
                retval.append("\tparams: ").append(param);
                retval.append("\n");
            }
        }
        if (dir != null) {
            retval.append("working dir: ").append(dir).append("\n");
        }
        Process process = null;
        MonitorInputStream outMonitor = null;
        MonitorInputStream errMonitor = null;
        Thread outMonitorThread = null;
        Thread errMonitorThread = null;
        int exitStatus = -1;
        logger.fine(retval.toString());
        try {
            if (params[0].matches("^.*[\\\\/]+\\.+[\\\\/]+.*$")) {
                params[0] = new File(params[0]).getCanonicalPath();
            }
            if (dir != null) {
                if (dir.matches("^.*[\\\\/]+\\.+[\\\\/]+.*$")) {
                    dir = new File(dir).getCanonicalPath();
                }
                process = Runtime.getRuntime().exec(params, null, new File(dir));
            } else {
                process = Runtime.getRuntime().exec(params);
            }
            StringWriter outWriter = new StringWriter();
            StringWriter errWriter = new StringWriter();
            InputStreamReader outStreamReader = new InputStreamReader(process.getInputStream());
            InputStreamReader errStreamReader = new InputStreamReader(process.getErrorStream());
            outMonitor = new MonitorInputStream(outStreamReader, outWriter);
            errMonitor = new MonitorInputStream(errStreamReader, errWriter);
            outMonitorThread = new Thread(outMonitor);
            errMonitorThread = new Thread(errMonitor);
            outMonitorThread.setDaemon(true);
            errMonitorThread.setDaemon(true);
            outMonitorThread.start();
            errMonitorThread.start();
            exitStatus = process.waitFor();
            outMonitorThread.join();
            errMonitorThread.join();
            output[0] = outWriter.toString();
            logger.fine("stdout:");
            logger.fine(output[0]);
            output[1] = errWriter.toString();
            logger.fine("stderr:");
            logger.fine(output[1]);
            logger.fine("exit status: " + Integer.toString(exitStatus));
        }
        catch (InterruptedException e2) {
            logger.log(Level.FINE, "Command execution interrupted", e2);
            this.stopThread(outMonitorThread, outMonitor);
            this.stopThread(errMonitorThread, errMonitor);
            output[0] = "";
            output[1] = e2.getMessage() + "\n";
        }
        catch (IOException e3) {
            logger.log(Level.FINE, "Command execution failed", e3);
            output[0] = "";
            output[1] = e3.getMessage() + "\n";
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return exitStatus;
    }

    public int executeFiles(int currentStage, PlatformModelMatcher matcher, AbstractUIHandler handler) {
        int exitStatus = 0;
        String[] output = new String[2];
        String permissions = "a+x";
        boolean isUnix = matcher.getCurrentPlatform().isA(Platform.Name.UNIX);
        Iterator<ExecutableFile> efileIterator = this.files.iterator();
        while (exitStatus == 0 && efileIterator.hasNext()) {
            ExecutableFile efile = efileIterator.next();
            boolean deleteAfterwards = !efile.keepFile;
            File file = new File(efile.path);
            logger.fine("Handling executable file " + efile + "...");
            if (!matcher.matchesCurrentPlatform(efile.osList)) continue;
            if (0 == efile.type && currentStage != 2 && isUnix) {
                logger.fine("Making file executable (setting executable flag)");
                String[] params = new String[]{"/bin/chmod", permissions, file.toString()};
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    handler.emitWarning("file execution error", "Error executing \n" + params[0] + " " + params[1] + " " + params[2]);
                    continue;
                }
            }
            if (currentStage == 0 && efile.executionStage == 0 || currentStage == 2 && efile.executionStage == 2) {
                ArrayList<String> paramList = new ArrayList<String>();
                if (0 == efile.type) {
                    paramList.add(file.toString());
                } else if (1 == efile.type && null == efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    paramList.add("-jar");
                    paramList.add(file.toString());
                } else if (1 == efile.type && null != efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    paramList.add("-cp");
                    try {
                        paramList.add(this.buildClassPath(file.toString()));
                    }
                    catch (Exception e2) {
                        logger.log(Level.WARNING, e2.getMessage(), e2);
                    }
                    paramList.add(efile.mainClass);
                }
                if (null != efile.argList && !efile.argList.isEmpty()) {
                    paramList.addAll(efile.argList);
                }
                String[] params = new String[paramList.size()];
                for (int i2 = 0; i2 < paramList.size(); ++i2) {
                    params[i2] = (String)paramList.get(i2);
                }
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    deleteAfterwards = false;
                    String message = output[0] + "\n" + output[1];
                    if (message.length() == 1) {
                        message = "Failed to execute " + file.toString() + ".";
                    }
                    if (efile.onFailure == 0) {
                        handler.emitError("File execution returned " + exitStatus, message);
                    } else if (efile.onFailure == 1) {
                        handler.emitWarning("File execution returned " + exitStatus, message);
                        exitStatus = 0;
                    } else if (efile.onFailure == 3) {
                        exitStatus = 0;
                    } else if (handler.askQuestion("Execution Failed", message + "\nContinue Installation?", 37) == 47) {
                        exitStatus = 0;
                    }
                }
            }
            if (efile.executionStage != 0 || !deleteAfterwards || !file.canWrite()) continue;
            file.delete();
        }
        return exitStatus;
    }

    private String buildClassPath(String targetFile) {
        String[] rawJars;
        StringBuilder classPath = new StringBuilder();
        ArrayList<String> jars = new ArrayList<String>();
        String rawClassPath = targetFile.replaceAll(":\\\\", "#DRIVE#").replaceAll(";", "#").replaceAll(":", "#").replace("#DRIVE#", ":\\");
        for (String rawJar : rawJars = rawClassPath.split("#")) {
            String[] subDirJars;
            File file = new File(rawJar);
            jars.add(rawJar);
            if (!file.isDirectory() || (subDirJars = FileUtil.getFileNames(rawJar, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(FileExecutor.JAR_FILE_SUFFIX);
                }
            })) == null) continue;
            for (String subDirJar : subDirJars) {
                jars.add(rawJar + File.separator + subDirJar);
            }
        }
        Iterator iter = jars.iterator();
        if (iter.hasNext()) {
            classPath.append((String)iter.next());
        }
        while (iter.hasNext()) {
            classPath.append(File.pathSeparatorChar).append((String)iter.next());
        }
        return classPath.toString();
    }
}

