/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.PathTokenizer;
import com.izforge.izpack.util.file.types.DataType;
import com.izforge.izpack.util.file.types.DirSet;
import com.izforge.izpack.util.file.types.FileList;
import com.izforge.izpack.util.file.types.FileSet;
import java.io.File;
import java.util.Vector;
import java.util.logging.Logger;

public class Path
extends DataType
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Path.class.getName());
    private Vector<Object> elements;

    public Path(InstallData idata, String path) throws Exception {
        this.createPathElement().setPath(idata, path);
    }

    public Path() {
        this.elements = new Vector();
    }

    public void setLocation(File location) throws Exception {
        this.createPathElement().setLocation(location);
    }

    public void setPath(InstallData idata, String path) throws Exception {
        this.createPathElement().setPath(idata, path);
    }

    public PathElement createPathElement() throws Exception {
        PathElement pe = new PathElement();
        this.elements.addElement(pe);
        return pe;
    }

    public void addFileset(FileSet fs) throws Exception {
        this.elements.addElement(fs);
        this.setChecked(false);
    }

    public void addFilelist(FileList fl) throws Exception {
        this.elements.addElement(fl);
        this.setChecked(false);
    }

    public void addDirset(DirSet dset) throws Exception {
        this.elements.addElement(dset);
        this.setChecked(false);
    }

    public void add(Path path) throws Exception {
        this.elements.addElement(path);
        this.setChecked(false);
    }

    public Path createPath() throws Exception {
        Path p2 = new Path();
        this.elements.addElement(p2);
        this.setChecked(false);
        return p2;
    }

    public void append(Path other) throws Exception {
        String[] pathElements;
        if (other == null) {
            return;
        }
        for (String pathElement : pathElements = other.list()) {
            if (this.elements.indexOf(pathElement) != -1) continue;
            this.elements.addElement(pathElement);
        }
    }

    public void addExisting(Path source) throws Exception {
        this.addExisting(source, false);
    }

    public void addExisting(Path source, boolean tryUserDir) throws Exception {
        String[] pathElements = source.list();
        File userDir = tryUserDir ? new File(System.getProperty("user.dir")) : null;
        for (String pathElement : pathElements) {
            File f2 = null;
            f2 = new File(pathElement);
            if (tryUserDir && !f2.exists()) {
                f2 = new File(userDir, pathElement);
            }
            if (f2.exists()) {
                this.setLocation(f2);
                continue;
            }
            logger.warning("Dropping " + f2 + " from path as it doesn't exist");
        }
    }

    public String[] list() throws Exception {
        Vector<String> result = new Vector<String>(2 * this.elements.size());
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            Object o2 = this.elements.elementAt(i2);
            if (o2 instanceof String) {
                Path.addUnlessPresent(result, (String)o2);
                continue;
            }
            if (o2 instanceof PathElement) {
                String[] parts = ((PathElement)o2).getParts();
                if (parts == null) {
                    throw new Exception("You must either set location or path on <pathelement>");
                }
                for (String part : parts) {
                    Path.addUnlessPresent(result, part);
                }
                continue;
            }
            if (o2 instanceof Path) {
                String[] parts;
                Path p2 = (Path)o2;
                for (String part : parts = p2.list()) {
                    Path.addUnlessPresent(result, part);
                }
                continue;
            }
            if (o2 instanceof DirSet) {
                DirSet dset = (DirSet)o2;
                Path.addUnlessPresent(result, dset.getDir(), dset.getDirectoryScanner().getIncludedDirectories());
                continue;
            }
            if (o2 instanceof FileSet) {
                FileSet fs = (FileSet)o2;
                Path.addUnlessPresent(result, fs.getDir(), fs.getDirectoryScanner().getIncludedFiles());
                continue;
            }
            if (!(o2 instanceof FileList)) continue;
            FileList fl = (FileList)o2;
            Path.addUnlessPresent(result, fl.getDir(), fl.getFiles());
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public String toString() {
        try {
            String[] list = this.list();
            if (list.length == 0) {
                return "";
            }
            StringBuffer result = new StringBuffer(list[0].toString());
            for (int i2 = 1; i2 < list.length; ++i2) {
                result.append(File.pathSeparatorChar);
                result.append(list[i2]);
            }
            return result.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String[] translatePath(InstallData idata, String source) {
        Vector<String> result = new Vector<String>();
        if (source == null) {
            return new String[0];
        }
        PathTokenizer tok = new PathTokenizer(source);
        StringBuffer element = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String pathElement = tok.nextToken();
            try {
                element.append(Path.resolveFile(idata, pathElement));
            }
            catch (Exception e2) {
                logger.warning("Dropping path element " + pathElement + " as it is not a valid relative to the project");
            }
            for (int i2 = 0; i2 < element.length(); ++i2) {
                Path.translateFileSep(element, i2);
            }
            result.addElement(element.toString());
            element = new StringBuffer();
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public static String translateFile(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(source);
        for (int i2 = 0; i2 < result.length(); ++i2) {
            Path.translateFileSep(result, i2);
        }
        return result.toString();
    }

    protected static boolean translateFileSep(StringBuffer buffer, int pos) {
        if (buffer.charAt(pos) == '/' || buffer.charAt(pos) == '\\') {
            buffer.setCharAt(pos, File.separatorChar);
            return true;
        }
        return false;
    }

    public int size() throws Exception {
        return this.list().length;
    }

    public Object clone() {
        try {
            Path p2 = (Path)super.clone();
            p2.elements = (Vector)this.elements.clone();
            return p2;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String resolveFile(InstallData idata, String relativeName) throws Exception {
        File f2 = FileUtils.resolveFile(new File(idata.getInstallPath()), relativeName);
        return f2.getAbsolutePath();
    }

    private static void addUnlessPresent(Vector<String> v2, String s2) {
        if (v2.indexOf(s2) == -1) {
            v2.addElement(s2);
        }
    }

    private static void addUnlessPresent(Vector<String> v2, File dir, String[] s2) {
        for (String value : s2) {
            File d2 = new File(dir, value);
            String absolutePath = d2.getAbsolutePath();
            Path.addUnlessPresent(v2, Path.translateFile(absolutePath));
        }
    }

    public class PathElement {
        private String[] parts;

        public void setLocation(File loc) {
            this.parts = new String[]{Path.translateFile(loc.getAbsolutePath())};
        }

        public void setPath(InstallData idata, String path) {
            this.parts = Path.translatePath(idata, path);
        }

        public String[] getParts() {
            return this.parts;
        }
    }
}

