/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.regex;

import com.izforge.izpack.util.regex.Regexp;
import com.izforge.izpack.util.regex.RegexpMatcher;
import com.izforge.izpack.util.regex.RegexpMatcherFactory;

public class RegexpFactory
extends RegexpMatcherFactory {
    public Regexp newRegexp() throws RuntimeException {
        String systemDefault = System.getProperty("izpack.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createRegexpInstance(systemDefault);
        }
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createRegexpInstance("com.izforge.izpack.util.regex.JavaRegexp");
        }
        catch (Exception exception) {
            throw new RuntimeException("No supported regular expression matcher found");
        }
    }

    protected Regexp createRegexpInstance(String classname) throws RuntimeException {
        RegexpMatcher m2 = this.createInstance(classname);
        if (m2 instanceof Regexp) {
            return (Regexp)m2;
        }
        throw new RuntimeException(classname + " doesn't implement the Regexp interface");
    }
}

