/*
 * Decompiled with CFR 0.152.
 */
package jline;

import jline.TerminalSupport;
import jline.internal.Log;
import jline.internal.TerminalLineSettings;

public class UnixTerminal
extends TerminalSupport {
    private final TerminalLineSettings settings = new TerminalLineSettings();

    public UnixTerminal() throws Exception {
        super(true);
    }

    protected TerminalLineSettings getSettings() {
        return this.settings;
    }

    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(true);
        this.settings.set("-icanon min 1 -icrnl -inlcr -ixon");
        this.settings.set("dsusp undef");
        this.setEchoEnabled(false);
    }

    public void restore() throws Exception {
        this.settings.restore();
        super.restore();
    }

    public int getWidth() {
        int w2 = this.settings.getProperty("columns");
        return w2 < 1 ? 80 : w2;
    }

    public int getHeight() {
        int h2 = this.settings.getProperty("rows");
        return h2 < 1 ? 24 : h2;
    }

    public synchronized void setEchoEnabled(boolean enabled) {
        try {
            if (enabled) {
                this.settings.set("echo");
            } else {
                this.settings.set("-echo");
            }
            super.setEchoEnabled(enabled);
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to ", enabled ? "enable" : "disable", " echo", e2);
        }
    }

    public void disableInterruptCharacter() {
        try {
            this.settings.set("intr undef");
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to disable interrupt character", e2);
        }
    }

    public void enableInterruptCharacter() {
        try {
            this.settings.set("intr ^C");
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to enable interrupt character", e2);
        }
    }
}

