/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jline.console.KeyMap;
import jline.console.Operation;
import jline.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleKeys {
    private KeyMap keys;
    private Map<String, KeyMap> keyMaps;
    private Map<String, String> variables = new HashMap<String, String>();

    public ConsoleKeys(String appName, URL inputrcUrl) {
        this.keyMaps = KeyMap.keyMaps();
        this.loadKeys(appName, inputrcUrl);
    }

    protected boolean isViEditMode() {
        return this.keys.isViKeyMap();
    }

    protected boolean setKeyMap(String name) {
        KeyMap map = this.keyMaps.get(name);
        if (map == null) {
            return false;
        }
        this.keys = map;
        return true;
    }

    protected Map<String, KeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    protected KeyMap getKeys() {
        return this.keys;
    }

    protected void setKeys(KeyMap keys) {
        this.keys = keys;
    }

    protected boolean getViEditMode() {
        return this.keys.isViKeyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys(String appName, URL inputrcUrl) {
        this.keys = this.keyMaps.get("emacs");
        try {
            InputStream input = inputrcUrl.openStream();
            try {
                this.loadKeys(input, appName);
                Log.debug("Loaded user configuration: ", inputrcUrl);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e2) {}
            }
        }
        catch (IOException e3) {
            if (inputrcUrl.getProtocol().equals("file")) {
                File file = new File(inputrcUrl.getPath());
                if (file.exists()) {
                    Log.warn("Unable to read user configuration: ", inputrcUrl, e3);
                }
            }
            Log.warn("Unable to read user configuration: ", inputrcUrl, e3);
        }
    }

    private void loadKeys(InputStream input, String appName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        boolean parsing = true;
        ArrayList<Boolean> ifsStack = new ArrayList<Boolean>();
        while ((line = reader.readLine()) != null) {
            try {
                String val;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int i2 = 0;
                if (line.charAt(i2) == '$') {
                    ++i2;
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    int s2 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    String cmd = line.substring(s2, i2);
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    s2 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    String args = line.substring(s2, i2);
                    if ("if".equalsIgnoreCase(cmd)) {
                        ifsStack.add(parsing);
                        if (!parsing || args.startsWith("term=")) continue;
                        if (args.startsWith("mode=")) {
                            if (args.equalsIgnoreCase("mode=vi")) {
                                parsing = this.isViEditMode();
                                continue;
                            }
                            if (args.equals("mode=emacs")) {
                                parsing = !this.isViEditMode();
                                continue;
                            }
                            parsing = false;
                            continue;
                        }
                        parsing = args.equalsIgnoreCase(appName);
                        continue;
                    }
                    if ("else".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("$else found without matching $if");
                        }
                        boolean invert = true;
                        Iterator i$ = ifsStack.iterator();
                        while (i$.hasNext()) {
                            boolean b2 = (Boolean)i$.next();
                            if (b2) continue;
                            invert = false;
                            break;
                        }
                        if (!invert) continue;
                        parsing = !parsing;
                        continue;
                    }
                    if ("endif".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("endif found without matching $if");
                        }
                        parsing = (Boolean)ifsStack.remove(ifsStack.size() - 1);
                        continue;
                    }
                    if (!"include".equalsIgnoreCase(cmd)) continue;
                }
                if (!parsing) continue;
                String keySeq = "";
                if (line.charAt(i2++) == '\"') {
                    boolean esc = false;
                    while (true) {
                        if (i2 >= line.length()) {
                            throw new IllegalArgumentException("Missing closing quote on line '" + line + "'");
                        }
                        if (esc) {
                            esc = false;
                        } else if (line.charAt(i2) == '\\') {
                            esc = true;
                        } else if (line.charAt(i2) == '\"') break;
                        ++i2;
                    }
                }
                while (i2 < line.length() && line.charAt(i2) != ':' && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                    ++i2;
                }
                keySeq = line.substring(0, i2);
                boolean equivalency = i2 + 1 < line.length() && line.charAt(i2) == ':' && line.charAt(i2 + 1) == '=';
                ++i2;
                if (equivalency) {
                    ++i2;
                }
                if (keySeq.equalsIgnoreCase("set")) {
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    int s3 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    String key = line.substring(s3, i2);
                    while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                        ++i2;
                    }
                    s3 = i2;
                    while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                        ++i2;
                    }
                    val = line.substring(s3, i2);
                    this.setVar(key, val);
                    continue;
                }
                while (i2 < line.length() && (line.charAt(i2) == ' ' || line.charAt(i2) == '\t')) {
                    ++i2;
                }
                int start = i2;
                if (i2 < line.length() && (line.charAt(i2) == '\'' || line.charAt(i2) == '\"')) {
                    char delim = line.charAt(i2++);
                    boolean esc = false;
                    while (i2 < line.length()) {
                        if (esc) {
                            esc = false;
                        } else if (line.charAt(i2) == '\\') {
                            esc = true;
                        } else if (line.charAt(i2) == delim) break;
                        ++i2;
                    }
                }
                while (i2 < line.length() && line.charAt(i2) != ' ' && line.charAt(i2) != '\t') {
                    ++i2;
                }
                val = line.substring(Math.min(start, line.length()), Math.min(i2, line.length()));
                if (keySeq.charAt(0) == '\"') {
                    keySeq = this.translateQuoted(keySeq);
                } else {
                    String keyName = keySeq.lastIndexOf(45) > 0 ? keySeq.substring(keySeq.lastIndexOf(45) + 1) : keySeq;
                    char key = this.getKeyFromName(keyName);
                    keyName = keySeq.toLowerCase();
                    keySeq = "";
                    if (keyName.contains("meta-") || keyName.contains("m-")) {
                        keySeq = keySeq + "\u001b";
                    }
                    if (keyName.contains("control-") || keyName.contains("c-") || keyName.contains("ctrl-")) {
                        key = (char)(Character.toUpperCase(key) & 0x1F);
                    }
                    keySeq = keySeq + key;
                }
                if (val.length() > 0 && (val.charAt(0) == '\'' || val.charAt(0) == '\"')) {
                    this.keys.bind(keySeq, this.translateQuoted(val));
                    continue;
                }
                String operationName = val.replace('-', '_').toUpperCase();
                try {
                    this.keys.bind(keySeq, (Object)Operation.valueOf(operationName));
                }
                catch (IllegalArgumentException e2) {
                    Log.info("Unable to bind key for unsupported operation: ", val);
                }
            }
            catch (IllegalArgumentException e3) {
                Log.warn("Unable to parse user configuration: ", e3);
            }
        }
    }

    private String translateQuoted(String keySeq) {
        String str = keySeq.substring(1, keySeq.length() - 1);
        keySeq = "";
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c2 = str.charAt(i2);
            if (c2 == '\\') {
                boolean meta;
                boolean ctrl = str.regionMatches(i2, "\\C-", 0, 3) || str.regionMatches(i2, "\\M-\\C-", 0, 6);
                if ((i2 += ((meta = str.regionMatches(i2, "\\M-", 0, 3) || str.regionMatches(i2, "\\C-\\M-", 0, 6)) ? 3 : 0) + (ctrl ? 3 : 0) + (!meta && !ctrl ? 1 : 0)) >= str.length()) break;
                c2 = str.charAt(i2);
                if (meta) {
                    keySeq = keySeq + "\u001b";
                }
                if (ctrl) {
                    char c3 = c2 = c2 == '?' ? (char)'\u007f' : (char)(Character.toUpperCase(c2) & 0x1F);
                }
                if (!meta && !ctrl) {
                    switch (c2) {
                        case 'a': {
                            c2 = '\u0007';
                            break;
                        }
                        case 'b': {
                            c2 = '\b';
                            break;
                        }
                        case 'd': {
                            c2 = '\u007f';
                            break;
                        }
                        case 'e': {
                            c2 = '\u001b';
                            break;
                        }
                        case 'f': {
                            c2 = '\f';
                            break;
                        }
                        case 'n': {
                            c2 = '\n';
                            break;
                        }
                        case 'r': {
                            c2 = '\r';
                            break;
                        }
                        case 't': {
                            c2 = '\t';
                            break;
                        }
                        case 'v': {
                            c2 = '\u000b';
                            break;
                        }
                        case '\\': {
                            c2 = '\\';
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int k2;
                            int j2;
                            c2 = '\u0000';
                            for (j2 = 0; j2 < 3 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 8)) >= 0; ++j2, ++i2) {
                                c2 = (char)(c2 * 8 + k2);
                            }
                            c2 = (char)(c2 & 0xFF);
                            break;
                        }
                        case 'x': {
                            int k2;
                            int j2;
                            ++i2;
                            c2 = '\u0000';
                            for (j2 = 0; j2 < 2 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 16)) >= 0; ++j2, ++i2) {
                                c2 = (char)(c2 * 16 + k2);
                            }
                            c2 = (char)(c2 & 0xFF);
                            break;
                        }
                        case 'u': {
                            int k2;
                            int j2;
                            ++i2;
                            c2 = '\u0000';
                            for (j2 = 0; j2 < 4 && i2 < str.length() && (k2 = Character.digit(str.charAt(i2), 16)) >= 0; ++j2, ++i2) {
                                c2 = (char)(c2 * 16 + k2);
                            }
                            break;
                        }
                    }
                }
                keySeq = keySeq + c2;
                continue;
            }
            keySeq = keySeq + c2;
        }
        return keySeq;
    }

    private char getKeyFromName(String name) {
        if ("DEL".equalsIgnoreCase(name) || "Rubout".equalsIgnoreCase(name)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(name) || "Escape".equalsIgnoreCase(name)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(name) || "NewLine".equalsIgnoreCase(name)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(name) || "Return".equalsIgnoreCase(name)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(name) || "Space".equalsIgnoreCase(name)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(name)) {
            return '\t';
        }
        return name.charAt(0);
    }

    private void setVar(String key, String val) {
        if ("keymap".equalsIgnoreCase(key)) {
            if (this.keyMaps.containsKey(val)) {
                this.keys = this.keyMaps.get(val);
            }
        } else if ("editing-mode".equals(key)) {
            if ("vi".equalsIgnoreCase(val)) {
                this.keys = this.keyMaps.get("vi-insert");
            } else if ("emacs".equalsIgnoreCase(key)) {
                this.keys = this.keyMaps.get("emacs");
            }
        } else if ("blink-matching-paren".equals(key)) {
            if ("on".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(true);
            } else if ("off".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(false);
            }
        }
        this.variables.put(key, val);
    }

    public String getVariable(String var) {
        return this.variables.get(var);
    }
}

