/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;

public final class ComponentMonitorHelper {
    public static final String INSTANTIATING = "PicoContainer: instantiating {0}";
    public static final String INSTANTIATED = "PicoContainer: instantiated {0} [{1} ms], component {2}, injected [{3}]";
    public static final String INSTANTIATION_FAILED = "PicoContainer: instantiation failed: {0}, reason: {1}";
    public static final String INVOKING = "PicoContainer: invoking {0} on {1}";
    public static final String INVOKED = "PicoContainer: invoked {0} on {1} [{2} ms]";
    public static final String INVOCATION_FAILED = "PicoContainer: invocation failed: {0} on {1}, reason: {2}";
    public static final String LIFECYCLE_INVOCATION_FAILED = "PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}";
    public static final String NO_COMPONENT = "PicoContainer: No component for key: {0}";

    public static String format(String template, Object ... arguments) {
        return MessageFormat.format(template, arguments);
    }

    public static String parmsToString(Object[] injected) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < injected.length; ++i2) {
            String s2 = injected[i2].getClass().getName();
            sb.append(s2);
            if (i2 >= injected.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String ctorToString(Constructor constructor) {
        Class<?>[] params = constructor.getParameterTypes();
        StringBuffer sb = new StringBuffer(constructor.getName());
        sb.append("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            String s2 = params[i2].getName();
            sb.append(s2);
            if (i2 >= params.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String methodToString(Member member) {
        StringBuffer sb = new StringBuffer(member.getName());
        if (member instanceof Method) {
            Class<?>[] params = ((Method)member).getParameterTypes();
            sb.append("(");
            for (int i2 = 0; i2 < params.length; ++i2) {
                String s2 = params[i2].getName();
                sb.append(s2);
                if (i2 >= params.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static String memberToString(Member m2) {
        if (m2 instanceof Field) {
            return ComponentMonitorHelper.toString((Field)m2);
        }
        return ComponentMonitorHelper.methodToString((Method)m2);
    }

    public static String toString(Field field) {
        StringBuffer sb = new StringBuffer(field.getName());
        sb.append("(").append(field.getName()).append(")");
        return sb.toString();
    }
}

