/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.parameters.AbstractParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantParameter
extends AbstractParameter
implements Parameter,
Serializable {
    private final Object value;

    public ConstantParameter(Object value) {
        this.value = value;
    }

    @Override
    public Parameter.Resolver resolve(PicoContainer container, ComponentAdapter<?> forAdapter, ComponentAdapter<?> injecteeAdapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        if (expectedType instanceof Class) {
            return new Parameter.ValueResolver(this.isAssignable((Class)expectedType), this.value, null);
        }
        if (expectedType instanceof ParameterizedType) {
            return new Parameter.ValueResolver(this.isAssignable(((ParameterizedType)expectedType).getRawType()), this.value, null);
        }
        return new Parameter.ValueResolver(true, this.value, null);
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) throws PicoException {
        if (!this.isAssignable(expectedType)) {
            throw new PicoCompositionException(expectedType + " is not assignable from " + (this.value != null ? this.value.getClass().getName() : "null"));
        }
    }

    protected boolean isAssignable(Type expectedType) {
        Class expectedClass;
        return expectedType instanceof Class && (this.checkPrimitive(expectedClass = (Class)expectedType) || expectedClass.isInstance(this.value));
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private boolean checkPrimitive(Class expectedType) {
        try {
            if (expectedType.isPrimitive()) {
                Field field = this.value.getClass().getField("TYPE");
                Class type = (Class)field.get(this.value);
                return expectedType.isAssignableFrom(type);
            }
        }
        catch (NoSuchFieldException e2) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }
}

