/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.WebAPIServicesCatalogItem;
import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebHandlerAPIWrapper;
import au.com.aemo.Common.Web.WebHandlerAPIWrapperMethod;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebPath;
import au.com.aemo.Common.Web.WebSecurityAuthenticationEnum;
import au.com.aemo.Common.Web.WebServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@WebPath(value="/api/webservices")
public class WebAPIServicesCatalog {
    private void addApplicationSummary(StringBuilder stringBuilder) {
        stringBuilder.append("<TABLE>");
        stringBuilder.append("<TR>");
        this.addData(stringBuilder, "Application:");
        this.addData(stringBuilder, ApplicationManager.getInstance().getApplication().getAppName());
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.addData(stringBuilder, "Version:");
        this.addData(stringBuilder, ApplicationManager.getInstance().getApplication().getAppVersion());
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    private void addHeader(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<TH>");
        stringBuilder.append(Util.noNull(string));
        stringBuilder.append("</TH>");
    }

    private void addData(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<TD>");
        stringBuilder.append(Util.noNull(string));
        stringBuilder.append("</TD>");
    }

    private List<WebAPIServicesCatalogItem> buildAPIDetail(WebHandlerAPIWrapper webHandlerAPIWrapper, String string) {
        ArrayList<WebAPIServicesCatalogItem> arrayList = new ArrayList<WebAPIServicesCatalogItem>();
        List<WebHandlerAPIWrapperMethod> list = webHandlerAPIWrapper.getMethods(string);
        if (list != null) {
            for (WebHandlerAPIWrapperMethod webHandlerAPIWrapperMethod : list) {
                WebAPIServicesCatalogItem webAPIServicesCatalogItem = new WebAPIServicesCatalogItem();
                webAPIServicesCatalogItem.Path = webHandlerAPIWrapperMethod.path;
                webAPIServicesCatalogItem.Method = string;
                if (webHandlerAPIWrapperMethod.urlPathParamNames != null && webHandlerAPIWrapperMethod.urlPathParamNames.size() > 0) {
                    webAPIServicesCatalogItem.Parameters = String.join((CharSequence)",", webHandlerAPIWrapperMethod.urlPathParamNames.values().toString());
                }
                webAPIServicesCatalogItem.Authentication = webHandlerAPIWrapperMethod.auth.name();
                webAPIServicesCatalogItem.AuthContext = webHandlerAPIWrapperMethod.AuthContext;
                webAPIServicesCatalogItem.Action = webHandlerAPIWrapperMethod.action.name();
                webAPIServicesCatalogItem.ContentType = webHandlerAPIWrapperMethod.contentType;
                webAPIServicesCatalogItem.AdminAccessOnly = webHandlerAPIWrapperMethod.AdminAccessOnly;
                webAPIServicesCatalogItem.HandlerClass = webHandlerAPIWrapperMethod.clazz.getName();
                webAPIServicesCatalogItem.HandlerMethod = webHandlerAPIWrapperMethod.method.getName();
                arrayList.add(webAPIServicesCatalogItem);
            }
        }
        return arrayList;
    }

    @WebGET(Action=AuthorisationActionEnum.READ, Authentication=WebSecurityAuthenticationEnum.PUBLIC)
    @WebContent(value=WebContent.MediaType.TEXT_HTML)
    public String getServicesCatalog(final @WebParam(source="sort", mandatory=false, validatorParam=WebParamValidationEnum.STR_COMMA_DELIMITED_LIST) String string) throws Exception {
        ArrayList<WebAPIServicesCatalogItem> arrayList = new ArrayList<WebAPIServicesCatalogItem>();
        for (WebHandlerAPIWrapper object : WebServer.getInstance().getHandlers()) {
            arrayList.addAll(this.buildAPIDetail(object, "GET"));
            arrayList.addAll(this.buildAPIDetail(object, "POST"));
        }
        if (!Util.isBlank(string)) {
            Collections.sort(arrayList, new Comparator<WebAPIServicesCatalogItem>(){

                @Override
                public int compare(WebAPIServicesCatalogItem webAPIServicesCatalogItem, WebAPIServicesCatalogItem webAPIServicesCatalogItem2) {
                    int n2 = 0;
                    for (String string2 : Util.getColumns(string, ',')) {
                        if (string2.equalsIgnoreCase("HandlerClass")) {
                            n2 = webAPIServicesCatalogItem.HandlerClass.compareTo(webAPIServicesCatalogItem2.HandlerClass);
                        } else if (string2.equalsIgnoreCase("HandlerMethod")) {
                            n2 = webAPIServicesCatalogItem.HandlerMethod.compareTo(webAPIServicesCatalogItem2.HandlerMethod);
                        } else if (string2.equalsIgnoreCase("Path")) {
                            n2 = webAPIServicesCatalogItem.Path.compareTo(webAPIServicesCatalogItem2.Path);
                        } else if (string2.equalsIgnoreCase("Method")) {
                            n2 = webAPIServicesCatalogItem.Method.compareTo(webAPIServicesCatalogItem2.Method);
                        }
                        if (n2 != 0) break;
                    }
                    return n2;
                }
            });
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<HTML>");
        stringBuilder.append("<BODY>");
        stringBuilder.append("Web Service API summary");
        stringBuilder.append("<BR/>");
        stringBuilder.append("<BR/>");
        this.addApplicationSummary(stringBuilder);
        stringBuilder.append("<BR/>");
        stringBuilder.append("<TABLE>");
        stringBuilder.append("<TR>");
        this.addHeader(stringBuilder, "Path");
        this.addHeader(stringBuilder, "Method");
        this.addHeader(stringBuilder, "Parameters");
        this.addHeader(stringBuilder, "Authentication");
        this.addHeader(stringBuilder, "Auth Context");
        this.addHeader(stringBuilder, "Action");
        this.addHeader(stringBuilder, "Content Type");
        this.addHeader(stringBuilder, "Admin Access only");
        this.addHeader(stringBuilder, "Handler Class");
        this.addHeader(stringBuilder, "Handler Method");
        stringBuilder.append("</TR>");
        for (WebAPIServicesCatalogItem webAPIServicesCatalogItem : arrayList) {
            stringBuilder.append("<TR>");
            this.addData(stringBuilder, webAPIServicesCatalogItem.Path);
            this.addData(stringBuilder, webAPIServicesCatalogItem.Method);
            this.addData(stringBuilder, webAPIServicesCatalogItem.Parameters);
            this.addData(stringBuilder, webAPIServicesCatalogItem.Authentication);
            this.addData(stringBuilder, webAPIServicesCatalogItem.AuthContext);
            this.addData(stringBuilder, webAPIServicesCatalogItem.Action);
            this.addData(stringBuilder, webAPIServicesCatalogItem.ContentType);
            this.addData(stringBuilder, Boolean.valueOf(webAPIServicesCatalogItem.AdminAccessOnly).toString());
            this.addData(stringBuilder, webAPIServicesCatalogItem.HandlerClass);
            this.addData(stringBuilder, webAPIServicesCatalogItem.HandlerMethod);
            stringBuilder.append("</TR>");
        }
        stringBuilder.append("</TABLE>");
        stringBuilder.append("</BODY>");
        stringBuilder.append("</HTML>");
        return stringBuilder.toString();
    }
}

