/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.API;

import au.com.aemo.Common.API.DeleteSet;
import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Certificate.CertificateDetail;
import au.com.aemo.Common.Certificate.CertificateList;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.Certificate.CertificateStoreConfig;
import au.com.aemo.Common.Certificate.CertificateUtilities;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebGET;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParamValidatorTypeJSON;
import au.com.aemo.Common.Web.WebPath;
import au.com.aemo.Common.Web.WebServer;

@WebPath(value="/api/web/certificates")
public class WebAPIWebCertificateManagement {
    @WebGET(AdminAccessOnly=true, Action=AuthorisationActionEnum.READ)
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String getCertificateList(@WebParam(source="StoreType", mandatory=false, validatorParam=WebParamValidationEnum.STR_OBJECT_ID, defaultValue="SERVER") String string) throws Exception {
        CertificateList certificateList = new CertificateList();
        if (string.equalsIgnoreCase("SERVER")) {
            WebServer webServer = WebServer.getInstance();
            CertificateStoreConfig certificateStoreConfig = webServer.getConfig().HTTPS;
            CertificateUtilities certificateUtilities = new CertificateUtilities();
            certificateUtilities.setCertStoreConfig(certificateStoreConfig);
            certificateList.Certificates = certificateUtilities.getCertificateList();
        } else if (string.equalsIgnoreCase("CLIENT")) {
            certificateList.Certificates = CertificateManager.getInstance().getCertificateList();
        }
        return JsonUtilities.toJson(certificateList);
    }

    @WebPOST(AdminAccessOnly=true, Action=AuthorisationActionEnum.WRITE, Path="delete")
    @WebContent(value=WebContent.MediaType.APPLICATION_JSON)
    public String removeCertificates(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeJSON.class) DeleteSet deleteSet) throws Exception {
        String string = null;
        try {
            int n2 = 0;
            if (deleteSet != null && deleteSet.Certificates != null) {
                CertificateManager certificateManager = CertificateManager.getInstance();
                for (CertificateDetail certificateDetail : deleteSet.Certificates) {
                    certificateManager.removeCertificate(certificateDetail.Alias);
                    ++n2;
                }
            }
            string = "Successfully removed [" + n2 + "] certificates";
        }
        catch (Exception exception) {
            string = "Failed to remove certificates: " + exception.getMessage();
        }
        return string;
    }
}

