/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.CSV;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.CSV.Csv;
import au.com.aemo.Common.CSV.CsvWriter;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvSerialisation {
    private static Logger logger = LoggerFactory.getLogger(CsvSerialisation.class);

    private static Map<String, Field> getObjectMapper(List<String> list, Class clazz) {
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            for (String string : list) {
                boolean bl = false;
                if (string.equalsIgnoreCase(field.getName())) {
                    bl = true;
                } else if (string.replaceAll("_", "").equalsIgnoreCase(field.getName())) {
                    bl = true;
                } else if (("its" + string.replaceAll("_", "")).equalsIgnoreCase(field.getName())) {
                    bl = true;
                }
                if (!bl) continue;
                hashMap.put(string, field);
            }
        }
        return hashMap;
    }

    private static Map<String, Field> getObjectMapper(Class clazz) {
        LinkedHashMap<String, Field> linkedHashMap = new LinkedHashMap<String, Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            String string = field.getName();
            if (field.getName().toLowerCase().startsWith("its")) {
                string = field.getName().substring(3);
            }
            if (field.getName().toLowerCase().startsWith("_")) {
                string = field.getName().substring(1);
            }
            Matcher matcher = Pattern.compile("(?<=[a-z])[A-Z]").matcher(string);
            String string2 = matcher.replaceAll(matchResult -> "_" + matchResult.group().toUpperCase()).toUpperCase();
            linkedHashMap.put(string2, field);
        }
        return linkedHashMap;
    }

    public static <T> List<T> readObjects(String string, List<String> list, Class<T> clazz) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            List<T> list2 = CsvSerialisation.readObjects(fileInputStream, list, clazz);
            return list2;
        }
    }

    public static <T> List<T> readObjects(InputStream inputStream, List<String> list, Class<T> clazz) throws ApplicationException {
        ArrayList<T> arrayList = new ArrayList<T>();
        String string = "";
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Map<Object, Object> map = new HashMap();
        Csv csv = new Csv();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            while (true) {
                int n4;
                String[] stringArray;
                string = bufferedReader.readLine();
                ++n2;
                if (string == null) {
                    break;
                }
                if (string.startsWith("I,")) {
                    stringArray = csv.parse(string);
                    int n5 = 1;
                    n4 = 1;
                    for (String string2 : list) {
                        if (!string2.equalsIgnoreCase(stringArray[n5]) && !string2.equalsIgnoreCase("*")) {
                            n4 = 0;
                            break;
                        }
                        ++n5;
                    }
                    if (n4 != 0) {
                        arrayList2 = new ArrayList();
                        for (int i2 = list.size(); i2 < stringArray.length; ++i2) {
                            arrayList2.add(stringArray[i2]);
                        }
                        map = CsvSerialisation.getObjectMapper(arrayList2, clazz);
                    }
                    n3 = n4;
                    continue;
                }
                if (!string.startsWith("D,") || n3 == 0) continue;
                stringArray = csv.parse(string);
                T t2 = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                n4 = list.size();
                for (String string2 : arrayList2) {
                    String string3 = stringArray[n4];
                    Field field = (Field)map.get(string2);
                    if (field != null) {
                        field.setAccessible(true);
                        if (field.getType() == String.class) {
                            field.set(t2, string3);
                        } else if (field.getType() == Date.class) {
                            field.set(t2, Util.strToDate(string3, "dd/MM/yyyy HH:mm:ss"));
                        } else if (field.getType() == Integer.TYPE) {
                            field.setInt(t2, Integer.parseInt(string3));
                        } else if (field.getType() == Integer.class) {
                            field.set(t2, Integer.valueOf(string3));
                        } else if (field.getType() == Long.TYPE) {
                            field.setLong(t2, Long.parseLong(string3));
                        } else if (field.getType() == Long.class) {
                            field.set(t2, Long.valueOf(string3));
                        } else if (field.getType() == Boolean.TYPE) {
                            field.setBoolean(t2, Util.intToBoolean(Integer.parseInt(string3)));
                        } else if (field.getType() == Boolean.class) {
                            field.set(t2, Util.intToBoolean(Integer.parseInt(string3)));
                        } else if (field.getType().isEnum()) {
                            field.set(t2, Enum.valueOf(field.getType(), string3));
                        } else {
                            field.set(t2, string3);
                        }
                    }
                    ++n4;
                }
                arrayList.add(t2);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error processing file on line " + n2 + ": " + exception.getMessage(), exception);
        }
        return arrayList;
    }

    public static <T> List<T> writeObjects(String string, List<String> list, Class<T> clazz, List<T> list2) throws Exception {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            List<T> list3 = CsvSerialisation.writeObjects(fileOutputStream, list, clazz, list2);
            return list3;
        }
    }

    public static <T> List<T> writeObjects(OutputStream outputStream, List<String> list, Class<T> clazz, List<T> list2) throws ApplicationException {
        ArrayList arrayList = new ArrayList();
        String string = "";
        int n2 = 0;
        boolean bl = false;
        ArrayList arrayList2 = new ArrayList();
        Map<String, Field> map = CsvSerialisation.getObjectMapper(clazz);
        try (PrintWriter printWriter = new PrintWriter(outputStream);
             CsvWriter csvWriter = new CsvWriter(printWriter);){
            csvWriter.put("I");
            for (String string2 : list) {
                csvWriter.put(string2);
            }
            for (String string2 : map.keySet()) {
                csvWriter.put(string2);
            }
            csvWriter.nl();
            for (String string2 : list2) {
                csvWriter.put("D");
                for (String string3 : list) {
                    csvWriter.put(string3);
                }
                for (String string3 : map.keySet()) {
                    Comparable<Date> comparable;
                    String string4;
                    Field field = map.get(string3);
                    field.setAccessible(true);
                    if (field.getType() == String.class) {
                        csvWriter.put(field.get(string2).toString());
                        continue;
                    }
                    if (field.getType() == Date.class) {
                        string4 = null;
                        if (field.get(string2) != null) {
                            comparable = (Date)field.get(string2);
                            string4 = Util.dateToStr((Date)comparable, "dd/MM/yyyy HH:mm:ss");
                        }
                        csvWriter.put(string4);
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        csvWriter.put(Integer.toString(field.getInt(string2)));
                        continue;
                    }
                    if (field.getType() == Integer.class) {
                        string4 = null;
                        if (field.get(string2) != null) {
                            comparable = Integer.valueOf(field.get(string2).toString());
                            string4 = Integer.toString((Integer)comparable);
                        }
                        csvWriter.put(string4);
                        continue;
                    }
                    if (field.getType() == Long.TYPE) {
                        csvWriter.put(Long.toString(field.getLong(string2)));
                        continue;
                    }
                    if (field.getType() == Long.class) {
                        string4 = null;
                        if (field.get(string2) != null) {
                            comparable = Long.valueOf(field.get(string2).toString());
                            string4 = Long.toString((Long)comparable);
                        }
                        csvWriter.put(string4);
                        continue;
                    }
                    if (field.getType() == Boolean.TYPE) {
                        csvWriter.put(Integer.toString(Util.booleanToInt(field.getBoolean(string2))));
                        continue;
                    }
                    if (field.getType() == Boolean.class) {
                        string4 = null;
                        if (field.get(string2) != null) {
                            string4 = Integer.toString(Util.booleanToInt(field.getBoolean(string2)));
                        }
                        csvWriter.put(string4);
                        continue;
                    }
                    if (field.getType().isEnum()) {
                        csvWriter.put(field.get(string2).toString());
                        continue;
                    }
                    csvWriter.put(field.get(string2).toString());
                }
                csvWriter.nl();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error writing file on line " + n2 + ": " + exception.getMessage(), exception);
        }
        return arrayList;
    }
}

