/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.DataVault;

import au.com.aemo.Common.DataVault.ApplicationDataVaultProviderInt;
import au.com.aemo.Common.DataVault.ApplicationDataVaultToken;
import au.com.aemo.Common.DataVault.AzureSecretResponse;
import au.com.aemo.Common.DataVault.AzureTokenResponse;
import au.com.aemo.Common.DataVault.DataVault;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebHelper;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.aemo.Common.Web.WebRequestConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDataVaultProviderAzureKeyVault
implements ApplicationDataVaultProviderInt {
    private static Logger logger = LoggerFactory.getLogger(ApplicationDataVaultProviderAzureKeyVault.class);
    private static final String ID = "AZURE_KEY_VAULT";
    private static final String AUTH_METHOD_VMMI = "VMMI";
    private static final String AUTH_METHOD_CMI = "CMI";
    private static final String CMI_ENV_MSI_ENDPOINT = "MSI_ENDPOINT";
    private static final String CMI_ENV_MSI_SECRET = "MSI_SECRET";
    private DataVault Config;
    private ApplicationDataVaultToken Token;
    private String msiEndpoint;
    private String msiSecret;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void initialise(DataVault dataVault) throws Exception {
        if (Util.isBlank(dataVault.Reference)) {
            Util_Logger.error(logger, "URL reference is not defined for Azure Key Vault [" + dataVault.Name + "]");
        }
        if (Util.isBlank(dataVault.AuthMethod)) {
            Util_Logger.error(logger, "Auth Method is not defined for Azure Key Vault [" + dataVault.Name + "]");
        }
        if (dataVault.AuthMethod.equalsIgnoreCase(AUTH_METHOD_CMI)) {
            this.msiEndpoint = System.getenv(CMI_ENV_MSI_ENDPOINT);
            this.msiSecret = System.getenv(CMI_ENV_MSI_SECRET);
            if (Util.isBlank(this.msiEndpoint)) {
                Util_Logger.error(logger, "Unable to extract envionment variable [MSI_ENDPOINT] for Azure Key Vault [" + dataVault.Name + "]");
            }
            if (Util.isBlank(this.msiSecret)) {
                Util_Logger.error(logger, "Unable to extract envionment variable [MSI_SECRET] for Azure Key Vault [" + dataVault.Name + "]");
            }
        }
        this.Config = dataVault;
        this.Token = this.getToken();
        if (this.Token == null) {
            throw new Exception("Failed to intialise Azure Key Vault [" + this.Config.Name + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationDataVaultToken getToken() {
        ApplicationDataVaultToken applicationDataVaultToken = null;
        if (this.Config.AuthMethod.equalsIgnoreCase(AUTH_METHOD_VMMI)) {
            HttpURLConnection httpURLConnection = null;
            try {
                URL uRL = new URL("http://169.254.169.254/metadata/identity/oauth2/token?api-version=2018-02-01&resource=https%3A%2F%2Fvault.azure.net");
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("Metadata", "true");
                    }
                });
                WebHttpResponse webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("HTTP Response code " + webHttpResponse.ReturnCode);
                }
                AzureTokenResponse azureTokenResponse = JsonUtilities.fromJson(webHttpResponse.Body, AzureTokenResponse.class);
                applicationDataVaultToken = new ApplicationDataVaultToken(azureTokenResponse.access_token, new Date(azureTokenResponse.expires_on * 1000L));
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error extracting managed identity token for Azure Key Vault: " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        } else if (this.Config.AuthMethod.equalsIgnoreCase(AUTH_METHOD_CMI)) {
            HttpURLConnection httpURLConnection = null;
            try {
                URL uRL = new URL(this.msiEndpoint + "?api-version=2019-08-01&resource=https%3A%2F%2Fvault.azure.net");
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("X-IDENTITY-HEADER", ApplicationDataVaultProviderAzureKeyVault.this.msiSecret);
                    }
                });
                WebHttpResponse webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("HTTP Response code " + webHttpResponse.ReturnCode);
                }
                AzureTokenResponse azureTokenResponse = JsonUtilities.fromJson(webHttpResponse.Body, AzureTokenResponse.class);
                applicationDataVaultToken = new ApplicationDataVaultToken(azureTokenResponse.access_token, new Date(azureTokenResponse.expires_on * 1000L));
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error extracting managed identity token for Azure Key Vault: " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        } else {
            Util_Logger.errorNoRaise(logger, "Detected unsupported Auth_Method [" + this.Config.AuthMethod + "] in Azure Key Vault [" + this.Config.Name + "] configuration");
        }
        return applicationDataVaultToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by JSON serialisation")
    public String getValue(String string) {
        String string2 = null;
        if (this.Token == null) {
            this.Token = this.getToken();
        } else if (this.Token.isExpired()) {
            this.Token = this.getToken();
        }
        if (this.Token == null) {
            Util_Logger.errorNoRaise(logger, "Unable to extract Azure Key Vault secret [" + string + "] as authorisation token is unavailable");
        } else {
            HttpURLConnection httpURLConnection = null;
            try {
                URL uRL = new URL(this.Config.Reference + "/secrets/" + string + "?api-version=2016-10-01");
                httpURLConnection = WebHelper.getHttpURLConnection(uRL, "GET", new WebRequestConfig(){

                    @Override
                    public void configure(HttpURLConnection httpURLConnection) {
                        httpURLConnection.setRequestProperty("Authorization", "Bearer " + ApplicationDataVaultProviderAzureKeyVault.this.Token.getToken());
                    }
                });
                WebHttpResponse webHttpResponse = WebHelper.readResponse(httpURLConnection);
                if (webHttpResponse.ReturnCode != 200) {
                    throw new Exception("HTTP Response code " + webHttpResponse.ReturnCode);
                }
                AzureSecretResponse azureSecretResponse = JsonUtilities.fromJson(webHttpResponse.Body, AzureSecretResponse.class);
                string2 = azureSecretResponse.value;
                Util_Logger.info(logger, "Successfully extracted secret [" + string + "] from Azure Key Vault [" + this.Config.Name + "], value last updated " + Util.dateToStr(new Date(azureSecretResponse.attributes.updated * 1000L), "dd/MM/yyyy HH:mm:ss"));
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Unable to extract Azure Key Vault secret [" + string + "]: " + exception.getMessage(), exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return string2;
    }
}

