/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Database;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Database.DatabaseConfig;
import au.com.aemo.Common.Database.DbConnectionPoolFactory;
import au.com.aemo.Common.Database.DbHandler;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.time.Duration;
import java.util.Date;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbConnectionPool {
    private static Logger logger = LoggerFactory.getLogger(DbConnectionPool.class);
    private volatile GenericObjectPool<Connection> itsPool;
    private Date itsPoolLastCleared;
    private int itsPoolTimeoutMins;
    private DatabaseConfig itsConfig;
    private DbConnectionPoolFactory itsFactory;
    private DbHandler itsDb;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Private constructor")
    public DbConnectionPool(DatabaseConfig databaseConfig, String string, String string2) throws ApplicationException {
        this.itsConfig = databaseConfig;
        try {
            Class<?> clazz = Class.forName(this.itsConfig.DbHandler);
            Constructor<?> constructor = clazz.getConstructor(DatabaseConfig.class, String.class, String.class);
            this.itsDb = (DbHandler)constructor.newInstance(this.itsConfig, string, string2);
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error setting up database connection pool manager " + exception.getMessage(), exception);
        }
        this.itsFactory = new DbConnectionPoolFactory(this.itsDb, string, string2){

            @Override
            public synchronized PooledObject<Connection> makeObject() throws Exception {
                PooledObject<Connection> pooledObject = super.makeObject();
                DbConnectionPool.this.logConnectionPoolState(1);
                return pooledObject;
            }

            @Override
            public void destroyObject(PooledObject<Connection> pooledObject) throws Exception {
                super.destroyObject(pooledObject);
                DbConnectionPool.this.logConnectionPoolState(0);
            }
        };
        this.createDatabaseConnectionPool();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Required functionality of the database connection pool")
    public DbHandler getDbHandler() {
        return this.itsDb;
    }

    private void createDatabaseConnectionPool() {
        if (this.itsPool != null) {
            try {
                this.itsPool.clear();
                this.itsPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setBlockWhenExhausted(true);
        genericObjectPoolConfig.setMinIdle(this.itsConfig.DbPoolMinConnections.intValue());
        genericObjectPoolConfig.setMaxTotal(this.itsConfig.DbPoolMaxConnections.intValue());
        genericObjectPoolConfig.setTestWhileIdle(true);
        genericObjectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofSeconds(this.itsConfig.DbPoolTimeBetweenEvictionRunsSecs.intValue()));
        genericObjectPoolConfig.setMinEvictableIdleTime(Duration.ofSeconds(this.itsConfig.DbPoolMinEvictableIdleTimeSecs.intValue()));
        genericObjectPoolConfig.setTestOnBorrow(true);
        genericObjectPoolConfig.setTestOnReturn(true);
        genericObjectPoolConfig.setLifo(true);
        genericObjectPoolConfig.setMaxWait(Duration.ofSeconds(this.itsConfig.DbPoolMaxWaitForConnectionSecs.intValue()));
        this.itsPool = new GenericObjectPool((PooledObjectFactory)this.itsFactory);
        this.itsPool.setConfig(genericObjectPoolConfig);
        this.itsPoolLastCleared = new Date();
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            connection = (Connection)this.itsPool.borrowObject();
            Util_Logger.debug(logger, "Borrowed Database connection [" + connection.toString() + "]");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to borrow Database connection from object pool: " + exception.getMessage(), exception);
        }
        return connection;
    }

    public void returnConnection(Connection connection) {
        if (connection != null) {
            try {
                Util_Logger.debug(logger, "Returned Database connection [" + connection.toString() + "]");
                this.itsPool.returnObject((Object)connection);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to return Database connection to object pool: " + exception.getMessage(), exception);
            }
        }
    }

    private void logConnectionPoolState(int n2) {
        if (this.itsPool != null) {
            Util_Logger.info(logger, "Database Connection pool now has a total of " + (this.itsPool.getNumActive() + n2) + " active connections, " + this.itsPool.getNumIdle() + " idle connections");
        }
    }

    public void closePool() {
        this.itsPool.close();
    }

    public synchronized void clearCache() {
        try {
            Date date = Util.dateOffset(new Date(), -this.itsPoolTimeoutMins, 12);
            if (this.itsPoolLastCleared.before(date)) {
                this.createDatabaseConnectionPool();
                Util_Logger.warning(logger, "Flushed Database connection pool");
            }
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error clearing object pool cache for DatabaseConnectionPool:" + exception.getMessage(), exception);
        }
    }
}

