/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.GoogleAuthResponse;
import au.com.aemo.Common.FileSystem.GoogleBlob;
import au.com.aemo.Common.FileSystem.GoogleDirectoryWrapper;
import au.com.aemo.Common.FileSystem.GoogleOauthToken;
import au.com.aemo.Common.FileSystem.GoogleRequestParameters;
import au.com.aemo.Common.FileSystem.GoogleServiceAccountKeyParameters;
import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionGoogle
extends fsConnectionBase {
    private static int OAUTH_TOKEN_MINIMUM_LIFE_MINS = 10;
    private static int OAUTH_TOKEN_RENEW_BEFORE_EXPIRY_MINS = 5;
    private static Logger logger = LoggerFactory.getLogger(fsConnectionGoogle.class);
    private String itsDataSourceId;
    private String itsServiceAccountKeyFile;
    private String itsServiceAccountKeyContents;
    private String itsBaseURL;
    private String itsCurrentDir;
    private boolean itsGetFileModifiedTime;
    private int itsOAuthTokenExpiryMins;
    private GoogleOauthToken itsOAuthToken;
    private int itsErrorsBeforeTokenRefresh;
    private WebClient itsWebClient;

    public fsConnectionGoogle(String string, String string2, String string3, String string4, Proxy proxy, int n2, int n3, boolean bl, int n4, int n5) {
        super(string);
        this.itsDataSourceId = string;
        this.itsServiceAccountKeyFile = string2;
        this.itsServiceAccountKeyContents = string3;
        this.itsBaseURL = string4;
        this.itsGetFileModifiedTime = bl;
        this.itsOAuthTokenExpiryMins = Math.min(n4, OAUTH_TOKEN_MINIMUM_LIFE_MINS);
        this.itsErrorsBeforeTokenRefresh = n5;
        this.itsWebClient = new WebClient().setTimeoutConnectionSecs(n2).setTimeoutTransferSecs(n3).setProxy(proxy);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return true;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            throw new Exception("Missing container specification (/) in filename [" + string + "]");
        }
        fsFileInfo2.setDirectory(string.substring(0, n2));
        fsFileInfo2.setFilename(string.substring(n2 + 1));
        return fsFileInfo2;
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Google connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = string;
    }

    private void validateOAuthToken() throws ApplicationException {
        block22: {
            String string = "https://www.googleapis.com/oauth2/v4/token";
            String string2 = "https://www.googleapis.com/auth/cloud-platform";
            HttpURLConnection httpURLConnection = null;
            try {
                String string3;
                boolean bl = false;
                bl = this.itsOAuthToken == null ? true : (this.itsOAuthToken.error_count > 0L ? true : Util.dateOffset(new Date(), OAUTH_TOKEN_RENEW_BEFORE_EXPIRY_MINS, 12).after(this.itsOAuthToken.expiryDate));
                if (!bl) break block22;
                this.itsOAuthToken = null;
                String string4 = this.itsServiceAccountKeyContents;
                if (Util.isBlank(string4)) {
                    if (Util.isBlank(this.itsServiceAccountKeyFile)) {
                        throw new Exception("Missing Google service account key file parameter for access to Google Storage");
                    }
                    if (!Files.exists(Paths.get(this.itsServiceAccountKeyFile, new String[0]), new LinkOption[0])) {
                        throw new Exception("Unable to find Google service account key file " + this.itsServiceAccountKeyFile);
                    }
                    string4 = new String(Files.readAllBytes(Paths.get(this.itsServiceAccountKeyFile, new String[0])));
                }
                if (Util.isBlank(string4)) {
                    throw new Exception("Unable to find Google service account key contents");
                }
                GoogleServiceAccountKeyParameters googleServiceAccountKeyParameters = JsonUtilities.fromJson(string4, GoogleServiceAccountKeyParameters.class);
                GoogleOauthToken googleOauthToken = new GoogleOauthToken();
                Date date = new Date();
                googleOauthToken.expiryDate = Util.dateOffset(date, this.itsOAuthTokenExpiryMins, 12);
                StringBuilder stringBuilder = new StringBuilder();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(googleServiceAccountKeyParameters.private_key));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.startsWith("-")) continue;
                    stringBuilder.append(string3);
                }
                byte[] byArray = Base64.getDecoder().decode(stringBuilder.toString());
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                JwtClaims jwtClaims = new JwtClaims();
                jwtClaims.setSubject(googleServiceAccountKeyParameters.client_email);
                jwtClaims.setIssuer(googleServiceAccountKeyParameters.client_email);
                jwtClaims.setIssuedAt(NumericDate.fromMilliseconds((long)date.getTime()));
                jwtClaims.setExpirationTime(NumericDate.fromMilliseconds((long)googleOauthToken.expiryDate.getTime()));
                jwtClaims.setClaim("scope", (Object)string2);
                jwtClaims.setAudience(string);
                JsonWebSignature jsonWebSignature = new JsonWebSignature();
                jsonWebSignature.setPayload(jwtClaims.toJson());
                jsonWebSignature.setKey((Key)privateKey);
                jsonWebSignature.setAlgorithmHeaderValue("RS256");
                jsonWebSignature.setHeader("typ", "JWT");
                jsonWebSignature.setHeader("kid", googleServiceAccountKeyParameters.private_key_id);
                jsonWebSignature.sign();
                String string5 = jsonWebSignature.getCompactSerialization();
                String string6 = "grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=" + string5;
                byte[] byArray2 = string6.getBytes();
                GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
                googleRequestParameters.method = "POST";
                googleRequestParameters.content_type = "application/x-www-form-urlencoded";
                googleRequestParameters.content_length = Integer.toString(byArray2.length);
                httpURLConnection = this.getHttpURLConnection(string, googleRequestParameters, false);
                httpURLConnection.getOutputStream().write(byArray2);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    if (httpURLConnection.getContentType().toLowerCase().startsWith("application/json")) {
                        try {
                            String string7 = null;
                            try (Object object = new InputStreamReader(httpURLConnection.getInputStream());
                                 BufferedReader bufferedReader2 = new BufferedReader((Reader)object);){
                                string7 = bufferedReader2.lines().collect(Collectors.joining("\n"));
                            }
                            object = JsonUtilities.fromJson(string7, GoogleAuthResponse.class);
                            googleOauthToken.access_token = ((GoogleAuthResponse)object).access_token;
                            googleOauthToken.token_type = ((GoogleAuthResponse)object).token_type;
                            this.itsOAuthToken = googleOauthToken;
                            break block22;
                        }
                        catch (Exception exception) {
                            throw new Exception("Error parsing Google oAuth token request response: " + exception.getMessage());
                        }
                    }
                    throw new Exception("Unexpected content type " + httpURLConnection.getContentType() + " from Google oAuth token request");
                }
                String string8 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google oAuth token request, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string8);
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                httpURLConnection = null;
                Util_Logger.error(logger, "Error generating oAuth token: " + exception.getMessage(), exception);
            }
        }
    }

    private HttpsURLConnection getHttpURLConnection(String string, GoogleRequestParameters googleRequestParameters, boolean bl) {
        HttpURLConnection httpURLConnection = null;
        try {
            if (bl) {
                this.validateOAuthToken();
            }
            if (bl && this.itsOAuthToken == null) {
                throw new Exception("Unable to generate request due to missing OAuth token");
            }
            URL uRL = new URL(string);
            httpURLConnection = (HttpsURLConnection)this.itsWebClient.getHttpURLConnection(googleRequestParameters.method, uRL, null);
            if (!Util.isBlank(googleRequestParameters.content_type)) {
                httpURLConnection.setRequestProperty("Content-Type", googleRequestParameters.content_type);
            }
            if (!Util.isBlank(googleRequestParameters.content_length)) {
                httpURLConnection.setRequestProperty("Content-Length", googleRequestParameters.content_length);
            }
            if (bl) {
                httpURLConnection.setRequestProperty("Authorization", this.itsOAuthToken.token_type + " " + this.itsOAuthToken.access_token);
            }
            for (Map.Entry<String, String> entry : googleRequestParameters.headers.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    private HttpsURLConnection getHttpURLConnection(String string, GoogleRequestParameters googleRequestParameters) {
        return this.getHttpURLConnection(string, googleRequestParameters, true);
    }

    private Date getFileModifiedDate(String string, String string2) throws Exception {
        throw new Exception("Google connection does not support a get modified date operation");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by JSON serialisation")
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
            googleRequestParameters.method = "GET";
            googleRequestParameters.parameters.put("projection", "noacl");
            googleRequestParameters.parameters.put("delimiter", "/");
            String string3 = this.getURL(string, null, googleRequestParameters);
            Util_Logger.debug(logger, "Polling directory: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, googleRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                Object object;
                if (!httpURLConnection.getContentType().toLowerCase().startsWith("application/json")) throw new Exception("Invalid response type " + httpURLConnection.getContentType() + " detected in listFiles");
                String string4 = null;
                try (Object object2 = new InputStreamReader(httpURLConnection.getInputStream());
                     Iterator<String> iterator = new BufferedReader((Reader)object2);){
                    string4 = ((BufferedReader)((Object)iterator)).lines().collect(Collectors.joining("\n"));
                }
                object2 = JsonUtilities.fromJson(string4, GoogleDirectoryWrapper.class);
                if (((GoogleDirectoryWrapper)object2).items != null) {
                    for (GoogleBlob googleBlob : ((GoogleDirectoryWrapper)object2).items) {
                        if (googleBlob.name.endsWith("/")) continue;
                        object = googleBlob.name;
                        if (googleBlob.name.lastIndexOf("/") > 0) {
                            object = googleBlob.name.substring(googleBlob.name.lastIndexOf("/") + 1);
                        }
                        fsFileInfo fsFileInfo2 = new fsFileInfo();
                        fsFileInfo2.setFilename((String)object);
                        fsFileInfo2.setDirectory(string);
                        fsFileInfo2.setModifiedDate(googleBlob.updated, true);
                        fsFileInfo2.setSize(googleBlob.size);
                        fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                        if (fsConnectionFileFilterInt2 == null) {
                            hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                            continue;
                        }
                        if (!fsConnectionFileFilterInt2.accept(fsFileInfo2)) continue;
                        hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                    }
                }
                if (((GoogleDirectoryWrapper)object2).prefixes != null) {
                    for (String string5 : ((GoogleDirectoryWrapper)object2).prefixes) {
                        void var11_23;
                        void var11_21;
                        object = new fsFileInfo();
                        if (string5.endsWith("/")) {
                            String string6 = string5.substring(0, string5.length() - 1);
                        }
                        if (var11_21.lastIndexOf("/") > 0) {
                            String string7 = var11_21.substring(var11_21.lastIndexOf("/") + 1);
                        }
                        ((fsFileInfo)object).setFilename((String)var11_23);
                        ((fsFileInfo)object).setDirectory(string);
                        ((fsFileInfo)object).setFileType(fsFileTypeEnum.DIRECTORY);
                        if (fsConnectionFileFilterInt2 == null) {
                            hashMap.put(((fsFileInfo)object).getFilename(), (fsFileInfo)object);
                            continue;
                        }
                        if (!fsConnectionFileFilterInt2.accept((fsFileInfo)object)) continue;
                        hashMap.put(((fsFileInfo)object).getFilename(), (fsFileInfo)object);
                    }
                }
            } else {
                String string8 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google List Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string8);
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
            return hashMap;
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.itsOAuthToken != null) {
                ++this.itsOAuthToken.error_count;
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from web: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    private String getObjectName(String string, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = Util.getColumns(string, '/');
        StringBuilder stringBuilder2 = new StringBuilder();
        if (stringArray.length > 1) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                if (i2 > 1) {
                    stringBuilder2.append("/");
                }
                stringBuilder2.append(stringArray[i2]);
            }
            stringBuilder2.append("/");
        }
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String getURL(String string, String string2, GoogleRequestParameters googleRequestParameters) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(this.itsBaseURL);
        if (!this.itsBaseURL.endsWith("/")) {
            stringBuilder.append("/");
        }
        if (googleRequestParameters.method.equalsIgnoreCase("POST")) {
            stringBuilder.append("upload/");
        }
        stringBuilder.append("storage/v1/b/");
        String[] stringArray = Util.getColumns(string, '/');
        stringBuilder.append(stringArray[0]);
        stringBuilder.append("/o");
        String string3 = "?";
        if (!Util.isBlank(string2)) {
            stringBuilder.append("/");
            stringBuilder.append(URLEncoder.encode(this.getObjectName(string, string2), "UTF-8"));
        } else if (stringArray.length > 1) {
            stringBuilder.append(string3);
            stringBuilder.append("prefix");
            stringBuilder.append("=");
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                stringBuilder.append(stringArray[i2]);
                stringBuilder.append("/");
            }
            string3 = "&";
        }
        if (googleRequestParameters.parameters != null) {
            for (Map.Entry<String, String> entry : googleRequestParameters.parameters.entrySet()) {
                stringBuilder.append(string3);
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                string3 = "&";
            }
        }
        Util_Logger.debug(logger, "Constructed Google URL: " + stringBuilder.toString());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsFileInfo fsFileInfo3 = null;
        HttpURLConnection httpURLConnection = null;
        File file = null;
        try {
            GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
            googleRequestParameters.method = "GET";
            googleRequestParameters.parameters.put("alt", "media");
            String string2 = this.getURL(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename(), googleRequestParameters);
            Util_Logger.debug(logger, "Downloading blob: " + string2);
            httpURLConnection = this.getHttpURLConnection(string2, googleRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 200) {
                String string3 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google Get Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string3);
            }
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                file = new File(string + "/" + fsFileInfo2.getFilename());
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (fsFileInfo2.getModifiedDate() != null && !file.setLastModified(fsFileInfo2.getModifiedDate().getTime())) {
                    Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
                }
            }
            fsFileInfo3 = new fsFileInfo(fsFileInfo2);
            fsFileInfo3.setDirectory(string);
            return fsFileInfo3;
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (this.itsOAuthToken != null) {
                ++this.itsOAuthToken.error_count;
            }
            Util_Logger.error(logger, "Error transferring file " + fsFileInfo2.getFilename() + " from Google blob: " + exception.getMessage(), exception);
        }
        return fsFileInfo3;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            if (byArray == null) {
                Util_Logger.info(logger, "No data to write for " + string2 + ", skipping writeData operation");
                return;
            }
            String string3 = Util.getColumns(string, '/')[0];
            GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
            googleRequestParameters.method = "POST";
            googleRequestParameters.content_length = Integer.toString(byArray.length);
            googleRequestParameters.parameters.put("name", this.getObjectName(string, string2));
            googleRequestParameters.parameters.put("uploadType", "media");
            String string4 = this.getURL(string3, null, googleRequestParameters);
            Util_Logger.debug(logger, "Putting blob: " + string4);
            httpURLConnection = this.getHttpURLConnection(string4, googleRequestParameters);
            httpURLConnection.getOutputStream().write(byArray);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 200) {
                String string5 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google Write Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string5);
            }
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                this.itsOAuthToken = null;
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.itsOAuthToken != null) {
                ++this.itsOAuthToken.error_count;
            }
            Util_Logger.error(logger, "Error writing file " + string2 + " to Google blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        try {
            GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
            googleRequestParameters.method = "DELETE";
            String string3 = this.getURL(string, string2, googleRequestParameters);
            Util_Logger.debug(logger, "Deleting blob: " + string3);
            httpURLConnection = this.getHttpURLConnection(string3, googleRequestParameters);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 204 && httpURLConnection.getResponseCode() != 404) {
                String string4 = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream())).lines().collect(Collectors.joining("\n"));
                throw new Exception("Detected error in Google Delete Blob operation, return code = " + httpURLConnection.getResponseCode() + ", Message=" + string4);
            }
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (this.itsOAuthToken != null) {
                ++this.itsOAuthToken.error_count;
            }
            Util_Logger.error(logger, "Error deleting file " + string2 + " from Google blob: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) throws Exception {
        boolean bl;
        block12: {
            bl = false;
            HttpURLConnection httpURLConnection = null;
            try {
                if (Util.isBlank(string2)) {
                    if (!string.contains("/")) {
                        throw new IllegalArgumentException("Invalid GCP directory specification [" + string + "], expected {bucket}/{folder}");
                    }
                    String string3 = string.substring(0, string.lastIndexOf("/"));
                    String string4 = string.substring(string.lastIndexOf("/") + 1);
                    Map<String, fsFileInfo> map = this.listFiles(string3, null, null);
                    for (fsFileInfo fsFileInfo2 : map.values()) {
                        if (!fsFileInfo2.getName().equalsIgnoreCase(string4) || !fsFileInfo2.isDirectory()) continue;
                        bl = true;
                        break block12;
                    }
                    break block12;
                }
                GoogleRequestParameters googleRequestParameters = new GoogleRequestParameters();
                googleRequestParameters.method = "GET";
                googleRequestParameters.parameters.put("alt", "json");
                String string5 = this.getURL(string, string2, googleRequestParameters);
                Util_Logger.debug(logger, "Inspecting blob: " + string5);
                httpURLConnection = this.getHttpURLConnection(string5, googleRequestParameters);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    bl = true;
                } else if (httpURLConnection.getResponseCode() != 404) {
                    throw new Exception("Detected error in Google exists Blob operation, return code = " + httpURLConnection.getResponseCode());
                }
            }
            catch (Exception exception) {
                try {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (this.itsOAuthToken != null) {
                    ++this.itsOAuthToken.error_count;
                }
                Util_Logger.error(logger, "Error checking existance of file " + string2 + " from Google blob: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Google connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

