/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsConnectionLocalFilter;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockLocal;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.FileSystem.fsProcessStatus;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionLocal
implements fsConnectionInt {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionLocal.class);
    private String itsDataSourceId;
    private boolean itsEnableLocking;
    private String itsTempFileExtension;
    private String itsCurrentDir;
    private String itsPathSeparator;

    public fsConnectionLocal(String string, boolean bl, String string2) {
        this.itsDataSourceId = string;
        this.itsEnableLocking = bl;
        this.itsTempFileExtension = string2;
        this.itsPathSeparator = Character.toString(File.separatorChar);
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return true;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        File file = new File(string);
        fsFileInfo2.setDirectory(file.getParent());
        fsFileInfo2.setFilename(file.getName());
        return fsFileInfo2;
    }

    protected String fixDir(String string) {
        return Util.replaceAll(Util.isBlank(string, "."), "/", this.itsPathSeparator);
    }

    @Override
    public void makeDir(String string) throws Exception {
        File file = new File(this.fixDir(string));
        if (!file.exists()) {
            Util_Logger.info(logger, "Creating local directory: " + file.getPath());
            if (!file.mkdirs()) {
                throw new Exception("Error creating new directory " + file.getPath());
            }
        }
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.fixDir(string);
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("Error changing to non-existant local directory " + string);
        }
        if (!file.isDirectory()) {
            throw new Exception("Error changing to local directory " + string + ", this is not a directory");
        }
    }

    @Override
    @SuppressFBWarnings(value={"DM_STRING_CTOR"}, justification="Avoid holding object references")
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        fsConnectionLocalFilter fsConnectionLocalFilter2;
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        String string3 = this.fixDir(string);
        File file = new File(string3);
        File[] fileArray = file.listFiles(fsConnectionLocalFilter2 = new fsConnectionLocalFilter(fsConnectionFileFilterInt2));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                fsFileInfo fsFileInfo2 = new fsFileInfo();
                fsFileInfo2.setDirectory(new String(string3));
                fsFileInfo2.setFilename(new String(file2.getName()));
                fsFileInfo2.setSize(file2.length());
                fsFileInfo2.setModifiedDate(new Date(file2.lastModified()), true);
                if (file2.isDirectory()) {
                    fsFileInfo2.setFileType(fsFileTypeEnum.DIRECTORY);
                } else {
                    fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                }
                hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
            }
            fileArray = null;
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        File file = new File(this.fixDir(fsFileInfo2.getDirectory()) + this.itsPathSeparator + fsFileInfo2.getFilename());
        File file2 = new File(this.fixDir(string) + this.itsPathSeparator + fsFileInfo2.getFilename());
        try {
            if (fsFileInfo2.processWithLock()) {
                if (!fsFileInfo2.hasValidLock()) throw new Exception("Error copying " + file.getPath() + " to " + file2.getPath() + " as file lock is not valid");
                byte[] byArray = fsFileInfo2.getLockData().readLockedFileContents();
                this.writeData(string, fsFileInfo2.getFilename(), byArray, fsFileInfo2.getModifiedDate(), null);
            } else {
                FileUtilities.copy(file, file2);
            }
        }
        catch (Exception exception) {
            throw new Exception("Error copying " + file.getPath() + " to " + file2.getPath() + ": " + exception.getMessage());
        }
        if (fsFileInfo2.getModifiedDate() == null || file2.setLastModified(fsFileInfo2.getModifiedDate().getTime())) return;
        Util_Logger.warning(logger, "Unable to set modified time on file [" + file2.getName() + "]");
    }

    private void moveFile(String string, String string2, String string3, Date date) throws Exception {
        File file = new File(this.fixDir(string) + this.itsPathSeparator + string3);
        File file2 = new File(this.fixDir(string2) + this.itsPathSeparator + string3);
        try {
            FileUtilities.renameFile(file, file2);
        }
        catch (Exception exception) {
            throw new Exception("Error moving " + file.getPath() + " to " + file2.getPath() + ": " + exception.getMessage());
        }
        if (date != null && !file2.setLastModified(date.getTime())) {
            Util_Logger.warning(logger, "Unable to set modified time on file [" + file2.getName() + "]");
        }
    }

    @Override
    public byte[] readData(fsFileInfo fsFileInfo2) throws Exception {
        byte[] byArray = null;
        try {
            fsFileLockInt fsFileLockInt2 = fsFileInfo2.getLockData();
            boolean bl = true;
            if (fsFileLockInt2 != null && fsFileLockInt2.implementsLock()) {
                if (fsFileLockInt2.isValid()) {
                    bl = false;
                } else {
                    throw new Exception("Invalid lock");
                }
            }
            if (bl) {
                Path path = Paths.get(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
                byArray = Files.readAllBytes(path);
            } else {
                byArray = fsFileLockInt2.readLockedFileContents();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error reading file " + fsFileInfo2.getFilename() + ": " + exception.getMessage(), exception);
        }
        return byArray;
    }

    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        this.copyFile(fsFileInfo2, string);
        fsFileInfo fsFileInfo3 = new fsFileInfo(fsFileInfo2);
        fsFileInfo3.setDirectory(string);
        return fsFileInfo3;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        try {
            byte[] byArray2;
            fsFileLockInt fsFileLockInt3 = null;
            boolean bl = true;
            if (fsFileLockInt2 != null && fsFileLockInt2.implementsLock()) {
                if (fsFileLockInt2.isValid()) {
                    bl = false;
                    fsFileLockInt3 = fsFileLockInt2;
                } else {
                    throw new Exception("Invalid lock");
                }
            }
            if ((byArray2 = byArray) == null) {
                byArray2 = new byte[]{};
            }
            File file = new File(string, string2);
            if (bl && !((fsFileLockLocal)(fsFileLockInt3 = new fsFileLockLocal())).lockFile(file)) {
                throw new Exception("Unable to get filesystem lock");
            }
            fsFileLockInt3.updateLockedFileContents(byArray2);
            if (date != null && !file.setLastModified(date.getTime())) {
                Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
            }
            if (bl) {
                fsFileLockInt3.release();
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Error writing file " + string2 + ": " + exception.getMessage(), exception);
        }
    }

    @Override
    public fsProcessStatus putFile(fsFileInfo fsFileInfo2, String string, boolean bl, String string2) throws Exception {
        fsProcessStatus fsProcessStatus2 = new fsProcessStatus();
        if (bl) {
            this.moveFile(fsFileInfo2.getDirectory(), string, fsFileInfo2.getFilename(), fsFileInfo2.getModifiedDate());
        } else {
            this.copyFile(fsFileInfo2, string);
        }
        fsProcessStatus2.setProcessSuccess();
        return fsProcessStatus2;
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        String string3 = this.fixDir(string) + this.itsPathSeparator + string2;
        try {
            FileUtilities.deleteFile(string3);
        }
        catch (Exception exception) {
            throw new Exception("Error deleting local file " + string3 + ": " + exception.getMessage());
        }
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        String string3 = this.fixDir(string) + (String)(Util.isBlank(string2) ? "" : this.itsPathSeparator + string2);
        return new File(string3).exists();
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        File file = new File(this.fixDir(string) + this.itsPathSeparator + string2);
        File file2 = new File(this.fixDir(string3) + this.itsPathSeparator + string4);
        try {
            FileUtilities.renameFile(file, file2);
        }
        catch (Exception exception) {
            throw new Exception("Error renaming " + file.getPath() + " to " + file2.getPath() + ": " + exception.getMessage());
        }
    }

    @Override
    public boolean logOperations() {
        return false;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        fsFileLockInt fsFileLockInt2 = null;
        fsFileLockInt2 = this.itsEnableLocking ? new fsFileLockLocal() : new fsFileLockNone();
        fsFileLockInt2.lockFile(fsFileInfo2);
        return fsFileLockInt2;
    }

    @Override
    public void releaseFileLock(fsFileInfo fsFileInfo2) {
        fsFileInfo2.releaseLock();
    }

    @Override
    public void deleteFile(fsFileInfo fsFileInfo2) throws Exception {
        if (fsFileInfo2.processWithLock() && fsFileInfo2.hasValidLock()) {
            fsFileInfo2.releaseLock();
        }
        this.deleteFile(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }
}

