/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsConnectionBase;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileLockInt;
import au.com.aemo.Common.FileSystem.fsFileLockNone;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsConnectionWeb
extends fsConnectionBase {
    private static Logger logger = LoggerFactory.getLogger(fsConnectionWeb.class);
    private String itsDataSourceId;
    private String itsBaseURL;
    private Proxy itsProxy;
    private String itsCurrentDir;
    private int itsTransferBufferSize;
    private int itsTimeoutConnectionSecs;
    private int itsTimeoutTransferSecs;
    private boolean itsGetFileModifiedTime;
    private double itsGetFileModifiedTimePauseSecs;
    private Pattern REGEX_ANCHOR = Pattern.compile("(<A.*?>.*?<\\/A>)", 2);
    private Pattern REGEX_ANCHOR_HREF = Pattern.compile("<A\\s+HREF\\s*=\\s*\"(.*?)\"\\s*>(.*?\\..*?)<\\/A>", 2);

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Class is consumed by trusted code")
    public fsConnectionWeb(String string, String string2, Proxy proxy, int n2, int n3, boolean bl, int n4, double d2) {
        super(string);
        this.itsDataSourceId = string;
        this.itsBaseURL = string2;
        this.itsProxy = proxy;
        this.itsTransferBufferSize = n4;
        this.itsTimeoutConnectionSecs = n2;
        this.itsTimeoutTransferSecs = n3;
        this.itsGetFileModifiedTime = bl;
        this.itsGetFileModifiedTimePauseSecs = d2;
    }

    @Override
    public String getDataSourceId() {
        return this.itsDataSourceId;
    }

    @Override
    public boolean supportsFileTimestamps() {
        return this.itsGetFileModifiedTime;
    }

    @Override
    public boolean supportsFileMasks() {
        return true;
    }

    @Override
    public fsFileInfo resolveFilenameSpec(String string) throws Exception {
        throw new Exception("Web connection does not support a resolveFilenameSpec operation");
    }

    @Override
    public void makeDir(String string) throws Exception {
        throw new Exception("Web connection does not support a directory create operation");
    }

    @Override
    public void changeDir(String string) throws Exception {
        this.itsCurrentDir = this.itsBaseURL + "/" + string;
    }

    private HttpURLConnection getHttpURLConnection(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = this.itsProxy == null ? (HttpURLConnection)uRL.openConnection(Proxy.NO_PROXY) : (HttpURLConnection)uRL.openConnection(this.itsProxy);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setConnectTimeout(this.itsTimeoutConnectionSecs * 1000);
            httpURLConnection.setReadTimeout(this.itsTimeoutTransferSecs * 1000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.connect();
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            httpURLConnection = null;
            Util_Logger.errorNoRaise(logger, "Error connecting to HTTP URL " + string + ": " + exception.getMessage());
        }
        return httpURLConnection;
    }

    private void processHttpLine(String string, String string2, Map<String, fsFileInfo> map) {
        Matcher matcher = this.REGEX_ANCHOR.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            Matcher matcher2 = this.REGEX_ANCHOR_HREF.matcher(string3);
            while (matcher2.find()) {
                String string4 = matcher2.group(1);
                String string5 = matcher2.group(2);
                fsFileInfo fsFileInfo2 = new fsFileInfo();
                fsFileInfo2.setDirectory(string2);
                fsFileInfo2.setFilename(string5);
                fsFileInfo2.setSize(null);
                if (this.itsGetFileModifiedTime) {
                    fsFileInfo2.setModifiedDate(this.getFileModifiedDate(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename()), true);
                    if (this.itsGetFileModifiedTimePauseSecs > 0.0) {
                        try {
                            Thread.sleep((int)(this.itsGetFileModifiedTimePauseSecs * 1000.0));
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    fsFileInfo2.setModifiedDate(null, false);
                }
                fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                map.put(fsFileInfo2.getFilename(), fsFileInfo2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getFileModifiedDate(String string, String string2) {
        Date date = null;
        HttpURLConnection httpURLConnection = null;
        String string3 = this.itsBaseURL + "/" + string + "/" + string2;
        try {
            httpURLConnection = this.getHttpURLConnection(string3);
            if (httpURLConnection.getResponseCode() == 200) {
                date = new Date(httpURLConnection.getLastModified());
            } else {
                Util_Logger.info(logger, "Unable to get modified time for web resource [" + string3 + "], response code [" + httpURLConnection.getResponseCode() + "]: " + httpURLConnection.getResponseMessage());
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            Util_Logger.info(logger, "Unable to get modified time for web resource [" + string3 + "] : " + exception.getMessage());
            date = null;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return date;
    }

    @Override
    public Map<String, fsFileInfo> listFiles(String string, fsConnectionFileFilterInt fsConnectionFileFilterInt2, String string2) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        HttpURLConnection httpURLConnection = null;
        try {
            String string3 = this.getURL(string, null);
            Util_Logger.debug(logger, "Polling directory: " + string3);
            httpURLConnection = this.getHttpURLConnection(this.getURL(string, null));
            if (httpURLConnection.getResponseCode() == 200) {
                if (!Util.isBlank(httpURLConnection.getContentType())) {
                    Util_Logger.debug(logger, "Detected content type: " + httpURLConnection.getContentType());
                    if (httpURLConnection.getContentType().toLowerCase().startsWith("text/html")) {
                        String string4;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                        while ((string4 = bufferedReader.readLine()) != null) {
                            string4 = string4.toUpperCase();
                            this.processHttpLine(string4, string, hashMap);
                        }
                        bufferedReader.close();
                    } else {
                        fsFileInfo fsFileInfo2 = new fsFileInfo();
                        fsFileInfo2.setDirectory(string.substring(0, string.lastIndexOf("/")));
                        fsFileInfo2.setFilename(string.substring(string.lastIndexOf("/") + 1));
                        fsFileInfo2.setSize(Long.valueOf(httpURLConnection.getContentLength()));
                        fsFileInfo2.setModifiedDate(new Date(httpURLConnection.getLastModified()), true);
                        fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
                        hashMap.put(fsFileInfo2.getFilename(), fsFileInfo2);
                    }
                }
            } else {
                throw new Exception("Rejected Web request, response code = " + httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
            }
            Util_Logger.debug(logger, "Detected " + hashMap.size() + " files");
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error listing directory " + string + " from web: " + exception.getMessage(), exception);
        }
        return hashMap;
    }

    private String getURL(String string, String string2) {
        Object object = null;
        object = string.toUpperCase().startsWith("HTTP://") ? string : (string.toUpperCase().startsWith("HTTPS://") ? string : this.itsBaseURL + "/" + string);
        if (!Util.isBlank(string2) && !string.endsWith(string2)) {
            object = (String)object + "/" + string2;
        }
        return object;
    }

    @Override
    public fsFileInfo getFile(fsFileInfo fsFileInfo2, String string) throws Exception {
        fsFileInfo fsFileInfo3 = null;
        File file = null;
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.getHttpURLConnection(this.getURL(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename()));
            if (httpURLConnection.getResponseCode() == 200) {
                long l2;
                file = new File(string + "/" + fsFileInfo2.getFilename());
                boolean bl = false;
                int n2 = 0;
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    int n3 = 0;
                    try (InputStream inputStream = httpURLConnection.getInputStream();){
                        byte[] byArray = new byte[this.itsTransferBufferSize];
                        long l3 = new Date().getTime();
                        while ((n3 = inputStream.read(byArray)) != -1) {
                            ((OutputStream)bufferedOutputStream).write(byArray, 0, n3);
                            n2 += n3;
                            long l4 = new Date().getTime();
                            if ((l4 - l3) / 1000L <= 20L) continue;
                            Util_Logger.info(logger, "Downloading " + fsFileInfo2.getFilename() + ", completed " + Util.readableFileSize(n2));
                            l3 = l4;
                            bl = true;
                        }
                    }
                    ((OutputStream)bufferedOutputStream).flush();
                }
                if (bl) {
                    Util_Logger.info(logger, "Completed download of " + fsFileInfo2.getFilename() + ", size is " + Util.readableFileSize(n2));
                }
                if (!this.itsGetFileModifiedTime && (l2 = httpURLConnection.getLastModified()) > 0L) {
                    if (!file.setLastModified(l2)) {
                        Util_Logger.warning(logger, "Unable to set modified time on file [" + file.getName() + "]");
                    }
                    fsFileInfo2.setModifiedDate(new Date(l2), true);
                }
            } else {
                throw new Exception("Rejected Web request, response code = " + httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
            }
            httpURLConnection.disconnect();
            fsFileInfo3 = new fsFileInfo(fsFileInfo2);
            fsFileInfo3.setDirectory(string);
        }
        catch (Exception exception) {
            try {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                FileUtilities.deleteFile(file);
            }
            catch (Exception exception3) {
                // empty catch block
            }
            Util_Logger.error(logger, "Error transferring file " + fsFileInfo2.getFilename() + " from web: " + exception.getMessage(), exception);
        }
        return fsFileInfo3;
    }

    @Override
    public void writeData(String string, String string2, byte[] byArray, Date date, fsFileLockInt fsFileLockInt2) throws Exception {
        throw new Exception("Web connection does not support a data write operation");
    }

    @Override
    public void deleteFile(String string, String string2) throws Exception {
        throw new Exception("Web connection does not support a file delete operation");
    }

    @Override
    public void setBandwidthThrottle(int n2) {
    }

    @Override
    public void setTransferBufferSize(int n2) {
        this.itsTransferBufferSize = n2;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean exists(String string, String string2) {
        return true;
    }

    @Override
    public boolean exists(fsFileInfo fsFileInfo2) throws Exception {
        return this.exists(fsFileInfo2.getDirectory(), fsFileInfo2.getFilename());
    }

    @Override
    public void renameFile(String string, String string2, String string3, String string4) throws Exception {
        throw new Exception("Web connection does not support a file rename operation");
    }

    @Override
    public boolean logOperations() {
        return true;
    }

    @Override
    public fsFileLockInt lockFile(fsFileInfo fsFileInfo2) {
        return new fsFileLockNone();
    }
}

