/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.fsFileComparatorInt;
import au.com.aemo.Common.FileSystem.fsFileComparatorModifiedDate;
import au.com.aemo.Common.FileSystem.fsFileComparatorName;
import au.com.aemo.Common.FileSystem.fsFileComparatorNameFilter;
import au.com.aemo.Common.FileSystem.fsFileComparatorPriority;
import au.com.aemo.Common.FileSystem.fsFileComparatorSize;
import au.com.aemo.Common.FileSystem.fsFileComparatorWrapper;
import au.com.aemo.Common.Java.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;

public class fsFileComparatorManager {
    public static final String COMPARE_NAME = "NAME";
    public static final String COMPARE_MODIFIED_DATE = "MODIFIED_DATE";
    public static final String COMPARE_PRIORITY = "PRIORITY";
    public static final String COMPARE_SIZE = "SIZE";
    public static final String COMPARE_NAME_FILTER = "NAME_FILTER";
    public static final String COMPARE_NEWEST = "NEWEST";
    public static final String COMPARE_OLDEST = "OLDEST";
    public static final String COMPARE_NAME_REVERSE = "NAME_REVERSE";
    public static final String PARAM_ASCENDING = "ASCENDING";
    public static final String PARAM_DESCENDING = "DESCENDING";
    private Map<String, fsFileComparatorInt> itsComparators = new HashMap<String, fsFileComparatorInt>();

    private fsFileComparatorManager() {
        this.registerComparator(new fsFileComparatorName());
        this.registerComparator(new fsFileComparatorModifiedDate());
        this.registerComparator(new fsFileComparatorPriority());
        this.registerComparator(new fsFileComparatorSize());
        this.registerComparator(new fsFileComparatorNameFilter());
    }

    public static fsFileComparatorManager getInstance() {
        return SingletonHolder.instance;
    }

    public void registerComparator(fsFileComparatorInt fsFileComparatorInt2) {
        this.itsComparators.put(fsFileComparatorInt2.getId().toUpperCase(), fsFileComparatorInt2);
    }

    private fsFileComparatorInt resolveComparator(String string) throws ConfigurationException {
        String string2 = string.toUpperCase();
        String string3 = null;
        int n2 = string.indexOf(":");
        if (n2 > 0) {
            string2 = string.substring(0, n2).toUpperCase();
            string3 = string.substring(n2 + 1).toUpperCase();
        }
        if (string2.equalsIgnoreCase(COMPARE_NAME_REVERSE)) {
            string2 = COMPARE_NAME;
            string3 = PARAM_DESCENDING;
        } else if (string2.equalsIgnoreCase(COMPARE_NEWEST)) {
            string2 = COMPARE_MODIFIED_DATE;
            string3 = PARAM_DESCENDING;
        } else if (string2.equalsIgnoreCase(COMPARE_OLDEST)) {
            string2 = COMPARE_MODIFIED_DATE;
            string3 = PARAM_ASCENDING;
        }
        fsFileComparatorInt fsFileComparatorInt2 = this.itsComparators.get(string2);
        if (fsFileComparatorInt2 != null) {
            try {
                fsFileComparatorInt2 = (fsFileComparatorInt)fsFileComparatorInt2.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new ConfigurationException("Internal error creating sort comparator [" + string2 + "] : " + exception.getMessage());
            }
        } else {
            throw new ConfigurationException("Unsupported file sort comparator [" + string2 + "]");
        }
        fsFileComparatorInt2.setParameters(string3);
        return fsFileComparatorInt2;
    }

    public fsFileComparatorInt getComparator(String string) throws ConfigurationException {
        fsFileComparatorWrapper fsFileComparatorWrapper2 = new fsFileComparatorWrapper();
        if (!Util.isBlank(string)) {
            List<String> list = Util.getList(string, '|');
            for (String string2 : list) {
                fsFileComparatorInt fsFileComparatorInt2 = this.resolveComparator(string2);
                fsFileComparatorWrapper2.addComparator(fsFileComparatorInt2);
            }
        } else {
            fsFileComparatorWrapper2.addComparator(new fsFileComparatorName());
        }
        return fsFileComparatorWrapper2;
    }

    private static class SingletonHolder {
        private static fsFileComparatorManager instance = new fsFileComparatorManager();

        private SingletonHolder() {
        }
    }
}

