/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionGraphQL;
import au.com.aemo.Common.FileSystem.fsEventData;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsFileTypeEnum;
import au.com.aemo.Common.FileSystem.fsGraphQLConfig;
import au.com.aemo.Common.FileSystem.fsGraphQLMetaData;
import au.com.aemo.Common.FileSystem.fsGraphQLPayload;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.JSON.JsonUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebHttpResponse;
import au.com.aemo.Common.XML.XmlUtilities;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class fsGraphQLDataManager {
    private static Logger logger = LoggerFactory.getLogger(fsGraphQLDataManager.class);
    public static final String TYPE_SCALAR = "SCALAR";
    public static final String TYPE_OBJECT = "OBJECT";
    public static final String TYPE_LIST = "LIST";
    private Map<String, fsGraphQLMetaData> DataDefinitions = new HashMap<String, fsGraphQLMetaData>();
    private Map<String, fsGraphQLConfig> QueryConfig = new HashMap<String, fsGraphQLConfig>();
    private Map<String, List<fsFileInfo>> ReportingEvents = new HashMap<String, List<fsFileInfo>>();

    private fsGraphQLDataManager() {
    }

    public static fsGraphQLDataManager getInstance() {
        return SingletonHolder.instance;
    }

    private fsGraphQLMetaData.fsGraphQLObjectDefinitions fetchObjectMetaData(fsConnectionGraphQL fsConnectionGraphQL2, fsGraphQLMetaData.fsGraphQLObjectType fsGraphQLObjectType2) {
        fsGraphQLMetaData.fsGraphQLObjectDefinitions fsGraphQLObjectDefinitions2;
        block5: {
            fsGraphQLObjectDefinitions2 = null;
            try {
                Util_Logger.debug(logger, "Querying schema definition for object type [" + fsGraphQLObjectType2.name + "]");
                fsGraphQLPayload fsGraphQLPayload2 = new fsGraphQLPayload();
                fsGraphQLPayload2.query = "{\n  __type(name: \"" + fsGraphQLObjectType2.name + "\") {\n    fields {\n      name\n      description\n      type {\n        kind\n        name\n        description\n      }\n    }\n  }\n}";
                String string = JsonUtilities.toJson(fsGraphQLPayload2);
                Util_Logger.debug(logger, "GraphQL Schema query request: " + string);
                WebHttpResponse webHttpResponse = fsConnectionGraphQL2.readData(string);
                if (webHttpResponse.ReturnCode == 200) {
                    Util_Logger.debug(logger, "GraphQL schema query response: " + webHttpResponse.Body);
                    String string2 = webHttpResponse.Body;
                    string2 = JsonUtilities.getJsonObject(string2, "data");
                    string2 = JsonUtilities.getJsonObject(string2, "__type");
                    fsGraphQLObjectDefinitions2 = JsonUtilities.fromJson(string2, fsGraphQLMetaData.fsGraphQLObjectDefinitions.class);
                    if (fsGraphQLObjectDefinitions2 != null) {
                        if (fsGraphQLObjectDefinitions2.fields == null) {
                            throw new Exception("Unable to deserialize schema definition fields");
                        }
                        break block5;
                    }
                    throw new Exception("Unable to deserialize schema definition");
                }
                throw new Exception("Error extracting meta data, return code = " + webHttpResponse.ReturnCode + ": " + webHttpResponse.Body);
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "error fetching GraphQL schema definition for object [" + fsGraphQLObjectType2.name + "]: " + exception.getMessage(), exception);
            }
        }
        return fsGraphQLObjectDefinitions2;
    }

    private void processSchemaObjectDefinition(fsConnectionGraphQL fsConnectionGraphQL2, fsGraphQLMetaData fsGraphQLMetaData2, fsGraphQLMetaData.fsGraphQLObjectDefinition fsGraphQLObjectDefinition2, boolean bl) {
        fsGraphQLMetaData.fsGraphQLObjectDefinitions fsGraphQLObjectDefinitions2;
        if (fsGraphQLObjectDefinition2.type != null && fsGraphQLObjectDefinition2.type.kind != null && fsGraphQLObjectDefinition2.type.kind.equalsIgnoreCase(TYPE_OBJECT) && fsGraphQLMetaData2.DataDefinitions.get(fsGraphQLObjectDefinition2.name) == null && (fsGraphQLObjectDefinitions2 = this.fetchObjectMetaData(fsConnectionGraphQL2, fsGraphQLObjectDefinition2.type)) != null) {
            fsGraphQLObjectDefinitions2.isObject = bl;
            fsGraphQLMetaData2.DataDefinitions.put(fsGraphQLObjectDefinition2.name, fsGraphQLObjectDefinitions2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized fsGraphQLConfig getGraphQLConfig(String string) {
        fsGraphQLConfig fsGraphQLConfig2 = this.QueryConfig.get(string);
        if (fsGraphQLConfig2 == null) {
            Map<String, fsGraphQLConfig> map = this.QueryConfig;
            synchronized (map) {
                FilesystemManager filesystemManager = FilesystemManager.getInstance();
                String string2 = filesystemManager.getConfig(string + "_graphql_config", "");
                XStream xStream = XmlUtilities.getConverter();
                xStream.processAnnotations(fsGraphQLConfig.class);
                xStream.processAnnotations(fsGraphQLConfig.fsGraphQLEvent.class);
                xStream.processAnnotations(fsGraphQLConfig.fsGraphQLReport.class);
                File file = new File(string2);
                fsGraphQLConfig fsGraphQLConfig3 = (fsGraphQLConfig)xStream.fromXML(file);
                fsGraphQLConfig3.DataSourceId = string;
                if (fsGraphQLConfig3.EventMessageTimeoutSecs == null) {
                    fsGraphQLConfig3.EventMessageTimeoutSecs = Integer.parseInt(filesystemManager.getConfig(string + "_graphql_event_messaage_timeout", "120"));
                }
                this.QueryConfig.put(string, fsGraphQLConfig3);
                fsGraphQLConfig2 = fsGraphQLConfig3;
            }
        }
        return fsGraphQLConfig2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void discoverAvailableObjects(String string, fsConnectionGraphQL fsConnectionGraphQL2) {
        try {
            Object object;
            Object object2;
            Object object3;
            if (Util.isBlank(string)) {
                throw new Exception("Data source ID must be specified");
            }
            FilesystemManager filesystemManager = FilesystemManager.getInstance();
            int n2 = Integer.parseInt(filesystemManager.getConfig(string + "_metadata_timeout", "1440"));
            this.getGraphQLConfig(string);
            boolean bl = false;
            fsGraphQLMetaData fsGraphQLMetaData2 = this.DataDefinitions.get(string);
            if (fsGraphQLMetaData2 == null) {
                bl = true;
            } else {
                object3 = fsGraphQLMetaData2.DataTimestamp;
                if (object3 == null) {
                    bl = true;
                } else {
                    object2 = new Date();
                    object = Util.dateOffset((Date)object3, n2, 12);
                    bl = ((Date)object2).after((Date)object);
                }
            }
            if (!bl) return;
            Util_Logger.debug(logger, "Preparing GraphQL Schema query request to : " + fsConnectionGraphQL2.getBaseURL());
            object3 = new fsGraphQLMetaData();
            object2 = new fsGraphQLPayload();
            ((fsGraphQLPayload)object2).query = "{\n  __schema {\n    queryType {\n      fields {\n        name\n        description\n        type{\n          kind\n          name\n          ofType {\n            name          }\n        }\n      }\n    }\n  }\n}";
            object = JsonUtilities.toJson(object2);
            Util_Logger.debug(logger, "GraphQL Schema query request: " + (String)object);
            WebHttpResponse webHttpResponse = fsConnectionGraphQL2.readData((String)object);
            if (webHttpResponse.ReturnCode != 200) throw new Exception("Error extracting meta data, return code = " + webHttpResponse.ReturnCode + ": " + webHttpResponse.Body);
            Util_Logger.debug(logger, "GraphQL schema query response: " + webHttpResponse.Body);
            Object object4 = webHttpResponse.Body;
            object4 = JsonUtilities.getJsonObject((String)object4, "data");
            object4 = JsonUtilities.getJsonObject((String)object4, "__schema");
            object4 = JsonUtilities.getJsonObject((String)object4, "queryType");
            Object object5 = JsonUtilities.fromJson((String)object4, fsGraphQLMetaData.fsGraphQLObjectDefinitions.class);
            if (object5 == null) throw new Exception("Unable to deserialize schema definition");
            if (((fsGraphQLMetaData.fsGraphQLObjectDefinitions)object5).fields == null) throw new Exception("Unable to deserialize schema definition fields");
            for (fsGraphQLMetaData.fsGraphQLObjectDefinition fsGraphQLObjectDefinition2 : ((fsGraphQLMetaData.fsGraphQLObjectDefinitions)object5).fields) {
                this.processSchemaObjectDefinition(fsConnectionGraphQL2, (fsGraphQLMetaData)object3, fsGraphQLObjectDefinition2, true);
            }
            object2 = new fsGraphQLPayload();
            ((fsGraphQLPayload)object2).query = "{\n  __schema {\n    types {\n      name\n      fields {\n        name\n        type {\n          kind\n          name\n          ofType {\n            name          }\n        }\n      }\n    }\n  }\n}";
            object = JsonUtilities.toJson(object2);
            Util_Logger.debug(logger, "GraphQL Schema query request: " + (String)object);
            webHttpResponse = fsConnectionGraphQL2.readData((String)object);
            if (webHttpResponse.ReturnCode != 200) throw new Exception("Error extracting meta data, return code = " + webHttpResponse.ReturnCode + ": " + webHttpResponse.Body);
            Util_Logger.debug(logger, "GraphQL schema query response: " + webHttpResponse.Body);
            object4 = webHttpResponse.Body;
            object4 = JsonUtilities.getJsonObject((String)object4, "data");
            object4 = JsonUtilities.getJsonObject((String)object4, "__schema");
            object5 = JsonUtilities.fromJson((String)object4, fsGraphQLMetaData.fsGraphQLTypeDefinitionsList.class);
            if (object5 == null) throw new Exception("Unable to deserialize schema definition");
            if (((fsGraphQLMetaData.fsGraphQLTypeDefinitionsList)object5).types == null) throw new Exception("Unable to deserialize schema definition fields");
            for (fsGraphQLMetaData.fsGraphQLObjectDefinitions fsGraphQLObjectDefinitions2 : ((fsGraphQLMetaData.fsGraphQLTypeDefinitionsList)object5).types) {
                fsGraphQLObjectDefinitions2.isObject = false;
                ((fsGraphQLMetaData)object3).DataDefinitions.put(fsGraphQLObjectDefinitions2.name, fsGraphQLObjectDefinitions2);
            }
            object4 = this.DataDefinitions;
            synchronized (object4) {
                this.DataDefinitions.put(string, (fsGraphQLMetaData)object3);
            }
            int n3 = 0;
            int n4 = 0;
            for (fsGraphQLMetaData.fsGraphQLObjectDefinitions fsGraphQLObjectDefinitions3 : ((fsGraphQLMetaData)object3).DataDefinitions.values()) {
                if (fsGraphQLObjectDefinitions3.isObject) {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            Util_Logger.info(logger, "Discovered " + n3 + " GraphQL objects and " + n4 + " type definitions available from data source [" + string + "]");
            return;
        }
        catch (Exception exception) {
            Util_Logger.errorNoRaise(logger, "Error extracting meta data from " + fsConnectionGraphQL2.getBaseURL() + ": " + exception.getMessage(), exception);
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by JSON serialisation")
    private void buildObjectAttributes(String string, String string2, StringBuilder stringBuilder, boolean bl) throws Exception {
        if (this.DataDefinitions != null) {
            fsGraphQLMetaData fsGraphQLMetaData2 = this.DataDefinitions.get(string);
            if (fsGraphQLMetaData2 == null) {
                throw new Exception("GraphQL data definitions not available for data source [" + string + "]");
            }
            if (fsGraphQLMetaData2.DataDefinitions == null) {
                throw new Exception("GraphQL data definitions not available for data source [" + string + "]");
            }
            fsGraphQLMetaData.fsGraphQLObjectDefinitions fsGraphQLObjectDefinitions2 = fsGraphQLMetaData2.DataDefinitions.get(string2);
            if (fsGraphQLObjectDefinitions2 == null) {
                throw new Exception("GraphQL data definitions not available for object [" + string2 + "] in data source [" + string + "]");
            }
            if (fsGraphQLObjectDefinitions2.fields == null) {
                throw new Exception("GraphQL data definitions not available for object [" + string2 + "] in data source [" + string + "]");
            }
            if (bl) {
                stringBuilder.append("{ ");
            }
            for (fsGraphQLMetaData.fsGraphQLObjectDefinition fsGraphQLObjectDefinition2 : fsGraphQLObjectDefinitions2.fields) {
                if (fsGraphQLObjectDefinition2.type.kind.equalsIgnoreCase(TYPE_OBJECT)) {
                    stringBuilder.append(fsGraphQLObjectDefinition2.name);
                    stringBuilder.append(" ");
                    this.buildObjectAttributes(string, fsGraphQLObjectDefinition2.name, stringBuilder, true);
                    continue;
                }
                if (fsGraphQLObjectDefinition2.type.kind.equalsIgnoreCase(TYPE_LIST)) {
                    stringBuilder.append(fsGraphQLObjectDefinition2.name);
                    stringBuilder.append(" ");
                    this.buildObjectAttributes(string, fsGraphQLObjectDefinition2.type.ofType.name, stringBuilder, true);
                    continue;
                }
                stringBuilder.append(fsGraphQLObjectDefinition2.name);
                stringBuilder.append(" ");
            }
            if (bl) {
                stringBuilder.append("} ");
            }
        } else {
            throw new Exception("GraphQL data definitions not available");
        }
    }

    public StringBuilder buildObjectAttributes(String string, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildObjectAttributes(string, string2, stringBuilder, false);
        return stringBuilder;
    }

    public String buildGetObjectQuery(String string, String string2, Map<String, String> map) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Optional optional = map.entrySet().stream().findFirst();
        String string3 = (String)((Map.Entry)optional.get()).getKey();
        String string4 = (String)((Map.Entry)optional.get()).getValue();
        stringBuilder.append("{\n" + string2 + "(" + string3 + ": " + string4 + ")\n");
        this.buildObjectAttributes(string, string2, stringBuilder, true);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getEventSubscriptionList(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.QueryConfig == null) throw new Exception("GraphQL query configurations not loaded");
        fsGraphQLConfig fsGraphQLConfig2 = this.QueryConfig.get(string);
        if (fsGraphQLConfig2 == null) throw new Exception("GraphQL query configurations not loaded for data source [" + string + "]");
        if (fsGraphQLConfig2.Events == null) throw new Exception("GraphQL query configuration missing Events definitions for data source [" + string + "]");
        for (fsGraphQLConfig.fsGraphQLEvent fsGraphQLEvent2 : fsGraphQLConfig2.Events) {
            if (Util.isBlank(fsGraphQLEvent2.NotificationMessage)) continue;
            arrayList.add(fsGraphQLEvent2.NotificationMessage);
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private fsGraphQLConfig.fsGraphQLEvent getEventConfigForNotification(String string, String string2) throws Exception {
        fsGraphQLConfig.fsGraphQLEvent fsGraphQLEvent2 = null;
        if (this.QueryConfig == null) throw new Exception("GraphQL query configurations not loaded");
        fsGraphQLConfig fsGraphQLConfig2 = this.QueryConfig.get(string);
        if (fsGraphQLConfig2 == null) throw new Exception("GraphQL query configurations not loaded for data source [" + string + "]");
        if (fsGraphQLConfig2.Events == null) throw new Exception("GraphQL query configuration missing Events definitions for data source [" + string + "]");
        for (fsGraphQLConfig.fsGraphQLEvent fsGraphQLEvent3 : fsGraphQLConfig2.Events) {
            if (!fsGraphQLEvent3.NotificationMessage.equalsIgnoreCase(string2)) continue;
            fsGraphQLEvent2 = fsGraphQLEvent3;
            break;
        }
        if (fsGraphQLEvent2 != null) return fsGraphQLEvent2;
        throw new Exception("GraphQL query configuration missing Notification Message [" + string2 + "] definitions for data source [" + string + "]");
    }

    private fsFileInfo getNewReport(fsGraphQLConfig.fsGraphQLReport fsGraphQLReport2, String string, Integer n2, fsEventData fsEventData2) throws Exception {
        String string2 = fsGraphQLReport2.Filename;
        if (Util.isBlank(string2)) {
            Util_Logger.warning(logger, "Missing Filename attribute for GraphQL report [" + fsGraphQLReport2.Id + "], applying default output filename");
            string2 = "public_{event_id}_{date:yyyyMMddHHmmssSSS}.json";
        }
        fsFileInfo fsFileInfo2 = new fsFileInfo();
        fsFileInfo2.setFileType(fsFileTypeEnum.FILE);
        fsFileInfo2.setSize(null);
        fsFileInfo2.setModifiedDate(null, false);
        if (fsEventData2 != null) {
            fsEventData2.setEventData(fsGraphQLReport2);
            fsFileInfo2.setEventData(fsEventData2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!Util.isBlank(string)) {
            hashMap.put("event_id", string);
        }
        hashMap.put("report_id", fsGraphQLReport2.Id);
        if (n2 != null) {
            hashMap.put("version", n2.toString());
        }
        if (fsEventData2 != null && fsEventData2.getEventParameters() != null) {
            hashMap.putAll(fsEventData2.getEventParameters());
        }
        String string3 = FileNameTokenResolver.process(string2, hashMap);
        fsFileInfo2.setFilename(string3);
        return fsFileInfo2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by XML serialisation")
    private List<fsFileInfo> getNonEventReports(String string, Integer n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        if (this.QueryConfig == null) throw new Exception("GraphQL query configurations not loaded");
        fsGraphQLConfig fsGraphQLConfig2 = this.QueryConfig.get(string);
        if (fsGraphQLConfig2 == null) throw new Exception("GraphQL query configurations not loaded for data source [" + string + "]");
        if (fsGraphQLConfig2.Events == null) throw new Exception("GraphQL query configuration missing Events definitions for data source [" + string + "]");
        for (fsGraphQLConfig.fsGraphQLEvent fsGraphQLEvent2 : fsGraphQLConfig2.Events) {
            if (!Util.isBlank(fsGraphQLEvent2.NotificationMessage)) continue;
            for (fsGraphQLConfig.fsGraphQLReport fsGraphQLReport2 : fsGraphQLEvent2.Reports) {
                fsFileInfo fsFileInfo2 = this.getNewReport(fsGraphQLReport2, fsGraphQLEvent2.Id, n2, null);
                arrayList.add(fsFileInfo2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="Objects populated by XML serialisation")
    public List<fsFileInfo> getNewReportsForEvent(String string, List<fsEventData> list, String string2, Integer n2, int n3) throws Exception {
        Object object;
        Iterator iterator;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (list != null) {
            for (fsEventData arrayList3 : list) {
                Util_Logger.debug(logger, "Detected event : " + arrayList3.getEventId());
                iterator = this.getEventConfigForNotification(string2, arrayList3.getEventId());
                for (fsGraphQLConfig.fsGraphQLReport fsGraphQLReport2 : ((fsGraphQLConfig.fsGraphQLEvent)((Object)iterator)).Reports) {
                    object = this.getNewReport(fsGraphQLReport2, arrayList3.getEventId(), n2, arrayList3);
                    arrayList2.add(object);
                }
            }
        }
        List<Object> list2 = null;
        Map<String, List<fsFileInfo>> map = this.ReportingEvents;
        synchronized (map) {
            this.getGraphQLConfig(string2);
            iterator = Util.dateOffset(new Date(), -120, 13);
            Object object2 = this.QueryConfig.get(string2);
            if (object2 != null) {
                iterator = Util.dateOffset(new Date(), -((fsGraphQLConfig)object2).EventMessageTimeoutSecs.intValue(), 13);
            }
            ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
            object = new ArrayList();
            ArrayList<fsFileInfo> arrayList3 = new ArrayList<fsFileInfo>();
            list2 = this.ReportingEvents.get(string2);
            if (list2 != null) {
                for (fsFileInfo fsFileInfo2 : list2) {
                    if (fsFileInfo2.isCompleted()) {
                        arrayList.add(fsFileInfo2);
                        continue;
                    }
                    if (fsFileInfo2.getProcessAttempts() > n3) {
                        object.add(fsFileInfo2);
                        continue;
                    }
                    if (fsFileInfo2.getEventData() == null || fsFileInfo2.getProcessAttempts() != 0 || !fsFileInfo2.getEventData().getEventDate().before((Date)((Object)iterator))) continue;
                    arrayList3.add(fsFileInfo2);
                }
            }
            if (!arrayList.isEmpty()) {
                for (fsFileInfo fsFileInfo2 : arrayList) {
                    list2.remove(fsFileInfo2);
                }
            }
            if (!object.isEmpty()) {
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    fsFileInfo fsFileInfo2;
                    fsFileInfo2 = (fsFileInfo)iterator2.next();
                    Util_Logger.warning(logger, "Expiring GraphQL event based report " + fsFileInfo2.getFilename() + "] as it has exceeded maximum process attempts [" + n3 + "] without successfully completing");
                    list2.remove(fsFileInfo2);
                }
            }
            if (!arrayList3.isEmpty()) {
                for (fsFileInfo fsFileInfo2 : arrayList3) {
                    Util_Logger.info(logger, "Expiring GraphQL event based report " + fsFileInfo2.getFilename() + "] as it has not been processed by a worker thread. Check worker thread include/exclude masks");
                    list2.remove(fsFileInfo2);
                }
            }
            if (list2 == null) {
                list2 = new ArrayList();
                this.ReportingEvents.put(string2, list2);
            }
            list2.addAll(arrayList2);
        }
        FilesystemManager.getInstance().processedNewFileEvent(string, list);
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        for (Object object2 : list2) {
            if (((fsFileInfo)object2).getProcessAttempts() != 0) continue;
            arrayList.add((fsFileInfo)object2);
        }
        for (Object object2 : list2) {
            if (((fsFileInfo)object2).getProcessAttempts() <= 0) continue;
            arrayList.add((fsFileInfo)object2);
        }
        return arrayList;
    }

    public List<fsFileInfo> getNewReportsPeriodic(String string, Integer n2) throws Exception {
        ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>();
        arrayList.addAll(this.getNonEventReports(string, n2));
        return arrayList;
    }

    private static class SingletonHolder {
        private static fsGraphQLDataManager instance = new fsGraphQLDataManager();

        private SingletonHolder() {
        }
    }
}

