/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.FileSystem;

import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.FileSystem.fsConnectionFactoryInt;
import au.com.aemo.Common.FileSystem.fsConnectionFileFilterInt;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileComparatorInt;
import au.com.aemo.Common.FileSystem.fsFileComparatorManager;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileMaskSpecification;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class fsPurgeThreadRec
implements fsConnectionFileFilterInt {
    private static Logger logger = LoggerFactory.getLogger(fsPurgeThreadRec.class);
    private String itsId;
    private String itsDirectory;
    private int itsRententionMins;
    private int itsMaxNoFiles;
    private long itsMaxSizeMB;
    private int itsPurgeFrequencyMins;
    private FileMaskSpecification itsFileMaskSpec;
    private Date itsLastRun;
    private Date itsLastRunPurgeDate;
    private Date itsNextRun;
    private String itsDataSource;

    public fsPurgeThreadRec(String string, String string2, String string3, int n2, int n3, int n4, int n5, FileMaskSpecification fileMaskSpecification) {
        this.itsId = string;
        this.itsDataSource = string2;
        this.itsDirectory = string3;
        this.itsRententionMins = n2;
        this.itsMaxNoFiles = n3;
        this.itsMaxSizeMB = n4;
        this.itsPurgeFrequencyMins = n5;
        this.itsFileMaskSpec = fileMaskSpecification;
    }

    public String getId() {
        return this.itsId;
    }

    @Override
    public String getServerDirectoryListingFileMask() {
        return null;
    }

    @Override
    public boolean accept(fsFileInfo fsFileInfo2) {
        boolean bl;
        boolean bl2 = bl = !fsFileInfo2.isDirectory();
        if (bl) {
            boolean bl3 = bl = this.itsRententionMins > 0 || this.itsMaxNoFiles > 0 || this.itsMaxSizeMB > 0L;
        }
        if (bl) {
            bl = this.itsFileMaskSpec.checkFileMask(fsFileInfo2.getFilename());
        }
        return bl;
    }

    @Override
    public String getOutputFilenameMask() {
        return null;
    }

    @Override
    public String getAPIHeaderValues() {
        return null;
    }

    @Override
    public String getDirListAPIHeaderValues() {
        return null;
    }

    @Override
    public String getAckAPIHeaderValues() {
        return null;
    }

    private boolean runAgain(Date date) {
        if (this.itsNextRun == null) {
            return true;
        }
        return date.after(this.itsNextRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPurge() throws Exception {
        FilesystemManager filesystemManager = FilesystemManager.getInstance();
        String string = null;
        string = Util.isBlank(this.itsDataSource) ? filesystemManager.getInternalProtocol() : filesystemManager.getDataSource(this.itsDataSource).getProtocol();
        fsConnectionFactoryInt fsConnectionFactoryInt2 = filesystemManager.getDataSourceFactory(string);
        fsConnectionInt fsConnectionInt2 = null;
        try {
            fsConnectionInt2 = fsConnectionFactoryInt2.getConnection("purge_" + this.itsId);
            Map<String, fsFileInfo> map = fsConnectionInt2.listFiles(this.itsDirectory, this, null);
            ArrayList<fsFileInfo> arrayList = new ArrayList<fsFileInfo>(map.values());
            if (arrayList != null) {
                fsFileComparatorInt fsFileComparatorInt2 = fsFileComparatorManager.getInstance().getComparator("OLDEST");
                Collections.sort(arrayList, fsFileComparatorInt2);
                int n2 = 0;
                long l2 = 0L;
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    String string2;
                    long l3;
                    boolean bl = false;
                    fsFileInfo fsFileInfo2 = (fsFileInfo)arrayList.get(i2);
                    if (this.itsRententionMins > 0) {
                        boolean bl2 = bl = fsFileInfo2.getModifiedDate().getTime() < this.itsLastRunPurgeDate.getTime();
                    }
                    if (this.itsMaxNoFiles > 0 && i2 >= this.itsMaxNoFiles) {
                        bl = true;
                    }
                    if (this.itsMaxSizeMB > 0L && (l2 += (l3 = fsFileInfo2.getSize().longValue())) > this.itsMaxSizeMB * 1024L * 1024L) {
                        bl = true;
                    }
                    LockManager lockManager = LockManager.getInstance();
                    if (!bl || !lockManager.addTask(string2 = fsFileInfo2.getFilename())) continue;
                    try {
                        fsConnectionInt2.deleteFile(fsFileInfo2);
                        Util_Logger.debug(logger, "Purged file " + fsFileInfo2.getPath());
                        ++n2;
                        continue;
                    }
                    catch (Exception exception) {
                        Util_Logger.errorNoRaise(logger, "Error purging file [" + fsFileInfo2.getFilename() + "]: " + exception.getMessage(), exception);
                        continue;
                    }
                    finally {
                        lockManager.deleteTask(string2);
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (this.itsRententionMins > 0) {
                    stringBuffer.append(" with last modified date < " + Util.dateToStr(this.itsLastRunPurgeDate, "dd-MM-yyyy HH:mm:ss"));
                }
                if (this.itsMaxNoFiles > 0) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and");
                    }
                    stringBuffer.append(" leaving only the " + this.itsMaxNoFiles + " most recent files");
                }
                if (this.itsMaxSizeMB > 0L) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" and");
                    }
                    stringBuffer.append(" removing the oldest files to limit total size to a maximum of " + this.itsMaxSizeMB + "MB");
                }
                Util_Logger.info(logger, "Purged " + n2 + " files from directory " + this.itsDirectory + stringBuffer.toString());
            }
            fsConnectionFactoryInt2.freeConnection(fsConnectionInt2);
        }
        catch (Throwable throwable) {
            fsConnectionFactoryInt2.freeConnection(fsConnectionInt2);
            throw throwable;
        }
    }

    public void runCheck() throws Exception {
        Date date = new Date();
        if (this.runAgain(date)) {
            this.itsLastRunPurgeDate = Util.dateOffset(date, -this.itsRententionMins, 12);
            this.doPurge();
            this.itsLastRun = new Date();
            this.itsNextRun = Util.dateOffset(this.itsLastRun, this.itsPurgeFrequencyMins, 12);
        }
    }
}

