/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Files;

import au.com.aemo.Common.Java.Util;

public class FilesystemStatus {
    private String Path;
    private String Name;
    private String DisplayName;
    private long TotalBytes;
    private long UsedBytes;
    private long AvailBytes;
    private double PercentFree;
    private double PercentFull;

    public FilesystemStatus(String string, String string2) {
        this.Path = string;
        this.Name = string2;
        this.DisplayName = "(" + this.getPath() + ")";
        if (!Util.isBlank(this.getName())) {
            this.DisplayName = this.DisplayName + " " + this.getName();
        }
    }

    private void deriveValues() {
        if (this.TotalBytes > 0L) {
            this.PercentFree = (double)this.AvailBytes / (double)this.TotalBytes;
            this.PercentFull = (double)this.UsedBytes / (double)this.TotalBytes;
        }
    }

    public String getPath() {
        return this.Path;
    }

    public long getTotalBytes() {
        return this.TotalBytes;
    }

    public void setTotalBytes(long l2) {
        this.TotalBytes = l2;
        this.deriveValues();
    }

    public long getUsedBytes() {
        return this.UsedBytes;
    }

    public void setUsedBytes(long l2) {
        this.UsedBytes = l2;
        this.deriveValues();
    }

    public long getAvailBytes() {
        return this.AvailBytes;
    }

    public void setAvailBytes(long l2) {
        this.AvailBytes = l2;
        this.deriveValues();
    }

    public double getPercentFree() {
        return this.PercentFree;
    }

    public double getPercentFull() {
        return this.PercentFull;
    }

    public String getName() {
        return this.Name;
    }

    public String getDisplayName() {
        return this.DisplayName;
    }
}

