/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Jobs;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.JobTaskInt;
import au.com.aemo.Common.Jobs.LockEngineDistributed;
import au.com.aemo.Common.Jobs.LockEngineInt;
import au.com.aemo.Common.Jobs.LockEngineInternal;
import au.com.aemo.Common.Jobs.LockManagerConfig;
import au.com.aemo.Common.Network.DistributedMessagingManager;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static Logger logger = LoggerFactory.getLogger(LockManager.class);
    public static final String LOCK_ENGINE_INTERNAL = "INTERNAL";
    public static final String LOCK_ENGINE_DISTRIBUTED = "DISTRIBUTED";
    private LockEngineInt itsLockEngine = new LockEngineInternal();

    private LockManager() {
    }

    public static LockManager getInstance() {
        return SingletonHolder.instance;
    }

    public static LockManagerConfig loadConfigFromProperties(Properties properties) {
        LockManagerConfig lockManagerConfig = new LockManagerConfig();
        lockManagerConfig.LockEngine = Util.getProperty(properties, "lock_manager_engine", LOCK_ENGINE_INTERNAL);
        lockManagerConfig.PriorityBumpEnabled = Util.getProperty(properties, "lock_manager_priority_bump_enabled", "true").equalsIgnoreCase("true");
        return lockManagerConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(LockManagerConfig lockManagerConfig) throws Exception {
        if (Util.isBlank(lockManagerConfig.LockEngine)) {
            throw new Exception("Locking engine is not defined in application configuration");
        }
        if (lockManagerConfig.LockEngine.equalsIgnoreCase(LOCK_ENGINE_DISTRIBUTED)) {
            if (!DistributedMessagingManager.getInstance().isEnabled()) throw new Exception("Missing configuration for distributed messaging within application configuration file, cannot use distributed locking engine");
            this.itsLockEngine = new LockEngineDistributed();
        } else {
            if (!lockManagerConfig.LockEngine.equalsIgnoreCase(LOCK_ENGINE_INTERNAL)) throw new Exception("Locking engine type " + lockManagerConfig.LockEngine + " is not supported");
            this.itsLockEngine = new LockEngineInternal();
        }
        this.itsLockEngine.initialise(lockManagerConfig);
    }

    public boolean addTask(String string) {
        return this.addTask(string, null);
    }

    public boolean addTask(String string, JobTaskInt jobTaskInt) {
        return this.itsLockEngine.addTask(string, jobTaskInt);
    }

    public void deleteTask(String string) {
        this.itsLockEngine.deleteTask(string);
    }

    public void cleanQueue(Thread thread) {
        this.itsLockEngine.cleanQueue(thread);
    }

    private static class SingletonHolder {
        private static LockManager instance = new LockManager();

        private SingletonHolder() {
        }
    }
}

