/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Threading;

import au.com.aemo.Common.Application.AppConfiguration;
import au.com.aemo.Common.Application.ApplicationExtensionInt;
import au.com.aemo.Common.Application.ApplicationManager;
import au.com.aemo.Common.Application.InstanceLockManager;
import au.com.aemo.Common.Certificate.CertificateManager;
import au.com.aemo.Common.FileSystem.FilesystemManager;
import au.com.aemo.Common.Files.FilesystemMonitor;
import au.com.aemo.Common.Files.FilesystemStatus;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Threading.managedThread;
import au.com.aemo.Common.Threading.threadMonitorCheckInt;
import au.com.aemo.Common.Threading.threadMonitorStatusItem;
import au.com.aemo.Common.Web.WebServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class threadMonitor
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(threadMonitor.class);
    private static final int DAILY_REPORT_TIME = 9;
    private List<managedThread> itsThreadsManaged = new ArrayList<managedThread>();
    private List<threadMonitorCheckInt> itsChecks = new ArrayList<threadMonitorCheckInt>();
    private int itsSleep = 5000;
    private volatile boolean itsIsRunning = true;
    private String itsAppName;
    private String itsAppVersion;
    private Class itsAppClass;
    private int itsStatusReportInterval = 3600000;
    private boolean itsDoneDailyReport = false;

    private threadMonitor() {
    }

    public static threadMonitor getInstance() {
        return SingletonHolder.instance;
    }

    @SuppressFBWarnings(value={"DM_STRING_CTOR"}, justification="Avoid holding object references")
    public void setAppDetails(AppConfiguration appConfiguration) {
        this.itsAppName = new String(appConfiguration.AppName);
        this.itsAppVersion = new String(appConfiguration.AppVersion);
        this.itsAppClass = appConfiguration.AppClass;
        this.itsStatusReportInterval = appConfiguration.ThreadStatusReportingInterval * 1000;
    }

    public void addThreadManaged(Runnable runnable, String string, boolean bl) {
        this.addThreadManaged(runnable, string, bl, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThreadManaged(Runnable runnable, String string, boolean bl, int n2) {
        managedThread managedThread2 = new managedThread();
        managedThread2.itsClass = runnable;
        managedThread2.itsIsDaemon = bl;
        managedThread2.itsName = string;
        managedThread2.itsThreadPriority = n2;
        this.startManagedThread(managedThread2);
        List<managedThread> list = this.itsThreadsManaged;
        synchronized (list) {
            this.itsThreadsManaged.add(managedThread2);
        }
    }

    private void startManagedThread(managedThread managedThread2) {
        Util_Logger.info(logger, (managedThread2.itsThread == null ? "Starting" : "Restarting") + " managed thread [" + managedThread2.itsName + "]");
        Thread thread = new Thread(managedThread2.itsClass);
        thread.setDaemon(managedThread2.itsIsDaemon);
        thread.setName(managedThread2.itsName);
        thread.setPriority(managedThread2.itsThreadPriority);
        thread.start();
        managedThread2.itsThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCheck(threadMonitorCheckInt threadMonitorCheckInt2) {
        List<threadMonitorCheckInt> list = this.itsChecks;
        synchronized (list) {
            this.itsChecks.add(threadMonitorCheckInt2);
        }
    }

    public URL getAppLocation() {
        return this.itsAppClass.getProtectionDomain().getCodeSource().getLocation();
    }

    public threadMonitorStatusItem getStatus() {
        List<FilesystemStatus> list;
        Object object;
        threadMonitorStatusItem threadMonitorStatusItem2 = new threadMonitorStatusItem("Status Report");
        threadMonitorStatusItem2.addItem("Application", this.itsAppName + " v" + this.itsAppVersion);
        try {
            object = this.getAppLocation();
            threadMonitorStatusItem2.addItem("Installed at", ((URL)object).toString());
            list = ((URL)object).openConnection();
            threadMonitorStatusItem2.addItem("Executable timestamp", Util.dateToStr(new Date(((URLConnection)((Object)list)).getLastModified()), "dd/MM/yyyy HH:mm:ss"));
            ((URLConnection)((Object)list)).getInputStream().close();
            list = null;
            object = null;
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Detected error preparing status report: " + exception.getMessage(), exception);
        }
        object = ApplicationManager.getInstance().getExtensions();
        if (object != null && !object.isEmpty()) {
            list = new threadMonitorStatusItem("Extensions");
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                ApplicationExtensionInt object2 = (ApplicationExtensionInt)iterator.next();
                ((threadMonitorStatusItem)((Object)list)).addItem(object2.name(), object2.version());
            }
            threadMonitorStatusItem2.addItem((threadMonitorStatusItem)((Object)list));
        }
        threadMonitorStatusItem2.addItem("Start time", Util.dateToStr(ApplicationManager.getInstance().getStartDate(), "dd/MM/yyyy HH:mm:ss"));
        threadMonitorStatusItem2.addItem("Java", System.getProperty("java.vendor") + " v" + System.getProperty("java.version"));
        threadMonitorStatusItem2.addItem("Operating System", System.getProperty("os.name") + " v" + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        threadMonitorStatusItem2.addItem("Free memory (Mb)", String.format("%,d", Runtime.getRuntime().freeMemory() / 0x100000L));
        threadMonitorStatusItem2.addItem("Total memory (Mb)", String.format("%,d", Runtime.getRuntime().totalMemory() / 0x100000L));
        try {
            threadMonitorStatusItem2.addItem("Hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Detected error preparing status report: " + exception.getMessage(), exception);
        }
        try {
            list = ManagementFactory.getRuntimeMXBean();
            threadMonitorStatusItem2.addItem("Process ID", list.getName());
        }
        catch (Exception exception) {
            Util_Logger.warning(logger, "Detected error preparing status report: " + exception.getMessage(), exception);
        }
        list = FilesystemMonitor.getInstance().getStatus();
        if (list != null) {
            for (FilesystemStatus filesystemStatus : list) {
                threadMonitorStatusItem2.addItem(String.format("Filesystem [%s] usage", filesystemStatus.getDisplayName()), String.format("%.1f %s", filesystemStatus.getPercentFull() * 100.0, "%"));
            }
        }
        for (threadMonitorCheckInt threadMonitorCheckInt2 : this.itsChecks) {
            threadMonitorStatusItem threadMonitorStatusItem3 = threadMonitorCheckInt2.getStatusReport();
            threadMonitorStatusItem2.addItem(threadMonitorStatusItem3);
        }
        return threadMonitorStatusItem2;
    }

    private String getStatusReportPrePend(int n2) {
        Object object = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            object = (String)object + "\t";
        }
        return object;
    }

    private int getMaxColumnWidth() {
        return 35;
    }

    private String formatStatusReport(List<threadMonitorStatusItem> list, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getStatusReportPrePend(n2);
        for (threadMonitorStatusItem threadMonitorStatusItem2 : list) {
            stringBuilder.append(string);
            String string2 = String.format("%1$-" + this.getMaxColumnWidth() + "s", Util.noNull(threadMonitorStatusItem2.getName()).trim());
            stringBuilder.append(string2);
            if (threadMonitorStatusItem2.getStatusList() == null) {
                stringBuilder.append(": ");
                stringBuilder.append(Util.noNull(threadMonitorStatusItem2.getValue()).trim());
                stringBuilder.append("\r\n");
                continue;
            }
            stringBuilder.append("\r\n");
            int n3 = n2 + 1;
            stringBuilder.append(this.formatStatusReport(threadMonitorStatusItem2.getStatusList(), n3));
        }
        return stringBuilder.toString();
    }

    public String formatStatusReport(threadMonitorStatusItem threadMonitorStatusItem2) {
        String string = "=============================================================================";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("\r\n");
        if (!threadMonitorStatusItem2.getStatusList().isEmpty()) {
            stringBuilder.append(this.formatStatusReport(threadMonitorStatusItem2.getStatusList(), 1));
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkThreads() {
        LockManager lockManager = LockManager.getInstance();
        int n2 = this.itsStatusReportInterval - 300000;
        while (this.itsIsRunning) {
            try {
                boolean bl = true;
                int n3 = 0;
                Object object = this.itsThreadsManaged;
                synchronized (object) {
                    for (managedThread managedThread2 : this.itsThreadsManaged) {
                        if (managedThread2.itsThread == null) {
                            this.startManagedThread(managedThread2);
                            continue;
                        }
                        if (!managedThread2.itsThread.isAlive()) {
                            Util_Logger.errorNoRaise(logger, "Detected that thread " + managedThread2.itsThread.getName() + " is dead");
                            bl = false;
                            lockManager.cleanQueue(managedThread2.itsThread);
                            this.startManagedThread(managedThread2);
                            continue;
                        }
                        ++n3;
                    }
                }
                object = this.itsChecks;
                synchronized (object) {
                    for (threadMonitorCheckInt threadMonitorCheckInt2 : this.itsChecks) {
                        if (!threadMonitorCheckInt2.getCheckIsAvailable()) continue;
                        Date date = Util.dateOffset(new Date(), -threadMonitorCheckInt2.getCheckBusinessCycleSeconds(), 13);
                        if (!threadMonitorCheckInt2.getCheckTimestamp().before(date)) continue;
                        if (threadMonitorCheckInt2.getCheckIsFatal()) {
                            Util_Logger.errorNoRaise(logger, "Detected inactivity timeout on " + threadMonitorCheckInt2.getCheckDescription() + ", last activity was at " + Util.dateToStr(threadMonitorCheckInt2.getCheckTimestamp(), "dd-MM-yyyy HH:mm:ss"));
                            threadMonitorCheckInt2.resetThread();
                            bl = false;
                            continue;
                        }
                        Util_Logger.warning(logger, "Detected inactivity timeout on " + threadMonitorCheckInt2.getCheckDescription() + ", last activity was at " + Util.dateToStr(threadMonitorCheckInt2.getCheckTimestamp(), "dd-MM-yyyy HH:mm:ss"));
                    }
                }
                FilesystemManager.getInstance().performInactivityCheck();
                if (bl) {
                    Util_Logger.info(logger, n3 + " threads running OK");
                }
                InstanceLockManager.getInstance().touchLockFile();
                if (n2 > this.itsStatusReportInterval) {
                    if (!Util.isBlank(this.itsAppName)) {
                        object = this.getStatus();
                        StringBuilder stringBuilder = new StringBuilder("Status Report");
                        stringBuilder.append("\r\n");
                        stringBuilder.append(this.formatStatusReport((threadMonitorStatusItem)object));
                        Util_Logger.info(logger, stringBuilder.toString());
                    }
                    n2 = 0;
                } else {
                    n2 += this.itsSleep;
                }
                FilesystemMonitor.getInstance().doFreeSpaceCheck();
                if (WebServer.getInstance().getIsEnabled()) {
                    int n4 = LocalDateTime.now().getHour();
                    if (n4 == 9) {
                        if (!this.itsDoneDailyReport) {
                            CertificateManager.getInstance().logCertificates("Trusted");
                            WebServer.getInstance().logCertificates();
                            this.itsDoneDailyReport = true;
                        }
                    } else if (n4 > 9) {
                        this.itsDoneDailyReport = false;
                    }
                }
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error in check threads: " + exception.getMessage(), exception);
            }
            try {
                Thread.sleep(this.itsSleep);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void run() {
        this.checkThreads();
    }

    public void stop() {
        this.itsIsRunning = false;
    }

    public boolean getIsRunning() {
        return this.itsIsRunning;
    }

    public void wakeUpThreads() {
        for (managedThread managedThread2 : this.itsThreadsManaged) {
            if (managedThread2.itsThread == null || !managedThread2.itsThread.isAlive() || managedThread2.itsThread.getState() != Thread.State.TIMED_WAITING) continue;
            managedThread2.itsThread.interrupt();
        }
    }

    private static class SingletonHolder {
        private static threadMonitor instance = new threadMonitor();

        private SingletonHolder() {
        }
    }
}

