/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebHandlerBase;
import au.com.aemo.Common.Web.WebServer;
import au.com.aemo.Common.Web.WebServerCache;
import au.com.aemo.Common.Web.WebServerConfig;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHandlerDocument
extends WebHandlerBase {
    private static Logger logger = LoggerFactory.getLogger(WebHandlerDocument.class);

    @Override
    public void processRequest(HttpExchange httpExchange, String string) throws IOException {
        WebServerConfig webServerConfig = WebServer.getInstance().getConfig();
        String string2 = webServerConfig.WWW_Root;
        URI uRI = httpExchange.getRequestURI();
        File file = new File(string2 + uRI.getPath()).getCanonicalFile();
        Headers headers = httpExchange.getResponseHeaders();
        if (Util.isBlank(string2)) {
            this.outputResponse(httpExchange, headers, 403, "403 (Forbidden)");
        } else if (!file.getPath().startsWith(string2)) {
            this.outputResponse(httpExchange, headers, 403, "403 (Forbidden)");
            Util_Logger.errorNoRaise(logger, "Detected suspected directory traversal attack, requested directory is " + file.getPath() + " from " + httpExchange.getRemoteAddress().getHostString());
        } else if (Util.isBlank(uRI.getPath()) || Util.noNull(uRI.getPath()).equalsIgnoreCase("/")) {
            if (!Util.isBlank(webServerConfig.WWW_Index)) {
                String string3 = httpExchange instanceof HttpsExchange ? "https" : "http";
                String string4 = string3 + "://" + httpExchange.getRequestHeaders().getFirst("Host") + webServerConfig.WWW_Index;
                headers.add("Location", string4);
                this.outputResponse(httpExchange, headers, 301, "301 (Redirect)");
            } else {
                this.outputResponse(httpExchange, headers, 404, "404 (Not Found)");
            }
        } else if (!file.isFile()) {
            this.outputResponse(httpExchange, headers, 404, "404 (Not Found)");
        } else {
            int n2;
            String string5 = file.getName().toLowerCase();
            if (string5.endsWith(".html")) {
                headers.add("Content-Type", "text/html");
            } else if (string5.endsWith(".css")) {
                headers.add("Content-Type", "text/css");
            } else if (string5.endsWith(".js")) {
                headers.add("Content-Type", "\u200bapplication/javascript");
            } else if (string5.endsWith(".svg")) {
                headers.add("Content-Type", "image/svg+xml");
            }
            byte[] byArray = null;
            try {
                WebServerCache webServerCache = WebServerCache.getInstance();
                byArray = webServerCache.getContent(file);
                n2 = 200;
            }
            catch (Exception exception) {
                Util_Logger.errorNoRaise(logger, "Error reading content from server: " + exception.getMessage(), exception);
                byArray = "Error reading content from server".getBytes();
                n2 = 503;
            }
            this.outputResponse(httpExchange, headers, n2, byArray);
        }
    }
}

