/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Web;

import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Web.WebParamException;
import au.com.aemo.Common.Web.WebParamValidationConfig;
import au.com.aemo.Common.Web.WebParamValidationEnum;
import au.com.aemo.Common.Web.WebParamValidatorTypeInt;
import java.util.Arrays;
import java.util.List;

public class WebParamValidatorTypeDecimal
implements WebParamValidatorTypeInt {
    @Override
    public List<String> getTypes() {
        return Arrays.asList("double", "java.lang.Double");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object validate(String string, WebParamValidationConfig webParamValidationConfig) throws WebParamException {
        Double d2 = null;
        if (!Util.isDouble(string)) throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getSource() + "] with value [" + string + "], aborting request");
        d2 = Double.valueOf(string);
        if (webParamValidationConfig.getValidatorParam() != WebParamValidationEnum.POSITIVE) throw new IllegalArgumentException("Unsupported validator [" + webParamValidationConfig.getValidatorParam().name() + "] for decimal parameter [" + string + "], aborting request");
        if (!(d2 <= 0.0)) return d2;
        throw new WebParamException("Invalid parameter [" + webParamValidationConfig.getName() + "] with value [" + string + "] must be > 0, aborting request");
    }
}

