/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.XML;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class xStreamDateConverter
implements Converter {
    private SimpleDateFormat formatter;
    private boolean unixTimestamp;
    private int trimLength;

    public xStreamDateConverter() {
        this("dd/MM/YYYY HH:mm:ss");
    }

    public xStreamDateConverter(String string) {
        this.formatter = new SimpleDateFormat(string);
        this.formatter.setTimeZone(TimeZone.getDefault());
        this.unixTimestamp = false;
        this.trimLength = string.length();
    }

    public xStreamDateConverter(boolean bl) {
        this.unixTimestamp = bl;
    }

    public boolean canConvert(Class clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        Date date = (Date)object;
        if (this.unixTimestamp) {
            hierarchicalStreamWriter.setValue(Long.toString(date.getTime()));
        } else {
            hierarchicalStreamWriter.setValue(this.formatter.format(date));
        }
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        Date date = null;
        try {
            if (this.unixTimestamp) {
                date = new Date(Long.parseLong(hierarchicalStreamReader.getValue()));
            } else {
                String string = hierarchicalStreamReader.getValue();
                if (string.length() > this.trimLength) {
                    string = string.substring(0, this.trimLength);
                }
                date = this.formatter.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw new ConversionException(parseException.getMessage(), (Throwable)parseException);
        }
        return date;
    }
}

