/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.Common.Zip;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtilities {
    private static Logger logger = LoggerFactory.getLogger(ZipUtilities.class);
    public static final int EOF = -1;
    private static final int BUFFER_SIZE = 512;

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="File will always have a parent directory and a filename so will never return null from either of these methods")
    public static List<String> unzip(String string, boolean bl, String string2) throws ApplicationException {
        ArrayList<String> arrayList;
        block56: {
            arrayList = new ArrayList<String>();
            try {
                if (string.toUpperCase().endsWith(".ZIP")) {
                    try (ZipFile zipFile = new ZipFile(string);){
                        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                        while (enumeration.hasMoreElements()) {
                            ZipEntry zipEntry = enumeration.nextElement();
                            String string3 = ZipUtilities.getZipEntry(zipFile, zipEntry, bl, string2);
                            if (Util.isBlank(string3)) continue;
                            arrayList.add(string3);
                        }
                        zipFile.close();
                        break block56;
                    }
                }
                if (string.toUpperCase().endsWith(".7Z")) {
                    try (SevenZFile sevenZFile = SevenZFile.builder().setSeekableByteChannel(Files.newByteChannel(Paths.get(string, new String[0]), StandardOpenOption.READ)).get();){
                        SevenZArchiveEntry sevenZArchiveEntry = sevenZFile.getNextEntry();
                        while (sevenZArchiveEntry != null) {
                            String string4 = ZipUtilities.get7ZEntry(sevenZFile, sevenZArchiveEntry, bl, string2);
                            if (!Util.isBlank(string4)) {
                                arrayList.add(string4);
                            }
                            sevenZArchiveEntry = sevenZFile.getNextEntry();
                        }
                        sevenZFile.close();
                        break block56;
                    }
                }
                if (string.toUpperCase().endsWith(".TGZ") || string.toUpperCase().endsWith(".TAR.GZ")) {
                    try (InputStream inputStream = Files.newInputStream(Paths.get(string, new String[0]), new OpenOption[0]);
                         BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                         GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)bufferedInputStream);
                         TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)gzipCompressorInputStream);){
                        TarArchiveEntry tarArchiveEntry;
                        while ((tarArchiveEntry = tarArchiveInputStream.getNextEntry()) != null) {
                            if (tarArchiveEntry.isDirectory()) continue;
                            Path path = Paths.get(string2, tarArchiveEntry.getName());
                            if (bl) {
                                path = Paths.get(string2, path.getFileName().toString());
                            } else {
                                Path path2 = path.getParent();
                                if (path2 != null && Files.notExists(path2, new LinkOption[0])) {
                                    Files.createDirectories(path2, new FileAttribute[0]);
                                }
                            }
                            Files.copy((InputStream)tarArchiveInputStream, path, StandardCopyOption.REPLACE_EXISTING);
                            arrayList.add(path.toString());
                        }
                        break block56;
                    }
                }
                if (string.toUpperCase().endsWith(".GZ")) {
                    String string5 = new File(string).getName();
                    Path path = Paths.get(string2, string5.substring(0, string5.length() - 3));
                    try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
                         FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());){
                        int n2;
                        byte[] byArray = new byte[1024];
                        while ((n2 = gZIPInputStream.read(byArray)) > 0) {
                            fileOutputStream.write(byArray, 0, n2);
                        }
                        arrayList.add(path.toString());
                        break block56;
                    }
                }
                throw new Exception("Unsupported compression file format");
            }
            catch (Exception exception) {
                Util_Logger.error(logger, "Error processing zip file " + string + ": " + exception.getMessage(), exception);
            }
        }
        return arrayList;
    }

    private static String getZipEntry(ZipFile zipFile, ZipEntry zipEntry, boolean bl, String string) throws ApplicationException {
        String string2;
        block18: {
            string2 = null;
            try {
                Object object;
                File file = null;
                file = Util.isBlank(string) ? new File(zipEntry.getName().replace('\\', '/')) : new File(string, zipEntry.getName().replace('\\', '/'));
                if (zipEntry.isDirectory()) {
                    if (!bl && file.mkdirs()) {
                        Util_Logger.info(logger, "Created target folder [" + file.getName() + "]");
                    }
                    break block18;
                }
                string2 = Util.getFileUrl(file.getPath());
                String string3 = file.getParent();
                if (string3 != null) {
                    object = new File(Util.getFileUrl(string3));
                    if (!bl && ((File)object).mkdirs()) {
                        Util_Logger.info(logger, "Creating target folder [" + ((File)object).getName() + "] for zip extraction");
                    }
                }
                object = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                    int n2;
                    while ((n2 = ((BufferedInputStream)object).read()) != -1) {
                        bufferedOutputStream.write((byte)n2);
                    }
                    bufferedOutputStream.close();
                }
                finally {
                    ((BufferedInputStream)object).close();
                }
            }
            catch (ZipException zipException) {
                Util_Logger.error(logger, "Detected zip exception: " + zipException.getMessage(), zipException);
            }
            catch (IOException iOException) {
                Util_Logger.error(logger, "Detected IO exception: " + iOException.getMessage(), iOException);
            }
        }
        return string2;
    }

    private static String get7ZEntry(SevenZFile sevenZFile, SevenZArchiveEntry sevenZArchiveEntry, boolean bl, String string) throws ApplicationException {
        String string2;
        block12: {
            string2 = null;
            try {
                Object object;
                File file = null;
                file = Util.isBlank(string) ? new File(sevenZArchiveEntry.getName()) : new File(string, sevenZArchiveEntry.getName());
                if (sevenZArchiveEntry.isDirectory()) {
                    if (!bl && file.mkdirs()) {
                        Util_Logger.info(logger, "Created target folder [" + file.getName() + "]");
                    }
                    break block12;
                }
                string2 = Util.getFileUrl(file.getPath());
                String string3 = file.getParent();
                if (string3 != null) {
                    object = new File(Util.getFileUrl(string3));
                    if (!bl && ((File)object).mkdirs()) {
                        Util_Logger.info(logger, "Creating target folder [" + ((File)object).getName() + "] for zip extraction");
                    }
                }
                object = new FileOutputStream(file);
                try {
                    byte[] byArray = new byte[(int)sevenZArchiveEntry.getSize()];
                    sevenZFile.read(byArray, 0, byArray.length);
                    ((FileOutputStream)object).write(byArray);
                    ((FileOutputStream)object).close();
                }
                finally {
                    ((FileOutputStream)object).close();
                }
            }
            catch (ZipException zipException) {
                Util_Logger.error(logger, "Detected zip exception: " + zipException.getMessage(), zipException);
            }
            catch (IOException iOException) {
                Util_Logger.error(logger, "Detected IO exception: " + iOException.getMessage(), iOException);
            }
        }
        return string2;
    }

    public static void zip(String string, List<String> list, boolean bl, boolean bl2) throws ApplicationException {
        byte[] byArray = new byte[1024];
        String string2 = new File(string).getParent();
        try {
            block66: {
                Object object;
                Object object2;
                Iterator<String> iterator;
                if (string.toUpperCase().endsWith(".ZIP")) {
                    iterator = new ZipOutputStream(new FileOutputStream(string));
                    try {
                        ((ZipOutputStream)((Object)iterator)).setLevel(-1);
                        for (String string3 : list) {
                            object2 = new FileInputStream(string3);
                            try {
                                int n2;
                                String string4 = null;
                                if (bl2) {
                                    string4 = new File(string3).getName();
                                } else {
                                    String string5 = new File(string3).getAbsolutePath();
                                    if (string5.startsWith(string2)) {
                                        string5 = string5.substring(string2.length() + 1);
                                    }
                                    string4 = string5;
                                }
                                ((ZipOutputStream)((Object)iterator)).putNextEntry(new ZipEntry(string4));
                                while ((n2 = ((FileInputStream)object2).read(byArray)) > 0) {
                                    ((ZipOutputStream)((Object)iterator)).write(byArray, 0, n2);
                                }
                                ((ZipOutputStream)((Object)iterator)).closeEntry();
                            }
                            finally {
                                ((FileInputStream)object2).close();
                            }
                        }
                        ((ZipOutputStream)((Object)iterator)).close();
                    }
                    finally {
                        ((ZipOutputStream)((Object)iterator)).close();
                    }
                }
                if (string.toUpperCase().endsWith(".7Z")) {
                    iterator = new SevenZOutputFile(new File(string));
                    for (String string6 : list) {
                        object2 = new File(string6);
                        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream((File)object2));){
                            int n3;
                            String string7 = bl2 ? ((File)object2).getName() : string6;
                            object = iterator.createArchiveEntry((File)object2, string7);
                            iterator.putArchiveEntry((SevenZArchiveEntry)object);
                            while ((n3 = bufferedInputStream.read(byArray)) > 0) {
                                iterator.write(byArray, 0, n3);
                            }
                            iterator.closeArchiveEntry();
                        }
                    }
                    iterator.close();
                } else {
                    if (string.toUpperCase().endsWith(".TGZ") || string.toUpperCase().endsWith(".TAR.GZ")) {
                        iterator = Files.newOutputStream(Paths.get(string, new String[0]), new OpenOption[0]);
                        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)((Object)iterator));
                             GzipCompressorOutputStream gzipCompressorOutputStream = new GzipCompressorOutputStream((OutputStream)bufferedOutputStream);){
                            object2 = new TarArchiveOutputStream((OutputStream)gzipCompressorOutputStream);
                            try {
                                for (String string8 : list) {
                                    object = new File(string8);
                                    TarArchiveEntry tarArchiveEntry = new TarArchiveEntry((File)object, ((File)object).getName());
                                    object2.putArchiveEntry(tarArchiveEntry);
                                    Files.copy(Paths.get(((File)object).getPath(), new String[0]), (OutputStream)object2);
                                    object2.closeArchiveEntry();
                                }
                                object2.finish();
                                break block66;
                            }
                            finally {
                                object2.close();
                            }
                        }
                        finally {
                            if (iterator != null) {
                                ((OutputStream)((Object)iterator)).close();
                            }
                        }
                    }
                    if (string.toUpperCase().endsWith(".GZ")) {
                        for (String string9 : list) {
                            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream(string));){
                                object2 = new FileInputStream(string9);
                                try {
                                    int n4;
                                    while ((n4 = ((FileInputStream)object2).read(byArray)) > 0) {
                                        gZIPOutputStream.write(byArray, 0, n4);
                                    }
                                }
                                finally {
                                    ((FileInputStream)object2).close();
                                }
                            }
                        }
                    } else {
                        throw new Exception("Unsupported compression file format");
                    }
                }
            }
            if (bl) {
                for (String string10 : list) {
                    FileUtilities.deleteFile(string10);
                }
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected zip exception: " + exception.getMessage(), exception);
        }
    }

    public static void zip(String string, String string2, boolean bl) throws ApplicationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        ZipUtilities.zip(string, arrayList, bl, true);
    }

    public static void gzip(InputStream inputStream, OutputStream outputStream) throws IOException {
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);){
            byte[] byArray = new byte[512];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) > -1) {
                gZIPOutputStream.write(byArray, 0, n2);
            }
        }
    }
}

