/*
 * Decompiled with CFR 0.152.
 */
package au.com.aemo.izpack.install;

import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Files.FilenameFilterMask;
import au.com.aemo.izpack.install.UIProcessHandlerWithLogging;
import au.com.aemo.izpack.install.propertiesFileUpdater;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class fileRecursiveDelete
implements PanelAction {
    private static final Logger logger = Logger.getLogger(fileRecursiveDelete.class.getName());
    private String theInputDirectory = "Unknown";
    private String theFileMask = "Unknown";

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {
        logger.log(Level.CONFIG, "FileRecursiveDelete: Initializing.");
        if (panelActionConfiguration == null) {
            logger.log(Level.CONFIG, "FileRecursiveDelete: Initialization failed.");
        } else {
            this.theInputDirectory = panelActionConfiguration.getProperty("inputDir", null);
            this.theFileMask = panelActionConfiguration.getProperty("fileMask", null);
            logger.log(Level.CONFIG, "FileRecursiveDelete: Initialization variable theInputDirectory=" + this.theInputDirectory + " file mask " + this.theFileMask);
        }
    }

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler abstractUIHandler) {
        logger.log(Level.CONFIG, "FileRecursiveDelete: Starting");
        try {
            if (this.theInputDirectory != null && this.theFileMask != null) {
                VariableSubstitutorImpl variableSubstitutorImpl = new VariableSubstitutorImpl(installData.getVariables());
                String string = variableSubstitutorImpl.substitute(this.theInputDirectory);
                FilenameFilterMask filenameFilterMask = new FilenameFilterMask(this.theFileMask);
                FileUtilities.deleteRecursive(string, (FilenameFilter)filenameFilterMask);
                logger.log(Level.CONFIG, "Deleted " + this.theFileMask + " from " + string);
                logger.log(Level.CONFIG, "FileRecursiveDelete: Completed");
            }
        }
        catch (Exception exception) {
            logger.log(Level.CONFIG, "Error deleting files " + this.theFileMask + " from " + this.theInputDirectory + ": " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(AbstractUIProcessHandler abstractUIProcessHandler, String[] stringArray) {
        boolean bl = false;
        UIProcessHandlerWithLogging uIProcessHandlerWithLogging = new UIProcessHandlerWithLogging(abstractUIProcessHandler, logger);
        try {
            uIProcessHandlerWithLogging.startProcess("Clearing file Updater");
            this.theInputDirectory = stringArray[0];
            this.theFileMask = stringArray[1];
            FilenameFilterMask filenameFilterMask = new FilenameFilterMask(this.theFileMask);
            FileUtilities.deleteRecursive(this.theInputDirectory, (FilenameFilter)filenameFilterMask);
            uIProcessHandlerWithLogging.logOutput("Deleted " + this.theFileMask + " from " + this.theInputDirectory, false);
            bl = true;
        }
        catch (Exception exception) {
            uIProcessHandlerWithLogging.logOutput("Error deleting files " + this.theFileMask + " from " + this.theInputDirectory + ": " + exception.getMessage(), exception);
        }
        finally {
            uIProcessHandlerWithLogging.finishProcess();
        }
        return bl;
    }

    public static void main(String[] stringArray) throws Exception {
        propertiesFileUpdater propertiesFileUpdater2 = new propertiesFileUpdater();
        propertiesFileUpdater2.run(null, stringArray);
    }
}

