/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.API;

import au.com.aemo.Common.Authentication.AuthorisationActionEnum;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.Web.WebContent;
import au.com.aemo.Common.Web.WebPOST;
import au.com.aemo.Common.Web.WebParam;
import au.com.aemo.Common.Web.WebParamValidatorTypeFormURLEncoded;
import au.com.aemo.Common.Web.WebPath;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerInt;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerManager;
import java.util.Map;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebPath(value="/api/app/control")
public class WebAPIBatcherControl {
    private static Logger logger = LoggerFactory.getLogger(WebAPIBatcherControl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WebPOST(Action=AuthorisationActionEnum.WRITE)
    @WebContent(value=WebContent.MediaType.TEXT_XML)
    public String executeJob(@WebParam(source="_body", mandatory=true, validator=WebParamValidatorTypeFormURLEncoded.class) Map<String, String> map) throws Exception {
        String string;
        String string2 = null;
        if (map == null) throw new Exception("Missing post data");
        String string3 = map.get("action");
        if (Util.isBlank(string3)) {
            throw new Exception("Missing action parameter");
        }
        if (!string3.equalsIgnoreCase("execute")) throw new Exception("Unknown action parameter");
        final int n2 = Integer.parseInt(map.get("thread_id"));
        Util_Logger.debug(logger, "Detected API execution request for thread " + n2);
        pdrBatcherHandlerManager pdrBatcherHandlerManager2 = pdrBatcherHandlerManager.getInstance();
        if (!pdrBatcherHandlerManager2.handlerExists(n2)) return "Invalid thread ID [" + n2 + "] specified in API execution request";
        final pdrBatcherHandlerInt pdrBatcherHandlerInt2 = pdrBatcherHandlerManager2.getHandler(n2);
        if (!pdrBatcherHandlerInt2.getSchedulingMode().equalsIgnoreCase("API")) throw new Exception("Cannot execute thread " + n2 + " via API control, schedule mode is " + pdrBatcherHandlerInt2.getSchedulingMode());
        final LockManager lockManager = LockManager.getInstance();
        final boolean bl = lockManager.addTask(string = "THREAD_" + n2);
        if (bl) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n22 = 60000;
                    try {
                        Util_Logger.info(logger, "Commencing API execution request for thread " + n2);
                        n22 = pdrBatcherHandlerInt2.getFailWaitInterval();
                        pdrBatcherHandlerInt2.executeCycle();
                        Util_Logger.info(logger, "Completed API execution request for thread " + n2);
                    }
                    catch (Exception exception) {
                        Util_Logger.warning(logger, "Detected error executing thread ID [" + n2 + "] via API: " + exception.getMessage(), exception);
                        try {
                            Thread.sleep(n22);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (bl) {
                            lockManager.deleteTask(string);
                        }
                    }
                }
            });
            return "Successfully requested batcher thread " + n2 + " execution cycle";
        }
        string2 = "Skipping scheduled execution of batcher thread " + n2 + " as previous job is still in progress";
        Util_Logger.info(logger, string2);
        return string2;
    }
}

