/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BatcherErrorHandler
implements ErrorHandler {
    private static Logger logger = LoggerFactory.getLogger(BatcherErrorHandler.class);
    private String errorMessage = "";

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public String getErrorMessages() {
        return this.errorMessage;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n2 = string2.lastIndexOf(47);
            if (n2 != -1) {
                string2 = string2.substring(n2 + 1);
            }
        } else {
            string2 = "";
        }
        if (this.errorMessage.length() > 0) {
            this.errorMessage = this.errorMessage + "\n";
        }
        this.errorMessage = this.errorMessage + "[" + string + "]" + string2 + ":" + sAXParseException.getLineNumber() + ":" + sAXParseException.getColumnNumber() + ":" + sAXParseException.getMessage() + ":";
    }
}

