/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor.aseXML;

import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParser;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.BatcherDOMParserFactory;
import au.com.nemmco.Pdr.Batcher.Processor.aseXML.aseXMLDocumentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class aseXMLDocumentParser {
    private static Logger logger = LoggerFactory.getLogger(aseXMLDocumentParser.class);
    private String itsDataSource;

    public aseXMLDocumentParser(String string) {
        this.itsDataSource = string;
    }

    public void parser(String string, aseXMLDocumentInfo aseXMLDocumentInfo2) {
        BatcherDOMParserFactory batcherDOMParserFactory = BatcherDOMParserFactory.getInstance();
        BatcherDOMParser batcherDOMParser = batcherDOMParserFactory.getParser(this.itsDataSource);
        Document document = null;
        try {
            document = batcherDOMParser.createDocument(string, batcherDOMParserFactory.getValidateSchema(this.itsDataSource));
            if (batcherDOMParser.getErrorMessage().trim().length() > 0) {
                aseXMLDocumentInfo2.setIsValid(false);
                aseXMLDocumentInfo2.setErrorMessage(batcherDOMParser.getErrorMessage());
            } else {
                aseXMLDocumentInfo2.setIsValid(true);
            }
        }
        catch (Exception exception) {
            aseXMLDocumentInfo2.setIsValid(false);
            aseXMLDocumentInfo2.setErrorMessage(exception.getMessage());
            Util_Logger.warning(logger, "Exception occured when parsing " + string, exception);
        }
        if (document != null) {
            String string2 = this.getAttribute(document, "ase:aseXML", "xmlns:ase");
            String[] stringArray = string2.split(":");
            String string3 = stringArray[2];
            String string4 = this.getElement(document, "From");
            String string5 = this.getAttribute(document, "From", "description");
            String string6 = this.getElement(document, "To");
            String string7 = this.getAttribute(document, "To", "description");
            String string8 = this.getElement(document, "MessageID");
            String string9 = this.getElement(document, "TransactionGroup");
            String string10 = this.getElement(document, "Priority");
            String string11 = this.getElement(document, "SecurityContext");
            String string12 = this.getAttribute(document, "MessageAcknowledgement", "initiatingMessageID");
            String string13 = this.getElement(document, "Market");
            aseXMLDocumentInfo2.setSchemaVersion(string3);
            aseXMLDocumentInfo2.setPriority(string10);
            aseXMLDocumentInfo2.setSecurityContext(string11);
            aseXMLDocumentInfo2.setTransGroup(string9);
            aseXMLDocumentInfo2.setMsgId(string8);
            aseXMLDocumentInfo2.setInitMsgId(string12);
            aseXMLDocumentInfo2.setFromName(string4);
            aseXMLDocumentInfo2.setFromDesc(string5);
            aseXMLDocumentInfo2.setToName(string6);
            aseXMLDocumentInfo2.setToDesc(string7);
            aseXMLDocumentInfo2.setMarket(string13);
        }
    }

    private String getElement(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (node == null || node.getFirstChild() == null) continue;
            stringBuffer.append(node.getFirstChild().getNodeValue());
        }
        return stringBuffer.toString();
    }

    private String getAttribute(Document document, String string, String string2) {
        String string3 = "";
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null) {
            return string3;
        }
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element = (Element)nodeList.item(i2);
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap.getNamedItem(string2) == null) continue;
            int n3 = namedNodeMap.getLength();
            for (int i3 = 0; i3 < n3; ++i3) {
                Attr attr = (Attr)namedNodeMap.item(i3);
                if (!attr.getNodeName().equals(string2)) continue;
                string3 = attr.getNodeValue();
            }
        }
        return string3;
    }
}

