/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.FileSystem.fsTransactionMetaData;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Files.FileUtilities;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.aemo.Common.XML.XmlUtilities;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerAseXMLReceiveBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class pdrBatcherHandlerAseXMLReceiveAPI
extends pdrBatcherHandlerAseXMLReceiveBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLReceiveAPI.class);

    public pdrBatcherHandlerAseXMLReceiveAPI(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
        if (this.getParticipantIdList().size() == 0) {
            Util_Logger.error(logger, "Missing configuration for [batcher_thread_" + pdrBatcherHandlerConfig2.ThreadId + "_participant_list]");
        }
    }

    @Override
    protected String getSchemaDefinitionDataSource() {
        return this.getDataSourceId();
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return false;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    @Override
    protected void completePollCycle(String string) {
        this.resetFlowControl();
    }

    @Override
    protected String getOutboxFileExtensionForProcessing() {
        return "xml";
    }

    @Override
    protected Map<String, fsFileInfo> pollSourceConnection(fsConnectionInt fsConnectionInt2, String string) throws Exception {
        HashMap<String, fsFileInfo> hashMap = new HashMap<String, fsFileInfo>();
        try {
            for (String string2 : this.getParticipantIdList()) {
                fsFileInfo fsFileInfo2 = new fsFileInfo();
                fsFileInfo2.addEventParameter("ParticipantId", string2);
                fsFileInfo2.setDirectory(FileNameTokenResolver.process(this.getSourceDirListURL(), fsFileInfo2));
                fsFileInfo2.addAPIHeaderValues(this.getSourceAPIHeaderValues());
                fsFileInfo fsFileInfo3 = fsConnectionInt2.getFile(fsFileInfo2, this.getHoldingDir());
                Document document = XmlUtilities.fileToDocument(fsFileInfo3.getPath());
                NodeList nodeList = document.getElementsByTagName("HubQueueReport");
                String string3 = XmlUtilities.xmlNodeToString(nodeList.item(0));
                XStream xStream = XmlUtilities.getConverter();
                xStream.processAnnotations(MessageMetaData.class);
                xStream.processAnnotations(HubQueueReport.class);
                HubQueueReport hubQueueReport = (HubQueueReport)xStream.fromXML(string3);
                if (hubQueueReport != null && hubQueueReport.MessageDetails != null) {
                    for (MessageMetaData messageMetaData : hubQueueReport.MessageDetails) {
                        if (Util.isBlank(messageMetaData.MessageContextID)) continue;
                        fsFileInfo fsFileInfo4 = new fsFileInfo();
                        fsFileInfo4.setDirectory(this.getSourceDir());
                        fsFileInfo4.setFilename(messageMetaData.MessageContextID + ".xml");
                        fsFileInfo4.processFilenameMask(this.getSourceFilenameMask());
                        fsFileInfo4.setModifiedDate(messageMetaData.ReceivedDateTime, true);
                        fsTransactionMetaData fsTransactionMetaData2 = new fsTransactionMetaData();
                        fsTransactionMetaData2.setTransactionGroup(messageMetaData.TransactionGroup);
                        fsTransactionMetaData2.setParticipantIdFrom(messageMetaData.FromParticipantID);
                        fsTransactionMetaData2.setPriority(messageMetaData.Priority);
                        fsTransactionMetaData2.setMessageId(messageMetaData.MessageID);
                        fsTransactionMetaData2.setMessageContextId(messageMetaData.MessageContextID);
                        fsFileInfo4.setTransactionMetaData(fsTransactionMetaData2);
                        fsFileInfo4.addEventParameter("ParticipantId", string2);
                        hashMap.put(fsFileInfo4.getFilename().toLowerCase(), fsFileInfo4);
                    }
                }
                FileUtilities.deleteFile(fsFileInfo3);
            }
        }
        catch (Exception exception) {
            Util_Logger.error(logger, "Detected exception calling HubQueueReport API: " + exception.getMessage(), exception);
        }
        Util_Logger.info(logger, "Detected [" + hashMap.size() + "] messages in hub queue");
        return hashMap;
    }

    @Override
    protected String getAckFilename(fsFileInfo fsFileInfo2, boolean bl) {
        return this.calcFilename(fsFileInfo2, "xml");
    }

    @XStreamAlias(value="MessageMetaData")
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class MessageMetaData {
        public String TransactionGroup;
        public String Priority;
        public String FromParticipantID;
        public String MessageID;
        public String MessageType;
        public String MessageContextID;
        public Date ReceivedDateTime;

        private MessageMetaData() {
        }
    }

    @XStreamAlias(value="HubQueueReport")
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class HubQueueReport {
        public int ResultCount;
        public List<MessageMetaData> MessageDetails = new ArrayList<MessageMetaData>();

        private HubQueueReport() {
        }
    }
}

