/*
 * Decompiled with CFR 0.152.
 */
package au.com.nemmco.Pdr.Batcher.Processor;

import au.com.aemo.Common.Application.ApplicationException;
import au.com.aemo.Common.FTP.FtpException;
import au.com.aemo.Common.FileSystem.fsConnectionInt;
import au.com.aemo.Common.FileSystem.fsFileInfo;
import au.com.aemo.Common.Files.FileNameTokenResolver;
import au.com.aemo.Common.Java.Util;
import au.com.aemo.Common.Jobs.LockManager;
import au.com.aemo.Common.Logging.Util_Logger;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerAseXMLReceiveBase;
import au.com.nemmco.Pdr.Batcher.Processor.pdrBatcherHandlerConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class pdrBatcherHandlerAseXMLReceiveFTP
extends pdrBatcherHandlerAseXMLReceiveBase {
    private static Logger logger = LoggerFactory.getLogger(pdrBatcherHandlerAseXMLReceiveFTP.class);
    private Map<String, DirList> itsAemoDirInboxListing = new HashMap<String, DirList>();
    private Map<String, DirList> itsAemoDirOutboxListing = new HashMap<String, DirList>();

    public pdrBatcherHandlerAseXMLReceiveFTP(pdrBatcherHandlerConfig pdrBatcherHandlerConfig2) throws ApplicationException {
        super(pdrBatcherHandlerConfig2);
    }

    @Override
    protected String getSchemaDefinitionDataSource() {
        return this.getDataSourceId();
    }

    @Override
    protected boolean requiresDestinationDirectoryListing() {
        return true;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Retain Participant ID so that directpory listing has context")
    private void getDirectoryListings(String string) throws ApplicationException {
        String string2 = string.toUpperCase();
        DirList dirList = new DirList();
        dirList.ParticipantId = string2;
        dirList.Files = this.getSourceListing(string, "OUTBOX", "INBOX");
        this.itsAemoDirInboxListing.put(string2, dirList);
        dirList = new DirList();
        dirList.ParticipantId = string2;
        dirList.Files = this.getSourceListing(string, "OUTBOX", "OUTBOX");
        this.itsAemoDirOutboxListing.put(string2, dirList);
    }

    @Override
    protected List<String> resolveSourceDirectories() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getSourceDir();
        for (String string2 : this.getParticipantIdList()) {
            if (Util.isBlank(string2)) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("ParticipantId", string2.toUpperCase());
            String string3 = FileNameTokenResolver.process(string, hashMap);
            if (arrayList.contains(string3)) continue;
            arrayList.add(string3);
        }
        if (arrayList.size() == 0) {
            throw new Exception("Missing specification for source directory");
        }
        return arrayList;
    }

    @Override
    protected boolean removeSourceFileAfterProcessing() {
        return false;
    }

    @Override
    protected boolean downloadSourceFile() {
        return true;
    }

    @Override
    protected String getOutboxFileExtensionForProcessing() {
        return "ZIP";
    }

    @Override
    protected String getAckFilename(fsFileInfo fsFileInfo2, boolean bl) {
        String string = null;
        string = bl ? this.calcFilename(fsFileInfo2, "ack") : this.calcFilename(fsFileInfo2, "nack");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void completePollCycle(String string) {
        LockManager lockManager = LockManager.getInstance();
        fsConnectionInt fsConnectionInt2 = null;
        try {
            fsConnectionInt2 = this.getSourceConnection();
            for (String string2 : this.getParticipantIdList()) {
                DirList dirList = this.itsAemoDirInboxListing.get(string2);
                if (dirList == null) {
                    this.getDirectoryListings(string2);
                    dirList = this.itsAemoDirInboxListing.get(string2);
                }
                for (fsFileInfo fsFileInfo2 : dirList.Files.values()) {
                    if (fsFileInfo2.getExtension().equalsIgnoreCase("ZIP")) continue;
                    String string3 = this.calcFilename(fsFileInfo2, "ZIP");
                    DirList dirList2 = this.itsAemoDirOutboxListing.get(string2);
                    if (dirList2.Files.containsKey(string3.toLowerCase()) || !lockManager.addTask(fsFileInfo2.getName())) continue;
                    try {
                        Util_Logger.info(logger, "Removing ack file [" + fsFileInfo2.getFilename() + "] from AEMO Inbox");
                        fsConnectionInt2.deleteFile(fsFileInfo2);
                    }
                    catch (FtpException ftpException) {
                        if (ftpException.getReplyCode() == 550) continue;
                        throw ftpException;
                    }
                    finally {
                        lockManager.deleteTask(fsFileInfo2.getName());
                    }
                }
            }
        }
        catch (Exception exception) {
            try {
                if (fsConnectionInt2 != null) {
                    fsConnectionInt2.disconnect();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            Util_Logger.errorNoRaise(logger, "Detected exception processing aseXML files: " + exception.getMessage(), exception);
        }
        finally {
            this.freeSourceConnection(fsConnectionInt2);
        }
        this.itsAemoDirInboxListing.clear();
        this.itsAemoDirOutboxListing.clear();
        this.resetFlowControl();
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC"}, justification="Class cannot be static")
    private class DirList {
        public String ParticipantId;
        public Map<String, fsFileInfo> Files = new HashMap<String, fsFileInfo>();

        private DirList() {
        }
    }
}

